/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.item.core;

import com.lothrazar.cyclicmagic.item.core.BaseTool;
import com.lothrazar.cyclicmagic.registry.SoundRegistry;
import com.lothrazar.cyclicmagic.util.UtilChat;
import com.lothrazar.cyclicmagic.util.UtilEntity;
import com.lothrazar.cyclicmagic.util.UtilItemStack;
import com.lothrazar.cyclicmagic.util.UtilNBT;
import com.lothrazar.cyclicmagic.util.UtilSound;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class BaseItemChargeScepter
extends BaseTool {
    private static final float VELOCITY_MAX = 1.5f;
    private static final float INACCURACY_DEFAULT = 1.0f;
    private static final float PITCHOFFSET = 0.0f;
    protected static final float MAX_CHARGE = 9.7f;
    private static final int TICKS_USING = 93000;
    private static final int COOLDOWN = 5;

    public BaseItemChargeScepter(int durability) {
        super(durability);
    }

    public abstract SoundEvent getSound();

    public abstract EntityThrowable createBullet(World var1, EntityPlayer var2, float var3);

    @SubscribeEvent
    public void onHit(PlayerInteractEvent.LeftClickBlock event) {
        EntityPlayer player = event.getEntityPlayer();
        ItemStack held = player.func_184586_b(event.getHand());
        if (held.func_77973_b() == this) {
            if (ActionType.getTimeout(held) > 0) {
                return;
            }
            ActionType.setTimeout(held);
            event.setCanceled(true);
            UtilSound.playSound(player, player.func_180425_c(), SoundRegistry.tool_mode, SoundCategory.PLAYERS, 0.1f);
            if (!player.func_130014_f_().field_72995_K) {
                ActionType.toggle(held);
                UtilChat.sendStatusMessage(player, UtilChat.lang(ActionType.getName(held)));
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World playerIn, List<String> tooltip, ITooltipFlag advanced) {
        tooltip.add(TextFormatting.GREEN + UtilChat.lang(ActionType.getName(stack)));
        super.func_77624_a(stack, playerIn, tooltip, advanced);
    }

    public void func_77663_a(ItemStack stack, World world, Entity entityIn, int itemSlot, boolean isSelected) {
        ActionType.tickTimeout(stack);
    }

    public int func_77626_a(ItemStack stack) {
        return 93000;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer player, EnumHand hand) {
        if (hand != EnumHand.MAIN_HAND || player.func_184811_cZ().func_185141_a(player.func_184586_b(hand).func_77973_b())) {
            return new ActionResult(EnumActionResult.FAIL, (Object)player.func_184586_b(hand));
        }
        player.func_184598_c(hand);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)player.func_184614_ca());
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BOW;
    }

    public void func_77615_a(ItemStack stack, World world, EntityLivingBase entity, int chargeTimer) {
        if (!(entity instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)entity;
        if (player.func_184811_cZ().func_185141_a(stack.func_77973_b())) {
            return;
        }
        int charge = this.func_77626_a(stack) - chargeTimer;
        float percentageCharged = ItemBow.func_185059_b((int)charge);
        float amountCharged = percentageCharged * 9.7f;
        float velocityFactor = percentageCharged * 1.5f;
        float damage = MathHelper.func_76141_d((float)amountCharged) / 2;
        int shots = 0;
        switch (ActionType.getAction(stack)) {
            case TRIPLE: {
                this.shootTwins(world, player, velocityFactor, damage);
                this.shootMain(world, player, velocityFactor, damage);
                shots = 3;
                break;
            }
            case DOUBLE: {
                this.shootTwins(world, player, velocityFactor, damage);
                shots = 2;
                break;
            }
            case SINGLE: {
                this.shootMain(world, player, velocityFactor, damage);
                shots = 1;
                break;
            }
        }
        UtilItemStack.damageItem(player, stack, shots);
        UtilEntity.setCooldownItem(player, stack.func_77973_b(), 5);
        super.func_77615_a(stack, world, entity, chargeTimer);
        player.func_184609_a(EnumHand.MAIN_HAND);
    }

    protected EntityThrowable shootMain(World world, EntityPlayer player, float velocityFactor, float damage) {
        EntityThrowable proj = this.createBullet(world, player, damage);
        this.launchProjectile(world, player, proj, velocityFactor * 1.5f);
        return proj;
    }

    private void shootTwins(World world, EntityPlayer player, float velocityFactor, float damage) {
        Vec3d vecCrossRight = player.func_70040_Z().func_72432_b().func_72431_c(new Vec3d(0.0, 2.0, 0.0));
        Vec3d vecCrossLeft = player.func_70040_Z().func_72432_b().func_72431_c(new Vec3d(0.0, -2.0, 0.0));
        EntityThrowable projRight = this.createBullet(world, player, damage);
        projRight.field_70165_t += vecCrossRight.field_72450_a;
        projRight.field_70161_v += vecCrossRight.field_72449_c;
        this.launchProjectile(world, player, projRight, velocityFactor * 1.5f);
        EntityThrowable projLeft = this.createBullet(world, player, damage);
        projLeft.field_70165_t += vecCrossLeft.field_72450_a;
        projLeft.field_70161_v += vecCrossLeft.field_72449_c;
        this.launchProjectile(world, player, projLeft, velocityFactor * 1.5f);
    }

    protected void launchProjectile(World world, EntityPlayer player, EntityThrowable thing, float velocity) {
        if (!world.field_72995_K) {
            thing.func_184538_a((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, velocity, 1.0f);
            world.func_72838_d((Entity)thing);
        }
        BlockPos pos = player.func_180425_c();
        UtilSound.playSound(player, pos, this.getSound(), SoundCategory.PLAYERS);
    }

    public static enum ActionType {
        SINGLE,
        DOUBLE,
        TRIPLE;

        private static final String NBT = "ActionType";
        private static final String NBTTIMEOUT = "timeout";

        public static void toggle(ItemStack wand) {
            NBTTagCompound tags = UtilNBT.getItemStackNBT(wand);
            int type = tags.func_74762_e(NBT) + 1;
            if (type >= ActionType.values().length) {
                type = 0;
            }
            tags.func_74768_a(NBT, type);
            wand.func_77982_d(tags);
        }

        public static ActionType getAction(ItemStack wand) {
            try {
                NBTTagCompound tags = UtilNBT.getItemStackNBT(wand);
                return ActionType.values()[tags.func_74762_e(NBT)];
            }
            catch (Exception e) {
                return SINGLE;
            }
        }

        public static String getName(ItemStack wand) {
            return "wand.action." + ActionType.getAction(wand).toString().toLowerCase();
        }

        public static void setTimeout(ItemStack wand) {
            UtilNBT.getItemStackNBT(wand).func_74768_a(NBTTIMEOUT, 15);
        }

        public static int getTimeout(ItemStack wand) {
            return UtilNBT.getItemStackNBT(wand).func_74762_e(NBTTIMEOUT);
        }

        public static void tickTimeout(ItemStack wand) {
            NBTTagCompound tags = UtilNBT.getItemStackNBT(wand);
            int t = tags.func_74762_e(NBTTIMEOUT);
            if (t > 0) {
                UtilNBT.getItemStackNBT(wand).func_74768_a(NBTTIMEOUT, t - 1);
            }
        }
    }
}

