/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.event;

import com.lothrazar.cyclicmagic.capability.IPlayerExtendedProperties;
import com.lothrazar.cyclicmagic.capability.PlayerCapInstance;
import com.lothrazar.cyclicmagic.registry.CapabilityRegistry;
import com.lothrazar.cyclicmagic.util.UtilEntity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;

public class EventPlayerData {
    @SubscribeEvent
    public void onSpawn(PlayerEvent.PlayerLoggedInEvent event) {
        EntityPlayerMP p;
        if (event.player instanceof EntityPlayerMP && event.player != null && !event.player.field_70128_L && (p = (EntityPlayerMP)event.player) != null) {
            CapabilityRegistry.syncServerDataToClient(p);
            this.setHealthModifier(p);
        }
    }

    @SubscribeEvent
    public void onJoinWorld(EntityJoinWorldEvent event) {
        EntityPlayerMP p;
        if (event.getEntity() instanceof EntityPlayerMP && event.getEntity() != null && !event.getEntity().field_70128_L && (p = (EntityPlayerMP)event.getEntity()) != null) {
            CapabilityRegistry.syncServerDataToClient(p);
            this.setHealthModifier(p);
        }
    }

    private void setHealthModifier(EntityPlayerMP p) {
        IPlayerExtendedProperties src = CapabilityRegistry.getPlayerProperties((EntityPlayer)p);
        if (src.getMaxHealthModifier() != 0) {
            UtilEntity.setMaxHealthModifier((EntityLivingBase)p, src.getMaxHealthModifier());
        }
    }

    @SubscribeEvent
    public void onEntityConstruct(AttachCapabilitiesEvent event) {
        if (event.getObject() instanceof EntityPlayer) {
            event.addCapability(new ResourceLocation("cyclicmagic", "IModdedSleeping"), (ICapabilityProvider)new PlayerCapInstance());
        }
    }

    @SubscribeEvent
    public void onPlayerClone(PlayerEvent.Clone event) {
        IPlayerExtendedProperties src = CapabilityRegistry.getPlayerProperties(event.getOriginal());
        IPlayerExtendedProperties dest = CapabilityRegistry.getPlayerProperties(event.getEntityPlayer());
        dest.setDataFromNBT(src.getDataAsNBT());
        if (src.getMaxHealthModifier() != 0) {
            UtilEntity.setMaxHealthModifier((EntityLivingBase)event.getEntityPlayer(), src.getMaxHealthModifier());
        }
    }
}

