/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.data;

import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;

public class FluidWrapper {
    private FluidStack stack;
    private int x;
    private int y;

    public FluidWrapper(FluidStack stack) {
        this.stack = stack;
    }

    public FluidWrapper() {
        this(null);
    }

    public void readFromNBT(NBTTagCompound compound) {
        NBTTagCompound c = compound.func_74775_l("stack");
        this.stack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)c);
    }

    public NBTTagCompound writeToNBT(NBTTagCompound compound) {
        NBTTagCompound c = new NBTTagCompound();
        if (this.stack != null) {
            FluidStack copy = this.stack.copy();
            copy.writeToNBT(c);
        }
        compound.func_74782_a("stack", (NBTBase)c);
        return compound;
    }

    public String toString() {
        return "StackWrapper: stack=" + this.stack.toString() + ";x=" + this.getX() + ";y=" + this.getY();
    }

    public FluidStack getStack() {
        return this.stack;
    }

    public void setStack(FluidStack stack) {
        this.stack = stack;
    }

    public static FluidWrapper loadStackWrapperFromNBT(NBTTagCompound nbt) {
        FluidWrapper wrap = new FluidWrapper();
        wrap.readFromNBT(nbt);
        if (wrap.getStack() == null) {
            return null;
        }
        return wrap;
    }

    public boolean isEmpty() {
        return this.stack == null;
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
    }
}

