/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.compat.guideapi;

import amerifrance.guideapi.api.GuideAPI;
import amerifrance.guideapi.api.GuideBook;
import amerifrance.guideapi.api.IGuideBook;
import amerifrance.guideapi.api.IPage;
import amerifrance.guideapi.api.impl.Book;
import amerifrance.guideapi.api.impl.abstraction.CategoryAbstract;
import amerifrance.guideapi.api.impl.abstraction.EntryAbstract;
import amerifrance.guideapi.api.util.PageHelper;
import amerifrance.guideapi.category.CategoryItemStack;
import amerifrance.guideapi.entry.EntryItemStack;
import amerifrance.guideapi.page.PageBrewingRecipe;
import amerifrance.guideapi.page.PageIRecipe;
import com.lothrazar.cyclicmagic.guide.GuideCategory;
import com.lothrazar.cyclicmagic.guide.GuideItem;
import com.lothrazar.cyclicmagic.guide.GuidePage;
import com.lothrazar.cyclicmagic.guide.GuideRegistry;
import com.lothrazar.cyclicmagic.util.UtilChat;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Optional;

@Optional.Interface(iface="amerifrance.guideapi.api.GuideAPI", modid="guideapi", striprefs=true)
@GuideBook
public class CyclicGuideBook
implements IGuideBook {
    private static final int MAX_PAGE_LENGTH = 314;
    private static Book book;
    private List<CategoryAbstract> categories = new ArrayList<CategoryAbstract>();
    private Map<ResourceLocation, EntryAbstract> entriesBlocks = new HashMap<ResourceLocation, EntryAbstract>();
    private Map<ResourceLocation, EntryAbstract> entriesItems = new HashMap<ResourceLocation, EntryAbstract>();
    private Map<ResourceLocation, EntryAbstract> entriesGear = new HashMap<ResourceLocation, EntryAbstract>();
    private Map<ResourceLocation, EntryAbstract> entriesWorld = new HashMap<ResourceLocation, EntryAbstract>();
    private Map<ResourceLocation, EntryAbstract> entriesEnchants = new HashMap<ResourceLocation, EntryAbstract>();
    private Map<ResourceLocation, EntryAbstract> entriesBlockMachine = new HashMap<ResourceLocation, EntryAbstract>();
    private Map<ResourceLocation, EntryAbstract> entriesBlockPlate = new HashMap<ResourceLocation, EntryAbstract>();
    private Map<ResourceLocation, EntryAbstract> entriesItemBaubles = new HashMap<ResourceLocation, EntryAbstract>();
    private Map<ResourceLocation, EntryAbstract> entriesItemThrow = new HashMap<ResourceLocation, EntryAbstract>();
    private Map<ResourceLocation, EntryAbstract> entriesTransport = new HashMap<ResourceLocation, EntryAbstract>();

    private void addEntry(GuideCategory cat, List<IPage> page, String pageTitle, ItemStack icon) {
        switch (cat) {
            case BLOCK: {
                this.entriesBlocks.put(new ResourceLocation("cyclicmagic", pageTitle), (EntryAbstract)new EntryItemStack(page, pageTitle, icon));
                break;
            }
            case ITEM: {
                this.entriesItems.put(new ResourceLocation("cyclicmagic", pageTitle), (EntryAbstract)new EntryItemStack(page, pageTitle, icon));
                break;
            }
            case GEAR: {
                this.entriesGear.put(new ResourceLocation("cyclicmagic", pageTitle), (EntryAbstract)new EntryItemStack(page, pageTitle, icon));
                break;
            }
            case WORLD: {
                this.entriesWorld.put(new ResourceLocation("cyclicmagic", pageTitle), (EntryAbstract)new EntryItemStack(page, pageTitle, icon));
                break;
            }
            case ENCHANT: {
                this.entriesEnchants.put(new ResourceLocation("cyclicmagic", pageTitle), (EntryAbstract)new EntryItemStack(page, pageTitle, icon));
                break;
            }
            case BLOCKMACHINE: {
                this.entriesBlockMachine.put(new ResourceLocation("cyclicmagic", pageTitle), (EntryAbstract)new EntryItemStack(page, pageTitle, icon));
                break;
            }
            case BLOCKPLATE: {
                this.entriesBlockPlate.put(new ResourceLocation("cyclicmagic", pageTitle), (EntryAbstract)new EntryItemStack(page, pageTitle, icon));
                break;
            }
            case ITEMBAUBLES: {
                this.entriesItemBaubles.put(new ResourceLocation("cyclicmagic", pageTitle), (EntryAbstract)new EntryItemStack(page, pageTitle, icon));
                break;
            }
            case ITEMTHROW: {
                this.entriesItemThrow.put(new ResourceLocation("cyclicmagic", pageTitle), (EntryAbstract)new EntryItemStack(page, pageTitle, icon));
                break;
            }
            case TRANSPORT: {
                this.entriesTransport.put(new ResourceLocation("cyclicmagic", pageTitle), (EntryAbstract)new EntryItemStack(page, pageTitle, icon));
                break;
            }
        }
    }

    private void buildPages() {
        List<GuideItem> items = GuideRegistry.getItems();
        Comparator<GuideItem> comparator = new Comparator<GuideItem>(){

            @Override
            public int compare(GuideItem first, GuideItem second) {
                return first.title.compareTo(second.title);
            }
        };
        Collections.sort(items, comparator);
        for (GuideItem item : items) {
            ArrayList<IPage> pages = new ArrayList<IPage>();
            for (GuidePage p : item.pages) {
                if (p.text != null) {
                    for (IPage textPage : PageHelper.pagesForLongText((String)p.text, (int)314)) {
                        pages.add(textPage);
                    }
                }
                if (p.recipe != null) {
                    pages.add((IPage)new PageIRecipe(p.recipe));
                }
                if (p.brewRecipe == null) continue;
                pages.add((IPage)new PageBrewingRecipe(p.brewRecipe));
            }
            if (item.cat == null) {
                item.cat = GuideCategory.WORLD;
            }
            this.addEntry(item.cat, pages, item.title, new ItemStack(item.icon));
        }
    }

    public Book buildBook() {
        this.buildPages();
        this.buildCategories();
        this.buildBookItem();
        return book;
    }

    private void buildCategories() {
        this.addCategory(this.entriesBlocks, GuideCategory.BLOCK);
        this.addCategory(this.entriesBlockMachine, GuideCategory.BLOCKMACHINE);
        this.addCategory(this.entriesItems, GuideCategory.ITEM);
        this.addCategory(this.entriesGear, GuideCategory.GEAR);
        this.addCategory(this.entriesEnchants, GuideCategory.ENCHANT);
        this.addCategory(this.entriesWorld, GuideCategory.WORLD);
        this.addCategory(this.entriesBlockPlate, GuideCategory.BLOCKPLATE);
        this.addCategory(this.entriesItemBaubles, GuideCategory.ITEMBAUBLES);
        this.addCategory(this.entriesItemThrow, GuideCategory.ITEMTHROW);
        this.addCategory(this.entriesTransport, GuideCategory.TRANSPORT);
    }

    private void addCategory(Map<ResourceLocation, EntryAbstract> entriesBlockPlate, GuideCategory cat) {
        this.categories.add((CategoryAbstract)new CategoryItemStack(entriesBlockPlate, cat.text(), cat.icon()));
    }

    private void buildBookItem() {
        book = new Book();
        book.setTitle("guide.title");
        book.setDisplayName(UtilChat.lang("item.guide.name"));
        book.setWelcomeMessage(UtilChat.lang("guide.welcome"));
        book.setAuthor("Lothrazar");
        book.setColor(Color.MAGENTA);
        book.setCategoryList(this.categories);
        book.setRegistryName(new ResourceLocation("cyclicmagic", "guide"));
        book.setSpawnWithBook(true);
    }

    public void handleModel(ItemStack bookStack) {
        GuideAPI.setModel((Book)book);
    }

    public void handlePost(ItemStack bookStack) {
    }
}

