/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.block.sound;

import com.lothrazar.cyclicmagic.ModCyclic;
import com.lothrazar.cyclicmagic.block.sound.ContainerSoundPlayer;
import com.lothrazar.cyclicmagic.block.sound.TileEntitySoundPlayer;
import com.lothrazar.cyclicmagic.gui.GuiBaseContainer;
import com.lothrazar.cyclicmagic.net.PacketTileSetField;
import com.lothrazar.cyclicmagic.util.Const;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.GuiScrollingList;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.input.Mouse;

public class GuiSoundPlayer
extends GuiBaseContainer {
    private GuiSoundList soundList;
    private List<ResourceLocation> allSounds;

    public GuiSoundPlayer(InventoryPlayer inventoryPlayer, TileEntitySoundPlayer tile) {
        super(new ContainerSoundPlayer(inventoryPlayer, tile), tile);
        this.setScreenSize(Const.ScreenSize.PLAINWIDE);
        this.fieldRedstoneBtn = TileEntitySoundPlayer.Fields.REDSTONE.ordinal();
        this.allSounds = TileEntitySoundPlayer.getSoundList();
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.soundList = new GuiSoundList(198, 110, this.field_147009_r + 26, this.field_147009_r + 132, this.field_147003_i + 8, 14);
        this.soundList.setSounds(this.allSounds);
        int sel = this.tile.func_174887_a_(TileEntitySoundPlayer.Fields.SOUNDINDEX.ordinal());
        this.soundList.selectIndex(sel);
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        int mouseX = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
        int mouseY = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
        this.soundList.handleMouseInput(mouseX, mouseY);
    }

    @Override
    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        super.func_146976_a(partialTicks, mouseX, mouseY);
        this.soundList.drawScreen(mouseX, mouseY, partialTicks);
    }

    @Override
    public void func_73876_c() {
        super.func_73876_c();
        ModCyclic.network.sendToServer((IMessage)new PacketTileSetField(this.tile.func_174877_v(), TileEntitySoundPlayer.Fields.SOUNDINDEX.ordinal(), this.soundList.getSelectionIndex()));
    }

    private final class GuiSoundList
    extends GuiScrollingList {
        private List<ResourceLocation> sounds;
        private final int slotHeight;
        private List<Integer> selectedIndicies;

        GuiSoundList(int width, int height, int top, int bottom, int left, int slotHeight) {
            super(Minecraft.func_71410_x(), width, height, top, bottom, left, slotHeight, width, height);
            this.selectedIndicies = new ArrayList<Integer>();
            this.slotHeight = slotHeight;
        }

        protected int getSize() {
            return this.sounds.size();
        }

        protected void elementClicked(int index, boolean doubleClick) {
            if (GuiScreen.func_146271_m()) {
                if (this.isSelected(index)) {
                    this.removeSelection(index);
                } else {
                    this.selectIndex(index);
                }
            } else if (GuiScreen.func_146272_n()) {
                this.clearSelection();
                int start = index > this.selectedIndex ? this.selectedIndex : index;
                int end = index > this.selectedIndex ? index : this.selectedIndex;
                this.selectRange(start, end);
            } else {
                this.clearSelection();
                this.selectIndex(index);
            }
        }

        protected boolean isSelected(int index) {
            for (int i : this.selectedIndicies) {
                if (i != index) continue;
                return true;
            }
            return false;
        }

        void removeSelection(int index) {
            for (int i = 0; i < this.selectedIndicies.size(); ++i) {
                if (this.selectedIndicies.get(i) != index) continue;
                this.selectedIndicies.remove(i);
                return;
            }
        }

        void selectIndex(int index) {
            if (index >= 0 && index < this.sounds.size()) {
                this.removeSelection(index);
                this.selectedIndicies.add(index);
                this.selectedIndex = index;
            }
        }

        void clearSelection() {
            this.selectedIndicies.clear();
        }

        public int getSelectionIndex() {
            return this.selectedIndex;
        }

        void selectRange(int start, int end) {
            for (int i = start; i <= end; ++i) {
                this.selectedIndicies.add(i);
            }
            this.selectedIndex = end;
        }

        protected void drawBackground() {
        }

        protected int getContentHeight() {
            return this.getSize() * this.slotHeight + 1;
        }

        protected void drawSlot(int idx, int right, int top, int height, Tessellator tess) {
            ResourceLocation sound = this.sounds.get(idx);
            GuiSoundPlayer.this.field_146289_q.func_78276_b(GuiSoundPlayer.this.field_146289_q.func_78269_a(sound.toString(), this.listWidth - 10), this.left + 3, top + 2, 0xCCCCCC);
        }

        void setSounds(List<ResourceLocation> sounds) {
            this.sounds = sounds;
        }
    }
}

