/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.block.forester;

import com.lothrazar.cyclicmagic.ModCyclic;
import com.lothrazar.cyclicmagic.block.core.TileEntityBaseMachineInvo;
import com.lothrazar.cyclicmagic.block.forester.BlockForester;
import com.lothrazar.cyclicmagic.capability.EnergyStore;
import com.lothrazar.cyclicmagic.data.ITilePreviewToggle;
import com.lothrazar.cyclicmagic.data.ITileRedstoneToggle;
import com.lothrazar.cyclicmagic.util.UtilFakePlayer;
import com.lothrazar.cyclicmagic.util.UtilItemStack;
import com.lothrazar.cyclicmagic.util.UtilNBT;
import com.lothrazar.cyclicmagic.util.UtilOreDictionary;
import com.lothrazar.cyclicmagic.util.UtilParticle;
import com.lothrazar.cyclicmagic.util.UtilShape;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityForester
extends TileEntityBaseMachineInvo
implements ITileRedstoneToggle,
ITilePreviewToggle,
ITickable {
    private static final String[] validTargetsOreDict = new String[]{"logWood", "treeLeaves"};
    private static final String[] validSaplingsOreDict = new String[]{"treeSapling"};
    private static final String NBT_REDST = "redstone";
    private static final String NBTMINING = "mining";
    private static final String NBTDAMAGE = "curBlockDamage";
    private static final String NBTPLAYERID = "uuid";
    static final int MAX_HEIGHT = 32;
    private int height = 32;
    private static final int MAX_SIZE = 9;
    private int size = 9;
    private boolean isCurrentlyMining;
    private float curBlockDamage;
    private BlockPos targetPos = null;
    private WeakReference<FakePlayer> fakePlayer;
    private UUID uuid;

    public TileEntityForester() {
        super(18);
        this.initEnergy(new EnergyStore(64000, 64000, 64000), BlockForester.FUEL_COST);
        this.setSlotsForInsert(0, 18);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    @Override
    public int[] getFieldOrdinals() {
        return super.getFieldArray(Fields.values().length);
    }

    private void verifyFakePlayer(WorldServer w) {
        if (this.fakePlayer == null) {
            this.fakePlayer = UtilFakePlayer.initFakePlayer(w, this.uuid, this.func_145838_q().func_149739_a());
            if (this.fakePlayer == null) {
                ModCyclic.logger.error("Fake player failed to init ");
            }
        }
    }

    public void func_73660_a() {
        if (!this.isRunning()) {
            return;
        }
        if (!this.updateEnergyIsBurning()) {
            return;
        }
        if (this.field_145850_b instanceof WorldServer) {
            this.verifyUuid(this.field_145850_b);
            this.verifyFakePlayer((WorldServer)this.field_145850_b);
            this.tryEquipItem();
            if (this.targetPos == null) {
                this.targetPos = this.getTargetCenter();
            }
            this.shiftAllUp(1);
            this.updatePlantSaplings();
            this.updateMiningProgress();
        }
    }

    @Override
    public boolean func_94041_b(int index, ItemStack stack) {
        return this.isSaplingValid(stack);
    }

    private void updatePlantSaplings() {
        ItemStack sapling = this.func_70301_a(0);
        if (this.isSaplingValid(sapling) && this.targetPos.func_177956_o() == this.field_174879_c.func_177956_o() && this.field_145850_b.func_175623_d(this.targetPos) && this.field_145850_b.isSideSolid(this.targetPos.func_177977_b(), EnumFacing.UP)) {
            if (((FakePlayer)this.fakePlayer.get()).func_184592_cb().func_190926_b()) {
                ((FakePlayer)this.fakePlayer.get()).func_184611_a(EnumHand.OFF_HAND, sapling);
            }
            ((FakePlayer)this.fakePlayer.get()).field_71134_c.func_187251_a((EntityPlayer)this.fakePlayer.get(), this.field_145850_b, sapling, EnumHand.OFF_HAND, this.targetPos.func_177977_b(), EnumFacing.UP, 0.5f, 0.5f, 0.5f);
        }
    }

    private boolean updateMiningProgress() {
        if (this.isPreviewVisible()) {
            UtilParticle.spawnParticlePacket(EnumParticleTypes.DRAGON_BREATH, this.targetPos, this.getDimension());
        }
        if (this.isTargetValid()) {
            this.isCurrentlyMining = true;
        } else {
            this.isCurrentlyMining = false;
            this.updateTargetPos();
            this.skipSomeAirBlocks();
            this.resetProgress(this.targetPos);
        }
        if (this.isCurrentlyMining) {
            IBlockState targetState = this.field_145850_b.func_180495_p(this.targetPos);
            this.curBlockDamage += UtilItemStack.getPlayerRelativeBlockHardness(targetState.func_177230_c(), targetState, (EntityPlayer)this.fakePlayer.get(), this.field_145850_b, this.targetPos);
            if (this.curBlockDamage >= 1.0f) {
                this.isCurrentlyMining = false;
                this.resetProgress(this.targetPos);
                if (this.fakePlayer.get() != null) {
                    return ((FakePlayer)this.fakePlayer.get()).field_71134_c.func_180237_b(this.targetPos);
                }
            } else {
                this.field_145850_b.func_175715_c(this.uuid.hashCode(), this.targetPos, (int)(this.curBlockDamage * 10.0f) - 1);
            }
        }
        return false;
    }

    private void skipSomeAirBlocks() {
        int skipping = 30;
        for (int i = 0; this.field_145850_b.func_175623_d(this.targetPos) && i < skipping; ++i) {
            this.updateTargetPos();
        }
    }

    private void tryEquipItem() {
        if (((FakePlayer)this.fakePlayer.get()).func_184586_b(EnumHand.MAIN_HAND).func_190926_b()) {
            ItemStack unbreakingPickaxe = new ItemStack(Items.field_151056_x, 1);
            unbreakingPickaxe.func_77966_a(Enchantments.field_185304_p, 3);
            unbreakingPickaxe.func_77966_a(Enchantments.field_185305_q, 5);
            unbreakingPickaxe.func_77982_d(new NBTTagCompound());
            unbreakingPickaxe.func_77978_p().func_74757_a("Unbreakable", true);
            ((FakePlayer)this.fakePlayer.get()).func_184611_a(EnumHand.MAIN_HAND, unbreakingPickaxe);
        }
    }

    private void verifyUuid(World world) {
        if (this.uuid == null) {
            this.uuid = UUID.randomUUID();
            IBlockState state = world.func_180495_p(this.field_174879_c);
            world.func_184138_a(this.field_174879_c, state, state, 3);
        }
    }

    private boolean isSaplingValid(ItemStack sapling) {
        return UtilOreDictionary.doesMatchOreDict(sapling, validSaplingsOreDict);
    }

    private boolean isTargetValid() {
        World world = this.func_145831_w();
        if (world.func_175623_d(this.targetPos) || world.func_180495_p(this.targetPos) == null) {
            return false;
        }
        IBlockState targetState = world.func_180495_p(this.targetPos);
        Block target = targetState.func_177230_c();
        ItemStack modsThatUseMetaAreDumb = new ItemStack(targetState.func_177230_c(), 1, targetState.func_177230_c().func_176201_c(targetState));
        List<String> oreDictList = UtilOreDictionary.getOreDictList(modsThatUseMetaAreDumb, true);
        for (String ore : oreDictList) {
            for (String str : validTargetsOreDict) {
                if (!str.equals(ore)) continue;
                return true;
            }
        }
        return UtilOreDictionary.doesMatchOreDict(new ItemStack(target), validTargetsOreDict);
    }

    public BlockPos getTargetCenter() {
        return this.func_174877_v();
    }

    private void updateTargetPos() {
        int minX = this.field_174879_c.func_177958_n() - this.size;
        int maxX = this.field_174879_c.func_177958_n() + this.size;
        int minY = this.field_174879_c.func_177956_o();
        int maxY = this.field_174879_c.func_177956_o() + this.height - 1;
        int minZ = this.field_174879_c.func_177952_p() - this.size;
        int maxZ = this.field_174879_c.func_177952_p() + this.size;
        this.targetPos = this.targetPos.func_177982_a(0, 1, 0);
        if (this.targetPos.func_177956_o() <= maxY) {
            return;
        }
        this.targetPos = new BlockPos(this.targetPos.func_177958_n() + 1, minY, this.targetPos.func_177952_p());
        if (this.targetPos.func_177958_n() <= maxX) {
            return;
        }
        this.targetPos = new BlockPos(minX, this.targetPos.func_177956_o(), this.targetPos.func_177952_p() + 1);
        if (this.targetPos.func_177952_p() <= maxZ) {
            return;
        }
        this.targetPos = new BlockPos(minX, minY, minZ);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tags) {
        tags.func_74768_a(NBT_REDST, this.needsRedstone);
        if (this.uuid != null) {
            tags.func_74778_a(NBTPLAYERID, this.uuid.toString());
        }
        tags.func_74757_a(NBTMINING, this.isCurrentlyMining);
        tags.func_74776_a(NBTDAMAGE, this.curBlockDamage);
        tags.func_74768_a("size", this.size);
        tags.func_74768_a("ht", this.height);
        tags.func_74768_a("render", this.renderParticles);
        if (this.targetPos != null) {
            UtilNBT.setTagBlockPos(tags, this.targetPos);
        }
        return super.func_189515_b(tags);
    }

    @Override
    public void func_145839_a(NBTTagCompound tags) {
        super.func_145839_a(tags);
        this.needsRedstone = tags.func_74762_e(NBT_REDST);
        this.size = tags.func_74762_e("size");
        this.height = tags.func_74762_e("ht");
        if (tags.func_74764_b(NBTPLAYERID)) {
            this.uuid = UUID.fromString(tags.func_74779_i(NBTPLAYERID));
        }
        this.targetPos = UtilNBT.getTagBlockPos(tags);
        this.isCurrentlyMining = tags.func_74767_n(NBTMINING);
        this.curBlockDamage = tags.func_74760_g(NBTDAMAGE);
        this.renderParticles = tags.func_74762_e("render");
    }

    public void breakBlock(World worldIn, BlockPos pos, IBlockState state) {
        if (this.isCurrentlyMining && this.uuid != null) {
            this.resetProgress(pos);
        }
    }

    private void resetProgress(BlockPos targetPos) {
        if (this.uuid != null) {
            this.func_145831_w().func_175715_c(this.uuid.hashCode(), targetPos, -1);
            this.curBlockDamage = 0.0f;
        }
    }

    @Override
    public int func_174887_a_(int id) {
        switch (Fields.values()[id]) {
            case REDSTONE: {
                return this.needsRedstone;
            }
            case RENDERPARTICLES: {
                return this.renderParticles;
            }
            case TIMER: {
                return this.timer;
            }
            case SIZE: {
                return this.size;
            }
            case HEIGHT: {
                return this.height;
            }
        }
        return 0;
    }

    @Override
    public void func_174885_b(int id, int value) {
        switch (Fields.values()[id]) {
            case REDSTONE: {
                this.needsRedstone = value;
                break;
            }
            case RENDERPARTICLES: {
                this.renderParticles = value % 2;
                break;
            }
            case TIMER: {
                this.timer = value;
                break;
            }
            case SIZE: {
                if (value > 9) {
                    value = 1;
                }
                if (value < 1) {
                    value = 9;
                }
                this.size = value;
                break;
            }
            case HEIGHT: {
                this.height = Math.min(value, 32);
            }
        }
    }

    @Override
    public boolean func_145842_c(int id, int value) {
        if (id >= 0 && id < this.func_174890_g()) {
            this.func_174885_b(id, value);
            return true;
        }
        return super.func_145842_c(id, value);
    }

    @Override
    public int func_174890_g() {
        return Fields.values().length;
    }

    @Override
    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
        super.onDataPacket(net, pkt);
    }

    @Override
    public void toggleNeedsRedstone() {
        int val = this.needsRedstone + 1;
        if (val > 1) {
            val = 0;
        }
        this.func_174885_b(Fields.REDSTONE.ordinal(), val);
    }

    @Override
    public boolean onlyRunIfPowered() {
        return this.needsRedstone == 1;
    }

    @Override
    public List<BlockPos> getShape() {
        return UtilShape.squareHorizontalHollow(this.field_174879_c, this.size);
    }

    @Override
    public boolean isPreviewVisible() {
        return this.func_174887_a_(Fields.RENDERPARTICLES.ordinal()) == 1;
    }

    public static enum Fields {
        REDSTONE,
        RENDERPARTICLES,
        TIMER,
        SIZE,
        HEIGHT;

    }
}

