/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.block.fluiddrain;

import com.lothrazar.cyclicmagic.ModCyclic;
import com.lothrazar.cyclicmagic.block.core.TileEntityBaseMachineFluid;
import com.lothrazar.cyclicmagic.block.fluiddrain.BlockFluidDrain;
import com.lothrazar.cyclicmagic.capability.EnergyStore;
import com.lothrazar.cyclicmagic.data.ITilePreviewToggle;
import com.lothrazar.cyclicmagic.data.ITileRedstoneToggle;
import com.lothrazar.cyclicmagic.liquid.FluidTankFixDesync;
import com.lothrazar.cyclicmagic.util.UtilFakePlayer;
import com.lothrazar.cyclicmagic.util.UtilParticle;
import com.lothrazar.cyclicmagic.util.UtilPlaceBlocks;
import com.lothrazar.cyclicmagic.util.UtilShape;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class TileEntityFluidDrain
extends TileEntityBaseMachineFluid
implements ITileRedstoneToggle,
ITickable,
ITilePreviewToggle {
    public static final int TANK_FULL = 64000;
    private int radius = 7;
    private int depth = 4;
    private int shapePtr = 0;
    private List<BlockPos> shape = null;
    private WeakReference<FakePlayer> fakePlayer;
    private UUID uuid;

    public TileEntityFluidDrain() {
        super(18);
        this.setSlotsForInsert(0, 18);
        this.tank = new FluidTankFixDesync(64000, this);
        this.tank.setTileEntity(this);
        this.initEnergy(new EnergyStore(64000, 64000, 64000), BlockFluidDrain.FUEL_COST);
        this.renderParticles = 1;
    }

    @Override
    public int[] getFieldOrdinals() {
        return super.getFieldArray(Fields.values().length);
    }

    @Override
    public int func_174890_g() {
        return this.getFieldOrdinals().length;
    }

    private void verifyFakePlayer(WorldServer w) {
        if (this.uuid == null) {
            this.uuid = UUID.randomUUID();
        }
        if (this.fakePlayer == null) {
            this.fakePlayer = UtilFakePlayer.initFakePlayer(w, this.uuid, this.func_145838_q().func_149739_a());
            if (this.fakePlayer == null) {
                ModCyclic.logger.error("Fake player failed to init ");
            }
        }
    }

    public void func_73660_a() {
        this.shiftAllUp();
        if (!this.isRunning() || this.tank.isFull() || !(this.func_70301_a(0).func_77973_b() instanceof ItemBlock)) {
            return;
        }
        if (this.field_145850_b instanceof WorldServer) {
            this.verifyFakePlayer((WorldServer)this.field_145850_b);
        }
        if (this.shape == null) {
            this.shape = this.getEntireShape();
        }
        if (this.shapePtr >= this.shape.size()) {
            this.shapePtr = 0;
            return;
        }
        BlockPos current = this.shape.get(this.shapePtr);
        ++this.shapePtr;
        IBlockState currentState = this.field_145850_b.func_180495_p(current);
        if (currentState.func_185904_a().func_76224_d() && this.updateEnergyIsBurning()) {
            UtilParticle.spawnParticle(this.field_145850_b, EnumParticleTypes.WATER_BUBBLE, current);
            IFluidHandler handle = FluidUtil.getFluidHandler((World)this.field_145850_b, (BlockPos)current, (EnumFacing)EnumFacing.UP);
            FluidStack fs = handle.getTankProperties()[0].getContents();
            if (fs == null || !this.tank.canFillFluidType(fs)) {
                return;
            }
            if (this.fakePlayer != null && UtilPlaceBlocks.buildStackAsPlayer(this.field_145850_b, (EntityPlayer)this.fakePlayer.get(), current, this.func_70301_a(0))) {
                this.tank.fill(fs, true);
                this.func_70301_a(0).func_190918_g(1);
            }
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74768_a("redstone", this.needsRedstone);
        return super.func_189515_b(compound);
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.needsRedstone = compound.func_74762_e("redstone");
    }

    @Override
    public int func_174887_a_(int id) {
        switch (Fields.values()[id]) {
            case REDSTONE: {
                return this.needsRedstone;
            }
            case RENDERPARTICLES: {
                return this.renderParticles;
            }
        }
        return -1;
    }

    @Override
    public void func_174885_b(int id, int value) {
        switch (Fields.values()[id]) {
            case REDSTONE: {
                this.needsRedstone = value;
                break;
            }
            case RENDERPARTICLES: {
                this.renderParticles = value % 2;
                break;
            }
        }
    }

    @Override
    public void toggleNeedsRedstone() {
        this.func_174885_b(Fields.REDSTONE.ordinal(), (this.needsRedstone + 1) % 2);
    }

    @Override
    public boolean onlyRunIfPowered() {
        return this.needsRedstone == 1;
    }

    public float getFillRatio() {
        return this.tank.getFluidAmount() / this.tank.getCapacity();
    }

    @Override
    public boolean isPreviewVisible() {
        return this.renderParticles == 1;
    }

    public List<BlockPos> getEntireShape() {
        List<BlockPos> circle = UtilShape.cubeFilled(this.field_174879_c.func_177979_c(this.depth + 1), this.radius, this.depth);
        Collections.reverse(circle);
        return circle;
    }

    @Override
    public List<BlockPos> getShape() {
        ArrayList<BlockPos> circle = new ArrayList<BlockPos>();
        if (this.shape != null && this.shapePtr < this.shape.size()) {
            circle.add(this.shape.get(this.shapePtr));
        }
        return circle;
    }

    public static enum Fields {
        REDSTONE,
        RENDERPARTICLES;

    }
}

