/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.block.cablepump.energy;

import com.lothrazar.cyclicmagic.block.cable.TileEntityCableBase;
import com.lothrazar.cyclicmagic.block.cablepump.TileEntityBasePump;
import com.lothrazar.cyclicmagic.capability.EnergyStore;
import com.lothrazar.cyclicmagic.data.ITileRedstoneToggle;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;

public class TileEntityEnergyPump
extends TileEntityBasePump
implements ITickable,
ITileRedstoneToggle {
    private int transferRate = 8000;

    public TileEntityEnergyPump() {
        super(0);
        this.initEnergy(new EnergyStore(64000), 0);
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.needsRedstone = compound.func_74762_e("redstone");
        this.transferRate = compound.func_74762_e("transferRate");
        if (this.transferRate == 0) {
            this.transferRate = 1;
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74768_a("redstone", this.needsRedstone);
        compound.func_74768_a("transferRate", this.transferRate);
        return super.func_189515_b(compound);
    }

    @Override
    public EnumFacing getCurrentFacing() {
        EnumFacing facingTo = super.getCurrentFacing();
        if (facingTo.func_176740_k().func_176720_b()) {
            facingTo = facingTo.func_176734_d();
        }
        return facingTo;
    }

    public void func_73660_a() {
        int drain;
        if (!this.isRunning()) {
            return;
        }
        EnumFacing importFromSide = this.getCurrentFacing();
        IEnergyStorage myEnergy = (IEnergyStorage)this.getCapability(CapabilityEnergy.ENERGY, null);
        TileEntity importFromTile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(importFromSide));
        IEnergyStorage exportHandler = null;
        IEnergyStorage importHandlr = null;
        if (importFromTile == null || !importFromTile.hasCapability(CapabilityEnergy.ENERGY, importFromSide.func_176734_d())) {
            return;
        }
        importHandlr = (IEnergyStorage)importFromTile.getCapability(CapabilityEnergy.ENERGY, importFromSide.func_176734_d());
        if (importHandlr != null && importHandlr.canExtract() && (drain = importHandlr.extractEnergy(this.transferRate, true)) > 0) {
            int filled = myEnergy.receiveEnergy(drain, false);
            importHandlr.extractEnergy(filled, false);
        }
        List<EnumFacing> sidesOut = this.getSidesNotFacing();
        for (EnumFacing exportToSide : sidesOut) {
            TileEntityCableBase cable;
            int drain2;
            if (!this.hasCapability(CapabilityEnergy.ENERGY, exportToSide)) continue;
            TileEntity exportToTile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(exportToSide));
            if (exportToTile != null && importFromTile.hasCapability(CapabilityEnergy.ENERGY, exportToSide.func_176734_d())) {
                exportHandler = (IEnergyStorage)exportToTile.getCapability(CapabilityEnergy.ENERGY, exportToSide.func_176734_d());
            }
            if (exportHandler == null || !exportHandler.canReceive() || (drain2 = myEnergy.extractEnergy(this.transferRate, true)) <= 0) continue;
            int filled = exportHandler.receiveEnergy(drain2, false);
            myEnergy.extractEnergy(filled, false);
            if (!(this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(exportToSide)) instanceof TileEntityCableBase) || !(cable = (TileEntityCableBase)this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(exportToSide))).isEnergyPipe()) break;
            cable.updateIncomingEnergyFace(importFromSide);
            break;
        }
    }

    @Override
    public int func_174887_a_(int id) {
        switch (Fields.values()[id]) {
            case REDSTONE: {
                return this.needsRedstone;
            }
            case TRANSFER_RATE: {
                return this.transferRate;
            }
        }
        return 0;
    }

    @Override
    public void func_174885_b(int id, int value) {
        switch (Fields.values()[id]) {
            case REDSTONE: {
                this.needsRedstone = value % 2;
                break;
            }
            case TRANSFER_RATE: {
                if (value == 0) {
                    value = 1;
                }
                this.transferRate = value;
            }
        }
    }

    @Override
    public int[] getFieldOrdinals() {
        return super.getFieldArray(Fields.values().length);
    }

    @Override
    public void toggleNeedsRedstone() {
        int val = (this.needsRedstone + 1) % 2;
        this.func_174885_b(Fields.REDSTONE.ordinal(), val);
    }

    @Override
    public boolean onlyRunIfPowered() {
        return this.needsRedstone == 1;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY && (facing == this.getCurrentFacing() || facing == this.getCurrentFacing().func_176734_d())) {
            return true;
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return false;
        }
        return super.hasCapability(capability, facing);
    }

    public static enum Fields {
        REDSTONE,
        TRANSFER_RATE;

    }
}

