/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.block.battery;

import com.lothrazar.cyclicmagic.IContent;
import com.lothrazar.cyclicmagic.block.battery.EnergyFlatMap;
import com.lothrazar.cyclicmagic.block.battery.ItemBlockBattery;
import com.lothrazar.cyclicmagic.block.battery.TileEntityBattery;
import com.lothrazar.cyclicmagic.block.core.BlockBaseHasTile;
import com.lothrazar.cyclicmagic.capability.EnergyStore;
import com.lothrazar.cyclicmagic.data.IHasRecipe;
import com.lothrazar.cyclicmagic.guide.GuideCategory;
import com.lothrazar.cyclicmagic.registry.BlockRegistry;
import com.lothrazar.cyclicmagic.registry.RecipeRegistry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class BlockBattery
extends BlockBaseHasTile
implements IHasRecipe,
IContent {
    public static final int MAX_SMALL = 1000000;
    public static final PropertyEnum<EnergyFlatMap> AMOUNT = PropertyEnum.func_177709_a((String)"amount", EnergyFlatMap.class);
    private static final PropertyBool U = PropertyBool.func_177716_a((String)"u");
    private static final PropertyBool D = PropertyBool.func_177716_a((String)"d");
    private static final PropertyBool N = PropertyBool.func_177716_a((String)"n");
    private static final PropertyBool E = PropertyBool.func_177716_a((String)"e");
    private static final PropertyBool S = PropertyBool.func_177716_a((String)"s");
    private static final PropertyBool W = PropertyBool.func_177716_a((String)"w");
    private boolean enabled;

    public BlockBattery() {
        super(Material.field_151576_e);
        this.setGuiId(38);
    }

    @Override
    public String getContentName() {
        return "battery";
    }

    @Override
    public void register() {
        BlockRegistry.registerBlock((Block)this, new ItemBlockBattery(this), this.getContentName(), GuideCategory.BLOCKMACHINE);
        BlockRegistry.registerTileEntity(TileEntityBattery.class, "cyclicmagic" + this.getContentName() + "_te");
    }

    @Override
    public boolean enabled() {
        return this.enabled;
    }

    @Override
    public void syncConfig(Configuration config) {
        this.enabled = config.getBoolean(this.getContentName(), "cyclicmagic.content", true, " Set false to delete - requires restart");
    }

    @Override
    public IRecipe addRecipe() {
        return RecipeRegistry.addShapedOreRecipe(new ItemStack((Block)this), "cbc", "bab", "cbc", Character.valueOf('c'), Items.field_151119_aD, Character.valueOf('b'), Blocks.field_150359_w, Character.valueOf('a'), "blockRedstone");
    }

    public TileEntity createTileEntity(World worldIn, IBlockState state) {
        return new TileEntityBattery();
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (willHarvest) {
            return true;
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity te, ItemStack tool) {
        super.func_180657_a(world, player, pos, state, te, tool);
        world.func_175698_g(pos);
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        Item item = Item.func_150898_a((Block)this);
        TileEntity ent = world.func_175625_s(pos);
        ItemStack stack = new ItemStack(item);
        if (ent != null && ent.hasCapability(CapabilityEnergy.ENERGY, null)) {
            IEnergyStorage handlerHere = (IEnergyStorage)ent.getCapability(CapabilityEnergy.ENERGY, null);
            if (stack.hasCapability(CapabilityEnergy.ENERGY, null)) {
                EnergyStore storage = (EnergyStore)((Object)stack.getCapability(CapabilityEnergy.ENERGY, null));
                storage.setEnergyStored(handlerHere.getEnergyStored());
            }
        }
        ret.add(stack);
        return ret;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityBattery) {
            TileEntityBattery battery = (TileEntityBattery)tile;
            state = state.func_177226_a((IProperty)U, (Comparable)Boolean.valueOf(battery.getSideHasPower(EnumFacing.UP)));
            state = state.func_177226_a((IProperty)D, (Comparable)Boolean.valueOf(battery.getSideHasPower(EnumFacing.DOWN)));
            state = state.func_177226_a((IProperty)N, (Comparable)Boolean.valueOf(battery.getSideHasPower(EnumFacing.NORTH)));
            state = state.func_177226_a((IProperty)E, (Comparable)Boolean.valueOf(battery.getSideHasPower(EnumFacing.EAST)));
            state = state.func_177226_a((IProperty)S, (Comparable)Boolean.valueOf(battery.getSideHasPower(EnumFacing.SOUTH)));
            state = state.func_177226_a((IProperty)W, (Comparable)Boolean.valueOf(battery.getSideHasPower(EnumFacing.WEST)));
            IEnergyStorage handlerHere = (IEnergyStorage)tile.getCapability(CapabilityEnergy.ENERGY, null);
            double percent = (double)handlerHere.getEnergyStored() / (double)handlerHere.getMaxEnergyStored();
            EnergyFlatMap p = EnergyFlatMap.AMOUNT_G0;
            double max = 16.0;
            p = percent == 0.0 ? EnergyFlatMap.AMOUNT_G0 : (percent < 1.0 / max ? EnergyFlatMap.AMOUNT_G1 : (percent < 2.0 / max ? EnergyFlatMap.AMOUNT_G2 : (percent < 3.0 / max ? EnergyFlatMap.AMOUNT_G3 : (percent < 4.0 / max ? EnergyFlatMap.AMOUNT_G4 : (percent < 5.0 / max ? EnergyFlatMap.AMOUNT_G5 : (percent < 6.0 / max ? EnergyFlatMap.AMOUNT_G6 : (percent < 7.0 / max ? EnergyFlatMap.AMOUNT_G7 : (percent < 8.0 / max ? EnergyFlatMap.AMOUNT_G8 : (percent < 9.0 / max ? EnergyFlatMap.AMOUNT_G9 : (percent < 10.0 / max ? EnergyFlatMap.AMOUNT_G10 : (percent < 11.0 / max ? EnergyFlatMap.AMOUNT_G11 : (percent < 12.0 / max ? EnergyFlatMap.AMOUNT_G12 : (percent < 13.0 / max ? EnergyFlatMap.AMOUNT_G13 : (percent < 14.0 / max ? EnergyFlatMap.AMOUNT_G14 : (percent < 15.0 / max ? EnergyFlatMap.AMOUNT_G15 : EnergyFlatMap.AMOUNT_G16)))))))))))))));
            return state.func_177226_a(AMOUNT, (Comparable)((Object)p));
        }
        return super.func_176221_a(state, world, pos);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{AMOUNT, U, D, N, E, S, W});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P();
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (stack.hasCapability(CapabilityEnergy.ENERGY, null)) {
            IEnergyStorage storage = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null);
            TileEntityBattery container = (TileEntityBattery)world.func_175625_s(pos);
            container.setEnergyCurrent(storage.getEnergyStored());
        } else if (stack.func_77978_p() != null && world.func_175625_s(pos) instanceof TileEntityBattery) {
            NBTTagCompound tags = stack.func_77978_p();
            int energy = tags.func_74762_e("energy");
            TileEntityBattery container = (TileEntityBattery)world.func_175625_s(pos);
            container.setEnergyCurrent(energy);
        }
    }
}

