/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.lib.util.data;

import com.bloodnbonesgaming.lib.util.JsonToNBTExtended;
import com.bloodnbonesgaming.lib.util.data.BlockPredicate;
import com.bloodnbonesgaming.lib.util.data.ExtendedItemPredicate;
import com.bloodnbonesgaming.lib.util.data.NBTPredicateExtended;
import com.google.common.base.Optional;
import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.advancements.critereon.EnchantmentPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.NBTPredicate;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.PotionType;
import net.minecraft.util.JsonUtils;
import net.minecraftforge.oredict.OreDictionary;

public class ItemBlockData {
    private String location;
    private String stateJson;
    private MinMaxBounds meta = MinMaxBounds.field_192516_a;
    public MinMaxBounds count = MinMaxBounds.field_192516_a;
    private MinMaxBounds durability = MinMaxBounds.field_192516_a;
    private final List<EnchantmentPredicate> enchantmentData = new ArrayList<EnchantmentPredicate>();
    private PotionType potionType;
    private NBTPredicate nbt = NBTPredicate.field_193479_a;
    private String oreDict;
    private NBTPredicate tile = NBTPredicate.field_193479_a;

    public BlockPredicate buildBlockPredicate() throws Exception {
        Block block = null;
        HashMap map = null;
        if (this.location != null) {
            block = Block.func_149684_b((String)this.location);
            if (block == null) {
                throw new Exception(this.location + " is not a valid block resource location.");
            }
            if (this.stateJson != null) {
                JsonParser parser = new JsonParser();
                JsonObject jsonObj = (JsonObject)parser.parse(this.stateJson);
                BlockStateContainer blockstatecontainer = block.func_176194_O();
                for (Map.Entry entry : jsonObj.entrySet()) {
                    IProperty iproperty = blockstatecontainer.func_185920_a((String)entry.getKey());
                    if (iproperty == null) {
                        throw new Exception("Unknown block state property '" + (String)entry.getKey() + "'");
                    }
                    String s = JsonUtils.func_151206_a((JsonElement)((JsonElement)entry.getValue()), (String)((String)entry.getKey()));
                    Optional optional = iproperty.func_185929_b(s);
                    if (!optional.isPresent()) {
                        throw new Exception("Invalid block state value '" + s + "' for property '" + (String)entry.getKey() + "'");
                    }
                    if (map == null) {
                        map = Maps.newHashMap();
                    }
                    map.put(iproperty, optional.get());
                }
            }
        }
        return new BlockPredicate(block, this.meta, map, this.oreDict, this.tile);
    }

    public IBlockState buildBlockState() throws Exception {
        Block block = null;
        IBlockState state = null;
        if (this.location != null) {
            block = Block.func_149684_b((String)this.location);
            if (block == null) {
                throw new Exception(this.location + " is not a valid block resource location.");
            }
            IBlockState iBlockState = state = this.meta.field_192517_b != null ? block.func_176203_a(this.meta.field_192517_b.intValue()) : block.func_176223_P();
            if (this.stateJson != null) {
                JsonParser parser = new JsonParser();
                JsonObject jsonObj = (JsonObject)parser.parse(this.stateJson);
                BlockStateContainer blockstatecontainer = block.func_176194_O();
                for (Map.Entry entry : jsonObj.entrySet()) {
                    IProperty iproperty = blockstatecontainer.func_185920_a((String)entry.getKey());
                    if (iproperty == null) {
                        throw new Exception("Unknown block state property '" + (String)entry.getKey() + "'");
                    }
                    String s = JsonUtils.func_151206_a((JsonElement)((JsonElement)entry.getValue()), (String)((String)entry.getKey()));
                    Optional optional = iproperty.func_185929_b(s);
                    if (!optional.isPresent()) {
                        throw new Exception("Invalid block state value '" + s + "' for property '" + (String)entry.getKey() + "'");
                    }
                    state = this.withProperty(state, iproperty, s);
                }
            }
        }
        if (state == null) {
            throw new Exception("State could not be parsed.");
        }
        return state;
    }

    private <T extends Comparable<T>> IBlockState withProperty(IBlockState state, IProperty<T> property, String value) {
        return state.func_177226_a(property, (Comparable)property.func_185929_b(value).get());
    }

    public ItemPredicate buildItemPredicate() throws Exception {
        Item item = null;
        if (this.location != null && (item = Item.func_111206_d((String)this.location)) == null) {
            throw new Exception(this.location + " is not a valid item resource location.");
        }
        return new ExtendedItemPredicate(item, this.meta, this.count, this.durability, this.enchantmentData.toArray(new EnchantmentPredicate[0]), this.potionType, this.nbt, this.oreDict);
    }

    public ItemStack buildItemStack() throws Exception {
        ItemStack itemStack = null;
        Item item = null;
        if (this.location != null) {
            item = Item.func_111206_d((String)this.location);
            if (item == null) {
                throw new Exception(this.location + " is not a valid item resource location.");
            }
            itemStack = new ItemStack(item, this.count.field_192517_b != null ? this.count.field_192517_b.intValue() : 1, this.meta.field_192517_b != null ? this.meta.field_192517_b.intValue() : 0);
            if (this.nbt != NBTPredicate.field_193479_a) {
                itemStack.func_77982_d(this.nbt.field_193480_b);
            }
            for (EnchantmentPredicate pred : this.enchantmentData) {
                if (pred.field_192467_b == null) continue;
                this.addEnchantment(itemStack, pred.field_192467_b, pred.field_192468_c.field_192517_b != null ? pred.field_192468_c.field_192517_b.intValue() : 1);
            }
        }
        return itemStack;
    }

    private void addEnchantment(ItemStack item, Enchantment ench, int level) {
        if (item.func_77978_p() == null) {
            item.func_77982_d(new NBTTagCompound());
        }
        if (!item.func_77978_p().func_150297_b("ench", 9)) {
            item.func_77978_p().func_74782_a("ench", (NBTBase)new NBTTagList());
        }
        NBTTagList nbttaglist = item.func_77978_p().func_150295_c("ench", 10);
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        nbttagcompound.func_74777_a("id", (short)Enchantment.func_185258_b((Enchantment)ench));
        nbttagcompound.func_74777_a("lvl", (short)level);
        nbttaglist.func_74742_a((NBTBase)nbttagcompound);
    }

    public void setTileNBT(String json) throws NBTException {
        this.tile = new NBTPredicateExtended(JsonToNBTExtended.getTagFromJson(json));
    }

    public void setStateJson(String json) {
        this.stateJson = json;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public void setMeta(MinMaxBounds meta) {
        this.meta = meta;
    }

    public void setCount(MinMaxBounds count) {
        this.count = count;
    }

    public void setDurability(MinMaxBounds durability) {
        this.durability = durability;
    }

    public void addEnchantment(EnchantmentPredicate predicate) {
        this.enchantmentData.add(predicate);
    }

    public void setPotion(String potion) throws Exception {
        PotionType type = PotionType.func_185168_a((String)potion);
        if (type == null) {
            throw new Exception(potion + " is not a valid potion type.");
        }
        this.potionType = type;
    }

    public void setNBT(String json) throws NBTException {
        this.nbt = new NBTPredicateExtended(JsonToNBTExtended.getTagFromJson(json));
    }

    public void setOre(String ore) throws Exception {
        if (!OreDictionary.doesOreNameExist((String)ore)) {
            throw new Exception(ore + " is not a valid ore dictionary name.");
        }
        this.oreDict = ore;
    }

    public ItemBlockData meta(int meta) {
        this.setMeta(new MinMaxBounds(Float.valueOf(meta), Float.valueOf(meta)));
        return this;
    }

    public ItemBlockData state(String state) {
        this.setStateJson(state);
        return this;
    }
}

