/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.lib.util;

import com.bloodnbonesgaming.lib.BNBGamingLib;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Iterator;
import java.util.stream.Stream;
import org.apache.commons.lang3.SystemUtils;

public class FileHelper {
    public static BufferedReader openReader(File file) throws FileNotFoundException {
        return new BufferedReader(new FileReader(file));
    }

    public static BufferedWriter openWriter(File file) throws IOException {
        return new BufferedWriter(new FileWriter(file));
    }

    public static void writeText(String fileName, String text) {
        FileHelper.writeText(new File(fileName), text);
    }

    public static void writeText(File file, String text) {
        file.getParentFile().mkdirs();
        try (BufferedWriter writer = FileHelper.openWriter(file);){
            writer.write(text);
        }
        catch (Exception e1) {
            BNBGamingLib.libInstance.getLog().error("Failed to write file " + file.getName());
            e1.printStackTrace();
        }
    }

    public static void copyDirectoryFromJar(Class<?> classInJar, String jarDirectory, String destinationFolder) {
        String path = classInJar.getProtectionDomain().getCodeSource().getLocation().getPath();
        try {
            String decodedPath = URLDecoder.decode(path, "UTF-8");
            String[] split = decodedPath.split("!");
            try (FileSystem fileSystem = FileSystems.newFileSystem(Paths.get(split[0].substring(SystemUtils.IS_OS_WINDOWS ? 6 : 5), new String[0]), classInJar.getClassLoader());){
                Path jarPath = fileSystem.getPath(jarDirectory, new String[0]);
                FileHelper.iteratePath(classInJar, jarPath, jarDirectory, destinationFolder);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        catch (UnsupportedEncodingException e1) {
            e1.printStackTrace();
        }
    }

    private static void iteratePath(Class<?> classInJar, Path jarPath, String jarDirectory, String destinationFolder) {
        try (Stream<Path> walk = Files.walk(jarPath, Integer.MAX_VALUE, new FileVisitOption[0]);){
            Iterator it = walk.iterator();
            while (it.hasNext()) {
                Path path = (Path)it.next();
                if (Files.isDirectory(path, new LinkOption[0])) continue;
                FileHelper.readWrite(classInJar, path.toString(), jarDirectory, destinationFolder);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void readWrite(Class<?> classInJar, String jarPosition, String jarDirectory, String destinationFolder) {
        File end = new File(destinationFolder.concat(jarPosition.substring(jarDirectory.length())));
        try {
            end.getParentFile().mkdirs();
            end.createNewFile();
            byte[] buffer = new byte[4096];
            try (InputStream stream = classInJar.getResourceAsStream(jarPosition);
                 FileOutputStream outStream = new FileOutputStream(end);){
                int readBytes;
                while ((readBytes = stream.read(buffer)) > 0) {
                    ((OutputStream)outStream).write(buffer, 0, readBytes);
                }
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }
}

