/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.world.feature;

import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import vazkii.arl.recipe.RecipeHandler;
import vazkii.arl.util.ProxyRegistry;
import vazkii.quark.base.handler.DimensionConfig;
import vazkii.quark.base.handler.ModIntegrationHandler;
import vazkii.quark.base.module.Feature;
import vazkii.quark.base.module.ModuleLoader;
import vazkii.quark.misc.feature.ColorRunes;
import vazkii.quark.world.block.BlockCrystal;
import vazkii.quark.world.block.BlockCrystalPane;
import vazkii.quark.world.world.CrystalCaveGenerator;

public class CrystalCaves
extends Feature {
    public static Block crystal;
    public static Block crystalPane;
    public static DimensionConfig dims;
    public static double crystalCaveRarity;
    public static double oreChance;
    public static double crystalRate;
    public static boolean enablePanes;

    @Override
    public void setupConfig() {
        crystalCaveRarity = this.loadLegacyPropChance("Crystal Cave Percentage Chance", "Crystal Cave Rarity", "The percentage chance crystal caves will spawn in a given chunk", 0.006666666666666667);
        oreChance = this.loadPropChance("Ore Chance", "Chance that, if a crystal location doesn't spawn a crystal, it will spawn an ore", 0.5);
        crystalRate = this.loadPropChance("Crystal Chance", "Chance that a given crystal location will actually spawn a crystal", 0.3);
        enablePanes = this.loadPropBool("Enable Panes", "", true);
        dims = new DimensionConfig(this.configCategory);
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        crystal = new BlockCrystal();
        if (enablePanes) {
            crystalPane = new BlockCrystalPane();
        }
        GameRegistry.registerWorldGenerator((IWorldGenerator)new CrystalCaveGenerator(dims), (int)1);
        ModIntegrationHandler.allowChiselAndBitsChiseling(crystal);
    }

    @Override
    public void postPreInit() {
        if (ModuleLoader.isFeatureEnabled(ColorRunes.class)) {
            this.addRuneRecipe(0, 0);
            this.addRuneRecipe(1, 14);
            this.addRuneRecipe(2, 1);
            this.addRuneRecipe(3, 4);
            this.addRuneRecipe(4, 5);
            this.addRuneRecipe(5, 3);
            this.addRuneRecipe(6, 11);
            this.addRuneRecipe(7, 2);
            this.addRuneRecipe(8, 15);
        }
        if (enablePanes) {
            for (int i = 0; i < BlockCrystal.Variants.values().length; ++i) {
                RecipeHandler.addShapedRecipe((ItemStack)ProxyRegistry.newStack((Block)crystalPane, (int)16, (int)i), (Object[])new Object[]{"CCC", "CCC", Character.valueOf('C'), ProxyRegistry.newStack((Block)crystal, (int)1, (int)i)});
            }
        }
    }

    private void addRuneRecipe(int crystalMeta, int runeMeta) {
        RecipeHandler.addOreDictRecipe((ItemStack)ProxyRegistry.newStack((Item)ColorRunes.rune, (int)1, (int)runeMeta), (Object[])new Object[]{"CCC", "CSC", "CCC", Character.valueOf('C'), ProxyRegistry.newStack((Block)crystal, (int)1, (int)crystalMeta), Character.valueOf('S'), "stone"});
    }

    @Override
    public boolean requiresMinecraftRestartToEnable() {
        return true;
    }
}

