/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.world.block;

import java.util.List;
import java.util.Locale;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.arl.interf.IBlockColorProvider;
import vazkii.quark.base.block.IQuarkBlock;
import vazkii.quark.world.feature.TreeVariants;

public class BlockVariantLeaves
extends BlockLeaves
implements IQuarkBlock,
IBlockColorProvider {
    public static final PropertyEnum<Variant> VARIANT = PropertyEnum.func_177709_a((String)"variant", Variant.class);
    private final String[] variants = new String[]{"swamp_leaves", "sakura_leaves"};
    private final String bareName;

    public BlockVariantLeaves() {
        this.bareName = "variant_leaves";
        this.func_149663_c(this.bareName);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(VARIANT, (Comparable)((Object)Variant.SWAMP_LEAVES)).func_177226_a((IProperty)field_176236_b, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)field_176237_a, (Comparable)Boolean.valueOf(true)));
    }

    @Nonnull
    public Block func_149663_c(@Nonnull String name) {
        super.func_149663_c(name);
        this.register(name);
        return this;
    }

    public int func_180651_a(IBlockState state) {
        return ((Variant)((Object)state.func_177229_b(VARIANT))).ordinal();
    }

    @Nonnull
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)TreeVariants.variant_sapling);
    }

    @Nonnull
    public ItemStack func_185473_a(World worldIn, BlockPos pos, @Nonnull IBlockState state) {
        return new ItemStack((Block)this, 1, ((Variant)((Object)state.func_177229_b(VARIANT))).ordinal());
    }

    @Nonnull
    protected ItemStack func_180643_i(@Nonnull IBlockState state) {
        return new ItemStack((Block)this, 1, ((Variant)((Object)state.func_177229_b(VARIANT))).ordinal());
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)Variant.values()[meta & 1])).func_177226_a((IProperty)field_176237_a, (Comparable)Boolean.valueOf((meta & 4) != 0)).func_177226_a((IProperty)field_176236_b, (Comparable)Boolean.valueOf((meta & 8) > 0));
    }

    public int func_176201_c(IBlockState state) {
        int i = ((Variant)((Object)state.func_177229_b(VARIANT))).ordinal() & 1;
        if (((Boolean)state.func_177229_b((IProperty)field_176237_a)).booleanValue()) {
            i |= 4;
        }
        if (((Boolean)state.func_177229_b((IProperty)field_176236_b)).booleanValue()) {
            i |= 8;
        }
        return i;
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT, field_176236_b, field_176237_a});
    }

    @Nonnull
    public BlockPlanks.EnumType func_176233_b(int meta) {
        return BlockPlanks.EnumType.OAK;
    }

    public void func_180657_a(@Nonnull World worldIn, EntityPlayer player, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nullable TileEntity te, ItemStack stack) {
        if (!worldIn.field_72995_K && stack.func_77973_b() == Items.field_151097_aZ) {
            player.func_71029_a(StatList.func_188055_a((Block)this));
            BlockVariantLeaves.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)this.func_180643_i(state));
        } else {
            super.func_180657_a(worldIn, player, pos, state, te, stack);
        }
    }

    @Nonnull
    public List<ItemStack> onSheared(@Nonnull ItemStack item, IBlockAccess world, BlockPos pos, int fortune) {
        return NonNullList.func_191197_a((int)1, (Object)new ItemStack((Block)this, 1, ((Variant)((Object)world.func_180495_p(pos).func_177229_b(VARIANT))).ordinal()));
    }

    public String getBareName() {
        return this.bareName;
    }

    public String[] getVariants() {
        return this.variants;
    }

    @SideOnly(value=Side.CLIENT)
    public ItemMeshDefinition getCustomMeshDefinition() {
        return null;
    }

    public EnumRarity getBlockRarity(ItemStack stack) {
        return EnumRarity.COMMON;
    }

    public IProperty[] getIgnoredProperties() {
        return new IProperty[]{field_176236_b, field_176237_a};
    }

    public IProperty getVariantProp() {
        return VARIANT;
    }

    public Class getVariantEnum() {
        return Variant.class;
    }

    @SideOnly(value=Side.CLIENT)
    public IItemColor getItemColor() {
        return (stack, i) -> stack.func_77960_j() == 0 ? 6975545 : 0xFFFFFF;
    }

    @SideOnly(value=Side.CLIENT)
    public IBlockColor getBlockColor() {
        return (state, world, pos, i) -> state.func_177229_b(VARIANT) == Variant.SWAMP_LEAVES ? 6975545 : 0xFFFFFF;
    }

    public static enum Variant implements IStringSerializable
    {
        SWAMP_LEAVES,
        SAKURA_LEAVES;


        public String func_176610_l() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

