/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.tweaks.feature;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.PotionEffect;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import vazkii.quark.base.module.Feature;

public class JumpBoostStepAssist
extends Feature {
    public static final List<String> playersWithStepup = new ArrayList<String>();
    public static int minimumLevel;
    public static boolean canToggleWithSneak;

    @Override
    public void setupConfig() {
        minimumLevel = this.loadPropInt("Minimum Jump Boost level", "", 2);
        canToggleWithSneak = this.loadPropBool("Can toggle with sneaking", "", true);
        --minimumLevel;
    }

    @SubscribeEvent
    public void updatePlayerStepStatus(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntityLiving() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntityLiving();
            String s = JumpBoostStepAssist.playerStr(player);
            if (playersWithStepup.contains(s)) {
                if (this.shouldPlayerHaveStepup(player)) {
                    player.field_70138_W = canToggleWithSneak && player.func_70093_af() ? 0.50001f : 1.25f;
                } else {
                    player.field_70138_W = 0.5f;
                    playersWithStepup.remove(s);
                }
            } else if (this.shouldPlayerHaveStepup(player)) {
                playersWithStepup.add(s);
                player.field_70138_W = 1.25f;
            }
        }
    }

    private boolean shouldPlayerHaveStepup(EntityPlayer player) {
        PotionEffect jumpBoost = player.func_70660_b(MobEffects.field_76430_j);
        return jumpBoost != null && jumpBoost.func_76458_c() >= minimumLevel;
    }

    @SubscribeEvent
    public void playerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        String username = event.player.func_146103_bH().getName();
        playersWithStepup.remove(username + ":false");
        playersWithStepup.remove(username + ":true");
    }

    public static String playerStr(EntityPlayer player) {
        return player.func_146103_bH().getName() + ":" + player.func_130014_f_().field_72995_K;
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }

    @Override
    public String getFeatureIngameConfigName() {
        return "Jump Boost Step Assist";
    }
}

