/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.experimental.features;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.inventory.Slot;
import net.minecraft.inventory.SlotCrafting;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLException;
import org.lwjgl.input.Cursor;
import org.lwjgl.input.Mouse;
import vazkii.quark.base.module.Feature;

public class ReactiveCursor
extends Feature {
    private static final String CURSOR_ROOT = "textures/cursors/";
    private static final HashMap<String, Cursor> CURSORS = new HashMap();
    private static final String CURSOR_POINTER = "pointer";
    private static final String CURSOR_FINGER = "finger";
    private static final String CURSOR_OPEN_HAND = "open_hand";
    private static final String CURSOR_CLOSED_HAND = "closed_hand";
    private static final String CURSOR_SAW = "saw";
    public static String currentCursor = "";

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initClient() {
        ReactiveCursor.putCursor(CURSOR_POINTER, 0.0, 1.0);
        ReactiveCursor.putCursor(CURSOR_FINGER, 0.4, 1.0);
        ReactiveCursor.putCursor(CURSOR_OPEN_HAND, 0.4, 1.0);
        ReactiveCursor.putCursor(CURSOR_CLOSED_HAND, 0.4, 1.0);
        ReactiveCursor.putCursor(CURSOR_SAW, 1.0, 1.0);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onTick(TickEvent.RenderTickEvent event) {
        String cursorName;
        if (event.phase == TickEvent.Phase.END && !currentCursor.equals(cursorName = this.getCursor())) {
            Cursor cursor = CURSORS.get(cursorName);
            try {
                if (cursor != null) {
                    Mouse.setNativeCursor((Cursor)cursor);
                }
            }
            catch (LWJGLException e) {
                e.printStackTrace();
            }
            currentCursor = cursorName;
        }
    }

    @SideOnly(value=Side.CLIENT)
    private String getCursor() {
        Minecraft mc = Minecraft.func_71410_x();
        GuiScreen gui = mc.field_71462_r;
        if (gui != null) {
            if (gui instanceof GuiContainer) {
                GuiContainer container = (GuiContainer)gui;
                if (!mc.field_71439_g.field_71071_by.func_70445_o().func_190926_b()) {
                    return CURSOR_CLOSED_HAND;
                }
                Slot hovered = container.getSlotUnderMouse();
                if (hovered != null && !hovered.func_75211_c().func_190926_b()) {
                    if (hovered instanceof SlotCrafting) {
                        return CURSOR_SAW;
                    }
                    return CURSOR_OPEN_HAND;
                }
            }
            List buttonList = (List)ObfuscationReflectionHelper.getPrivateValue(GuiScreen.class, (Object)gui, (String)"field_146292_n");
            for (GuiButton b : buttonList) {
                if (!b.func_146115_a()) continue;
                return CURSOR_FINGER;
            }
        }
        return CURSOR_POINTER;
    }

    @Override
    public boolean hasSubscriptions() {
        return this.isClient();
    }

    @SideOnly(value=Side.CLIENT)
    private static void putCursor(String name, double xAnchor, double yAnchor) {
        ReactiveCursor.putCursor(name, name + ".png", xAnchor, yAnchor);
    }

    @SideOnly(value=Side.CLIENT)
    private static void putCursor(String name, String file, double xAnchor, double yAnchor) {
        ReactiveCursor.putCursor(name, new ResourceLocation("quark", CURSOR_ROOT + file), xAnchor, yAnchor);
    }

    @SideOnly(value=Side.CLIENT)
    private static void putCursor(String name, ResourceLocation res, double xAnchor, double yAnchor) {
        try {
            CURSORS.put(name, null);
            Minecraft mc = Minecraft.func_71410_x();
            InputStream stream = mc.func_110442_L().func_110536_a(res).func_110527_b();
            BufferedImage img = ImageIO.read(stream);
            int width = img.getWidth();
            int height = img.getHeight();
            if (width == 0 || height == 0) {
                throw new IOException("Invalid image " + res + " (Img: " + img + ", Stream: " + stream + ")");
            }
            int[] colors = new int[width * height];
            ByteBuffer buf = BufferUtils.createByteBuffer((int)(colors.length * 4));
            img.getRGB(0, 0, width, height, colors, 0, width);
            boolean pixels = false;
            for (int i = colors.length - 1; i >= 0; --i) {
                int color = colors[i / height * height + (width - i % width - 1)];
                int a = color >> 24 & 0xFF;
                int r = color >> 16 & 0xFF;
                int g = color >> 8 & 0xFF;
                int b = color & 0xFF;
                buf.put((byte)b);
                buf.put((byte)g);
                buf.put((byte)r);
                buf.put((byte)a);
            }
            buf.flip();
            int xHotspot = MathHelper.func_76125_a((int)((int)((double)width * xAnchor)), (int)0, (int)(width - 1));
            int yHotspot = MathHelper.func_76125_a((int)((int)((double)height * yAnchor)), (int)0, (int)(height - 1));
            Cursor cursor = new Cursor(width, height, xHotspot, yHotspot, 1, buf.asIntBuffer(), null);
            CURSORS.put(name, cursor);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean requiresMinecraftRestartToEnable() {
        return true;
    }
}

