/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.client;

import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.client.resources.AbstractResourcePack;
import vazkii.quark.base.Quark;

public class ResourceProxy
extends AbstractResourcePack {
    private static final String MINECRAFT = "minecraft";
    private static final Set<String> RESOURCE_DOMAINS = ImmutableSet.of((Object)"minecraft");
    private static final String BARE_FORMAT = "assets/minecraft/%s/%s";
    private static final String OVERRIDE_FORMAT = "/assets/quark/%s/overrides/%s";
    private static final Map<String, String> overrides = new HashMap<String, String>();

    public ResourceProxy(File file) {
        super(file);
        overrides.put("pack.mcmeta", "/proxypack.mcmeta");
    }

    public void addResource(String path, String file) {
        String bare = String.format(BARE_FORMAT, path, file);
        String override = String.format(OVERRIDE_FORMAT, path, file);
        overrides.put(bare, override);
    }

    @Nonnull
    public Set<String> func_110587_b() {
        return RESOURCE_DOMAINS;
    }

    @Nonnull
    protected InputStream func_110591_a(@Nonnull String name) {
        return Quark.class.getResourceAsStream(overrides.get(name));
    }

    protected boolean func_110593_b(@Nonnull String name) {
        return overrides.containsKey(name);
    }

    protected void func_110594_c(@Nonnull String name) {
    }

    @Nonnull
    public String func_130077_b() {
        return "quark-texture-proxy";
    }
}

