/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.world.village;

import com.github.alexthe666.rats.server.entity.EntityRat;
import com.github.alexthe666.rats.server.world.gen.RatsVillageProcessor;
import com.github.alexthe666.rats.server.world.gen.WorldGenRatRuin;
import com.github.alexthe666.rats.server.world.village.RatsVillageRegistry;
import com.github.alexthe666.rats.server.world.village.VillageComponentPetShop;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.passive.EntityParrot;
import net.minecraft.entity.passive.EntityRabbit;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.init.Blocks;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraft.world.gen.structure.template.ITemplateProcessor;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraft.world.gen.structure.template.TemplateManager;

public class WorldGenPetShop
extends WorldGenerator {
    public static final ResourceLocation UPSTAIRS_LOOT = new ResourceLocation("rats", "pet_shop_upstairs");
    public static final ResourceLocation LOOT = new ResourceLocation("rats", "pet_shop");
    private static final ResourceLocation STRUCTURE = new ResourceLocation("rats", "village_petshop");
    public List<BlockPos> ocelotPos = new ArrayList<BlockPos>();
    public List<BlockPos> wolfPos = new ArrayList<BlockPos>();
    public List<BlockPos> rabbitPos = new ArrayList<BlockPos>();
    public List<BlockPos> ratPos = new ArrayList<BlockPos>();
    public List<BlockPos> parrotPos = new ArrayList<BlockPos>();
    public List<BlockPos> villagerPos = new ArrayList<BlockPos>();
    private VillageComponentPetShop component;
    private Rotation rotation;
    private EnumFacing facing;

    public WorldGenPetShop(VillageComponentPetShop component, EnumFacing facing) {
        this.component = component;
        this.facing = facing;
        switch (facing) {
            case SOUTH: {
                this.rotation = Rotation.CLOCKWISE_180;
                break;
            }
            case EAST: {
                this.rotation = Rotation.CLOCKWISE_90;
                break;
            }
            case WEST: {
                this.rotation = Rotation.COUNTERCLOCKWISE_90;
                break;
            }
            default: {
                this.rotation = Rotation.NONE;
            }
        }
    }

    public boolean func_180709_b(World worldIn, Random rand, BlockPos position) {
        if (worldIn == null) {
            return false;
        }
        this.ocelotPos.clear();
        this.parrotPos.clear();
        this.wolfPos.clear();
        this.ratPos.clear();
        this.villagerPos.clear();
        this.rabbitPos.clear();
        MinecraftServer server = worldIn.func_73046_m();
        TemplateManager templateManager = worldIn.func_72860_G().func_186340_h();
        PlacementSettings settings = new PlacementSettings().func_186220_a(WorldGenRatRuin.getRotationFromFacing(this.facing)).func_186225_a(Blocks.field_150350_a);
        Template template = templateManager.func_186237_a(server, STRUCTURE);
        Biome biome = worldIn.func_180494_b(position);
        int spawnedVillager = 0;
        BlockPos genPos = position.func_177981_b(2).func_177967_a(this.facing, template.func_186259_a().func_177952_p()).func_177967_a(this.facing.func_176735_f(), template.func_186259_a().func_177958_n());
        template.func_189960_a(worldIn, genPos, (ITemplateProcessor)new RatsVillageProcessor(position.func_177981_b(3), this, settings, biome), settings, 2);
        Iterator<BlockPos> ocelotItr = this.ocelotPos.iterator();
        while (ocelotItr.hasNext()) {
            BlockPos pos = ocelotItr.next();
            if (worldIn.field_73012_v.nextInt(3) == 0) {
                EntityOcelot ocelot = new EntityOcelot(worldIn);
                ocelot.func_110163_bv();
                ocelot.func_70080_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, rand.nextFloat() * 360.0f, 0.0f);
                worldIn.func_72838_d((Entity)ocelot);
            }
            ocelotItr.remove();
        }
        Iterator<BlockPos> ratItr = this.ratPos.iterator();
        while (ratItr.hasNext()) {
            BlockPos pos = ratItr.next();
            EntityRat rat = new EntityRat(worldIn);
            rat.func_180482_a(worldIn.func_175649_E(pos), null);
            rat.setPlague(false);
            rat.func_110163_bv();
            rat.func_70080_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, rand.nextFloat() * 360.0f, 0.0f);
            worldIn.func_72838_d((Entity)rat);
            ratItr.remove();
        }
        Iterator<BlockPos> rabbitItr = this.rabbitPos.iterator();
        while (rabbitItr.hasNext()) {
            BlockPos pos = rabbitItr.next();
            if (worldIn.field_73012_v.nextInt(3) == 0) {
                EntityRat rat = worldIn.field_73012_v.nextBoolean() ? new EntityRat(worldIn) : new EntityRabbit(worldIn);
                rat.func_110163_bv();
                rat.func_70080_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, rand.nextFloat() * 360.0f, 0.0f);
                worldIn.func_72838_d((Entity)rat);
            }
            rabbitItr.remove();
        }
        Iterator<BlockPos> wolfItr = this.wolfPos.iterator();
        while (wolfItr.hasNext()) {
            BlockPos pos = wolfItr.next();
            if (worldIn.field_73012_v.nextInt(3) == 0) {
                EntityWolf wolf = new EntityWolf(worldIn);
                wolf.func_110163_bv();
                wolf.func_70080_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, rand.nextFloat() * 360.0f, 0.0f);
                worldIn.func_72838_d((Entity)wolf);
            }
            wolfItr.remove();
        }
        Iterator<BlockPos> parrotItr = this.parrotPos.iterator();
        while (parrotItr.hasNext()) {
            BlockPos pos = parrotItr.next();
            EntityParrot parrot = new EntityParrot(worldIn);
            parrot.func_110163_bv();
            parrot.func_70080_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.1, (double)pos.func_177952_p() + 0.5, rand.nextFloat() * 360.0f, 0.0f);
            worldIn.func_72838_d((Entity)parrot);
            parrotItr.remove();
        }
        Iterator<BlockPos> villageItr = this.villagerPos.iterator();
        while (villageItr.hasNext() && spawnedVillager < 1) {
            BlockPos pos = villageItr.next();
            EntityVillager villager = new EntityVillager(worldIn);
            villager.func_180482_a(worldIn.func_175649_E(pos), null);
            villager.setProfession(RatsVillageRegistry.PET_SHOP_OWNER);
            villager.func_190672_a(worldIn.func_175649_E(new BlockPos((Entity)villager)), null, false);
            villager.func_70080_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, rand.nextFloat() * 360.0f, 0.0f);
            worldIn.func_72838_d((Entity)villager);
            villageItr.remove();
            ++spawnedVillager;
        }
        this.ocelotPos.clear();
        this.parrotPos.clear();
        this.wolfPos.clear();
        this.ratPos.clear();
        this.villagerPos.clear();
        this.rabbitPos.clear();
        return true;
    }
}

