/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.world.gen;

import com.github.alexthe666.rats.server.world.gen.StructureRatRoadPieces;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.MapGenStructure;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.StructureStart;
import net.minecraft.world.gen.structure.StructureVillagePieces;

public class MapGenRatRoad
extends MapGenStructure {
    private final int minTownSeparation;
    private int size = 40;
    private int distance = 9;

    public MapGenRatRoad() {
        this.minTownSeparation = 4;
    }

    public MapGenRatRoad(Map<String, String> map) {
        this();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (entry.getKey().equals("size")) {
                this.size = MathHelper.func_82714_a((String)entry.getValue(), (int)this.size, (int)0);
                continue;
            }
            if (!entry.getKey().equals("distance")) continue;
            this.distance = MathHelper.func_82714_a((String)entry.getValue(), (int)this.distance, (int)9);
        }
    }

    public String func_143025_a() {
        return "RatRoads";
    }

    @Nullable
    public BlockPos func_180706_b(World worldIn, BlockPos pos, boolean findUnexplored) {
        return null;
    }

    protected boolean func_75047_a(int chunkX, int chunkZ) {
        return chunkX == 0 && chunkZ == 0;
    }

    protected StructureStart func_75049_b(int chunkX, int chunkZ) {
        return new Start(this.field_75039_c, new Random(this.field_75039_c.func_72905_C()), chunkX, chunkZ, this.size);
    }

    public static class Start
    extends StructureStart {
        private boolean hasMoreThanTwoComponents;

        public Start() {
        }

        public Start(World worldIn, Random rand, int x, int z, int size) {
            super(x, z);
            List<StructureRatRoadPieces.PieceWeight> list = StructureRatRoadPieces.getStructureVillageWeightedPieceList(rand, size);
            StructureRatRoadPieces.Start structurevillagepieces$start = new StructureRatRoadPieces.Start(worldIn.func_72959_q(), 0, rand, (x << 4) + 2, (z << 4) + 2, list, size);
            this.field_75075_a.add(structurevillagepieces$start);
            structurevillagepieces$start.func_74861_a(structurevillagepieces$start, this.field_75075_a, rand);
            List<StructureComponent> list1 = structurevillagepieces$start.pendingRoads;
            List<StructureComponent> list2 = structurevillagepieces$start.pendingHouses;
            while (!list1.isEmpty() || !list2.isEmpty()) {
                if (list1.isEmpty()) {
                    int i = rand.nextInt(list2.size());
                    StructureComponent structurecomponent = list2.remove(i);
                    structurecomponent.func_74861_a((StructureComponent)structurevillagepieces$start, this.field_75075_a, rand);
                    continue;
                }
                int j = rand.nextInt(list1.size());
                StructureComponent structurecomponent2 = list1.remove(j);
                structurecomponent2.func_74861_a((StructureComponent)structurevillagepieces$start, this.field_75075_a, rand);
            }
            this.func_75072_c();
            int k = 0;
            for (StructureComponent structurecomponent1 : this.field_75075_a) {
                if (structurecomponent1 instanceof StructureVillagePieces.Road) continue;
                ++k;
            }
            this.hasMoreThanTwoComponents = k > 2;
        }

        public boolean func_75069_d() {
            return this.hasMoreThanTwoComponents;
        }

        public void func_143022_a(NBTTagCompound tagCompound) {
            super.func_143022_a(tagCompound);
            tagCompound.func_74757_a("Valid", this.hasMoreThanTwoComponents);
        }

        public void func_143017_b(NBTTagCompound tagCompound) {
            super.func_143017_b(tagCompound);
            this.hasMoreThanTwoComponents = tagCompound.func_74767_n("Valid");
        }
    }
}

