/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity.tile;

import com.github.alexthe666.rats.RatsMod;
import com.github.alexthe666.rats.server.items.ItemRatCombinedUpgrade;
import com.github.alexthe666.rats.server.items.ItemRatUpgrade;
import com.github.alexthe666.rats.server.items.RatsItemRegistry;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class TileEntityUpgradeCombiner
extends TileEntity
implements ITickable,
ISidedInventory {
    private static final int[] SLOTS_TOP = new int[]{0, 2};
    private static final int[] SLOTS_SIDE = new int[]{1};
    private static final int[] SLOTS_BOTTOM = new int[]{3};
    public int ticksExisted;
    public float ratRotation;
    public float ratRotationPrev;
    public float tRot;
    IItemHandler handlerTop = new SidedInvWrapper((ISidedInventory)this, EnumFacing.UP);
    IItemHandler handlerSide = new SidedInvWrapper((ISidedInventory)this, EnumFacing.NORTH);
    IItemHandler handlerBottom = new SidedInvWrapper((ISidedInventory)this, EnumFacing.DOWN);
    private NonNullList<ItemStack> combinerStacks = NonNullList.func_191197_a((int)4, (Object)ItemStack.field_190927_a);
    private int furnaceBurnTime;
    private int currentItemBurnTime;
    private int cookTime;
    private int totalCookTime;

    public static int getItemBurnTime(ItemStack stack) {
        return stack.func_77973_b() == RatsItemRegistry.GEM_OF_RATLANTIS ? 150 : 0;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.field_174879_c, this.field_174879_c.func_177982_a(1, 2, 1));
    }

    public int func_70302_i_() {
        return this.combinerStacks.size();
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.combinerStacks) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int index) {
        return (ItemStack)this.combinerStacks.get(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        return ItemStackHelper.func_188382_a(this.combinerStacks, (int)index, (int)count);
    }

    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a(this.combinerStacks, (int)index);
    }

    public void func_70299_a(int index, ItemStack stack) {
        ItemStack itemstack = (ItemStack)this.combinerStacks.get(index);
        boolean flag = !stack.func_190926_b() && stack.func_77969_a(itemstack) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)itemstack);
        this.combinerStacks.set(index, (Object)stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        if (index == 0 && !flag) {
            this.totalCookTime = this.getCookTime(stack);
            this.cookTime = 0;
            this.func_70296_d();
        }
    }

    public int getCookTime(ItemStack stack) {
        return 300;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.combinerStacks = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((NBTTagCompound)compound, this.combinerStacks);
        this.furnaceBurnTime = compound.func_74762_e("BurnTime");
        this.cookTime = compound.func_74762_e("CookTime");
        this.totalCookTime = compound.func_74762_e("CookTimeTotal");
        this.currentItemBurnTime = TileEntityUpgradeCombiner.getItemBurnTime((ItemStack)this.combinerStacks.get(1));
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("BurnTime", (int)((short)this.furnaceBurnTime));
        compound.func_74768_a("CookTime", (int)((short)this.cookTime));
        compound.func_74768_a("CookTimeTotal", (int)((short)this.totalCookTime));
        ItemStackHelper.func_191282_a((NBTTagCompound)compound, this.combinerStacks);
        return compound;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public boolean isBurning() {
        return this.furnaceBurnTime > 0;
    }

    public void func_73660_a() {
        float f2;
        this.totalCookTime = 300;
        this.ratRotationPrev = this.ratRotation;
        ++this.ticksExisted;
        boolean flag = this.isBurning();
        boolean flag1 = false;
        EntityPlayer entityplayer = this.field_145850_b.func_184137_a((double)((float)this.field_174879_c.func_177958_n() + 0.5f), (double)((float)this.field_174879_c.func_177956_o() + 0.5f), (double)((float)this.field_174879_c.func_177952_p() + 0.5f), 10.0, false);
        if (entityplayer != null) {
            double d0 = entityplayer.field_70165_t - (double)((float)this.field_174879_c.func_177958_n() + 0.5f);
            double d1 = entityplayer.field_70161_v - (double)((float)this.field_174879_c.func_177952_p() + 0.5f);
            this.tRot = (float)MathHelper.func_181159_b((double)d1, (double)d0);
        } else {
            this.tRot += 0.04f;
        }
        while (this.ratRotation >= (float)Math.PI) {
            this.ratRotation -= (float)Math.PI * 2;
        }
        while (this.ratRotation < (float)(-Math.PI)) {
            this.ratRotation += (float)Math.PI * 2;
        }
        for (f2 = this.tRot - this.ratRotation; f2 >= (float)Math.PI; f2 -= (float)Math.PI * 2) {
        }
        while (f2 < (float)(-Math.PI)) {
            f2 += (float)Math.PI * 2;
        }
        this.ratRotation += f2 * 0.4f;
        if (this.isBurning()) {
            --this.furnaceBurnTime;
        }
        if (this.field_145850_b.field_72995_K) {
            float radius = (float)Math.sin((double)this.ticksExisted * 0.1);
            double extraY = (double)this.field_174879_c.func_177956_o() + 1.05;
            for (int i = 0; i < 3; ++i) {
                float angle = (float)Math.PI / 180 * (float)(this.ticksExisted * 4 + i * 120);
                double extraX = (double)(radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)))) + (double)this.field_174879_c.func_177958_n() + 0.5;
                double extraZ = (double)(radius * MathHelper.func_76134_b((float)angle)) + (double)this.field_174879_c.func_177952_p() + 0.5;
                RatsMod.PROXY.spawnParticle("upgrade_combiner", extraX, extraY, extraZ, -0.1f, -0.1f, 0.0);
            }
        }
        if (!this.field_145850_b.field_72995_K) {
            ItemStack fuel = (ItemStack)this.combinerStacks.get(1);
            if (this.isBurning() || !fuel.func_190926_b() && !((ItemStack)this.combinerStacks.get(0)).func_190926_b() && !((ItemStack)this.combinerStacks.get(2)).func_190926_b()) {
                if (!this.isBurning() && this.canSmelt()) {
                    this.currentItemBurnTime = this.furnaceBurnTime = TileEntityUpgradeCombiner.getItemBurnTime(fuel);
                    if (this.isBurning()) {
                        flag1 = true;
                        if (!fuel.func_190926_b()) {
                            Item item = fuel.func_77973_b();
                            fuel.func_190918_g(1);
                            if (fuel.func_190926_b()) {
                                ItemStack item1 = item.getContainerItem(fuel);
                                this.combinerStacks.set(1, (Object)item1);
                            }
                        }
                    }
                }
                if (this.isBurning() && this.canSmelt()) {
                    ++this.cookTime;
                    if (this.cookTime == this.totalCookTime) {
                        this.cookTime = 0;
                        this.totalCookTime = this.getCookTime((ItemStack)this.combinerStacks.get(0));
                        this.smeltItem();
                        flag1 = true;
                    }
                } else {
                    this.cookTime = 0;
                }
            } else if (!this.isBurning() && this.cookTime > 0) {
                this.cookTime = MathHelper.func_76125_a((int)(this.cookTime - 2), (int)0, (int)this.totalCookTime);
            }
        }
    }

    public void smeltItem() {
        if (this.canSmelt()) {
            ItemStack itemstack = (ItemStack)this.combinerStacks.get(0);
            ItemStack itemstack2 = (ItemStack)this.combinerStacks.get(3);
            ItemStack itemstack1 = this.getCombinerResult(itemstack, (ItemStack)this.combinerStacks.get(2));
            if (itemstack2.func_190926_b()) {
                this.combinerStacks.set(3, (Object)itemstack1.func_77946_l());
            } else if (itemstack2.func_77969_a(itemstack1)) {
                itemstack2.func_190917_f(itemstack1.func_190916_E());
            }
            if (itemstack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150360_v) && itemstack.func_77960_j() == 1 && !((ItemStack)this.combinerStacks.get(1)).func_190926_b() && ((ItemStack)this.combinerStacks.get(1)).func_77973_b() == Items.field_151133_ar) {
                this.combinerStacks.set(1, (Object)new ItemStack(Items.field_151131_as));
            }
            itemstack.func_190918_g(1);
            ((ItemStack)this.combinerStacks.get(2)).func_190918_g(1);
        }
    }

    private ItemStack getCombinerResult(ItemStack combiner, ItemStack stack) {
        if (!combiner.func_77942_o()) {
            combiner.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound nbttagcompound1 = combiner.func_77978_p();
        NonNullList nonnulllist = NonNullList.func_191197_a((int)27, (Object)ItemStack.field_190927_a);
        if (nbttagcompound1 != null && nbttagcompound1.func_150297_b("Items", 9)) {
            ItemStackHelper.func_191283_b((NBTTagCompound)nbttagcompound1, (NonNullList)nonnulllist);
        }
        int addIndex = -1;
        for (int i = 0; i < nonnulllist.size(); ++i) {
            if (nonnulllist.get(i) != ItemStack.field_190927_a) continue;
            addIndex = i;
            break;
        }
        if (addIndex == -1) {
            return combiner.func_77946_l();
        }
        nonnulllist.set(addIndex, (Object)stack.func_77946_l());
        ItemStackHelper.func_191282_a((NBTTagCompound)nbttagcompound1, (NonNullList)nonnulllist);
        combiner.func_77982_d(nbttagcompound1);
        return combiner.func_77946_l();
    }

    public boolean canSmelt() {
        if (!((ItemStack)this.combinerStacks.get(0)).func_190926_b() && ((ItemStack)this.combinerStacks.get(0)).func_77973_b() == RatsItemRegistry.RAT_UPGRADE_COMBINED) {
            return ItemRatCombinedUpgrade.canCombineWithUpgrade((ItemStack)this.combinerStacks.get(0), (ItemStack)this.combinerStacks.get(2));
        }
        return false;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        if (index == 3) {
            return false;
        }
        if (index == 2) {
            return stack.func_77973_b() instanceof ItemRatUpgrade && !(stack.func_77973_b() instanceof ItemRatCombinedUpgrade);
        }
        if (index == 1) {
            return stack.func_77973_b() == RatsItemRegistry.GEM_OF_RATLANTIS;
        }
        return stack.func_77973_b() instanceof ItemRatCombinedUpgrade;
    }

    public int func_174887_a_(int id) {
        switch (id) {
            case 0: {
                return this.furnaceBurnTime;
            }
            case 1: {
                return this.currentItemBurnTime;
            }
            case 2: {
                return this.cookTime;
            }
            case 3: {
                return this.totalCookTime;
            }
        }
        return 0;
    }

    public void func_174885_b(int id, int value) {
        switch (id) {
            case 0: {
                this.furnaceBurnTime = value;
                break;
            }
            case 1: {
                this.currentItemBurnTime = value;
                break;
            }
            case 2: {
                this.cookTime = value;
                break;
            }
            case 3: {
                this.totalCookTime = value;
            }
        }
    }

    public int func_174890_g() {
        return 4;
    }

    public void func_174888_l() {
        this.combinerStacks.clear();
    }

    public int[] func_180463_a(EnumFacing side) {
        if (side == EnumFacing.DOWN) {
            return SLOTS_BOTTOM;
        }
        if (side == EnumFacing.UP) {
            return SLOTS_TOP;
        }
        return SLOTS_SIDE;
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return this.func_94041_b(index, itemStackIn);
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        if (direction == EnumFacing.DOWN && index == 1) {
            Item item = stack.func_77973_b();
            return true;
        }
        return false;
    }

    public String func_70005_c_() {
        return "container.upgrade_combiner";
    }

    public boolean func_145818_k_() {
        return false;
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (facing != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == EnumFacing.DOWN) {
                return (T)this.handlerBottom;
            }
            if (facing == EnumFacing.UP) {
                return (T)this.handlerTop;
            }
            return (T)this.handlerSide;
        }
        return (T)super.getCapability(capability, facing);
    }

    public ITextComponent func_145748_c_() {
        return new TextComponentTranslation(this.func_70005_c_(), new Object[0]);
    }
}

