/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity.ai;

import com.github.alexthe666.rats.server.entity.EntityRat;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class RatAIFollowOwner
extends EntityAIBase {
    private final EntityRat rat;
    private final double followSpeed;
    World world;
    float maxDist;
    float minDist;
    private EntityLivingBase owner;
    private int timeToRecalcPath;
    private float oldWaterCost;

    public RatAIFollowOwner(EntityRat tameableIn, double followSpeedIn, float minDistIn, float maxDistIn) {
        this.rat = tameableIn;
        this.world = tameableIn.field_70170_p;
        this.followSpeed = followSpeedIn;
        this.minDist = minDistIn;
        this.maxDist = maxDistIn;
        this.func_75248_a(3);
    }

    public boolean func_75250_a() {
        if (this.rat.func_70909_n() && this.rat.isFollowing()) {
            EntityLivingBase entitylivingbase = this.rat.func_70902_q();
            if (entitylivingbase == null) {
                return false;
            }
            if (entitylivingbase instanceof EntityPlayer && ((EntityPlayer)entitylivingbase).func_175149_v()) {
                return false;
            }
            if (this.rat.func_70906_o()) {
                return false;
            }
            if (this.rat.func_70068_e((Entity)entitylivingbase) < (double)(this.minDist * this.minDist)) {
                return false;
            }
            this.owner = entitylivingbase;
            return true;
        }
        return false;
    }

    public boolean func_75253_b() {
        return !this.rat.func_70661_as().func_75500_f() && this.rat.isFollowing() && this.rat.func_70068_e((Entity)this.owner) > (double)(this.maxDist * this.maxDist);
    }

    public void func_75249_e() {
        this.timeToRecalcPath = 0;
        this.oldWaterCost = this.rat.func_184643_a(PathNodeType.WATER);
        this.rat.func_184644_a(PathNodeType.WATER, 0.0f);
    }

    public void func_75251_c() {
        this.owner = null;
        this.rat.func_70661_as().func_75499_g();
        this.rat.func_184644_a(PathNodeType.WATER, this.oldWaterCost);
    }

    public void func_75246_d() {
        this.rat.func_70671_ap().func_75651_a((Entity)this.owner, 10.0f, (float)this.rat.func_70646_bf());
        if (this.rat.isFollowing() && --this.timeToRecalcPath <= 0) {
            this.timeToRecalcPath = 10;
            boolean teleport = false;
            if (!this.rat.func_110167_bD() && !this.rat.func_184218_aH() && this.rat.func_70902_q() instanceof EntityPlayer && this.rat.func_70068_e((Entity)this.owner) >= 144.0) {
                teleport = true;
                int i = MathHelper.func_76128_c((double)this.owner.field_70165_t) - 2;
                int j = MathHelper.func_76128_c((double)this.owner.field_70161_v) - 2;
                int k = MathHelper.func_76128_c((double)this.owner.func_174813_aQ().field_72338_b);
                for (int l = 0; l <= 4; ++l) {
                    for (int i1 = 0; i1 <= 4; ++i1) {
                        if (l >= 1 && i1 >= 1 && l <= 3 && i1 <= 3 || !this.isTeleportFriendlyBlock(i, j, k, l, i1)) continue;
                        this.rat.func_70012_b((float)(i + l) + 0.5f, k, (float)(j + i1) + 0.5f, this.rat.field_70177_z, this.rat.field_70125_A);
                        this.rat.func_70661_as().func_75499_g();
                        return;
                    }
                }
            }
            if (!teleport) {
                this.rat.func_70661_as().func_75497_a((Entity)this.owner, this.followSpeed);
            }
        }
    }

    protected boolean isTeleportFriendlyBlock(int x, int z, int y, int xOffset, int zOffset) {
        BlockPos blockpos = new BlockPos(x + xOffset, y - 1, z + zOffset);
        IBlockState iblockstate = this.world.func_180495_p(blockpos);
        return iblockstate.func_193401_d((IBlockAccess)this.world, blockpos, EnumFacing.DOWN) == BlockFaceShape.SOLID && iblockstate.func_189884_a((Entity)this.rat) && this.world.func_175623_d(blockpos.func_177984_a()) && this.world.func_175623_d(blockpos.func_177981_b(2));
    }
}

