/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity.ai;

import com.github.alexthe666.rats.server.entity.EntityRat;
import com.github.alexthe666.rats.server.entity.RatCommand;
import com.github.alexthe666.rats.server.entity.RatUtils;
import com.github.alexthe666.rats.server.items.RatsItemRegistry;
import java.util.Comparator;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class RatAIDepositInInventory
extends EntityAIBase {
    private static final int RADIUS = 16;
    private final EntityRat entity;
    private final BlockSorter targetSorter;
    private BlockPos targetBlock = null;
    private int feedingTicks;
    private int breakingTime;
    private int previousBreakProgress;

    public RatAIDepositInInventory(EntityRat entity) {
        this.entity = entity;
        this.targetSorter = new BlockSorter((Entity)entity);
        this.func_75248_a(1);
    }

    public boolean func_75250_a() {
        if (!this.entity.canMove() || !this.entity.func_70909_n() || this.entity.getCommand() != RatCommand.TRANSPORT && this.entity.getCommand() != RatCommand.GATHER && this.entity.getCommand() != RatCommand.HUNT && this.entity.getCommand() != RatCommand.HARVEST || this.entity.func_70638_az() != null) {
            return false;
        }
        if (!this.entity.shouldDepositItem(this.entity.func_184614_ca())) {
            return false;
        }
        if (this.entity.func_184586_b(EnumHand.MAIN_HAND).func_190926_b()) {
            return false;
        }
        this.resetTarget();
        return this.targetBlock != null;
    }

    private void resetTarget() {
        this.targetBlock = this.entity.depositPos;
    }

    public boolean func_75253_b() {
        return this.targetBlock != null && !this.entity.func_184586_b(EnumHand.MAIN_HAND).func_190926_b() && this.entity.shouldDepositItem(this.entity.func_184614_ca());
    }

    public void func_75251_c() {
        this.entity.func_70661_as().func_75499_g();
        this.resetTarget();
    }

    public boolean canSeeChest() {
        RayTraceResult rayTrace = RatUtils.rayTraceBlocksIgnoreRatholes(this.entity.field_70170_p, this.entity.func_174791_d(), new Vec3d((double)this.targetBlock.func_177958_n() + 0.5, (double)this.targetBlock.func_177956_o() + 0.5, (double)this.targetBlock.func_177952_p() + 0.5), false);
        if (rayTrace != null && rayTrace.field_72307_f != null) {
            BlockPos sidePos = rayTrace.func_178782_a();
            BlockPos pos = new BlockPos(rayTrace.field_72307_f);
            return this.entity.field_70170_p.func_175623_d(sidePos) || this.entity.field_70170_p.func_175623_d(pos) || this.entity.field_70170_p.func_175625_s(pos) == this.entity.field_70170_p.func_175625_s(this.targetBlock);
        }
        return true;
    }

    private BlockPos getMovePos() {
        return this.targetBlock.func_177972_a(this.entity.depositFacing);
    }

    public void func_75246_d() {
        if (this.targetBlock != null && this.entity.field_70170_p.func_175625_s(this.targetBlock) != null) {
            TileEntity te = this.entity.field_70170_p.func_175625_s(this.targetBlock);
            if (this.entity.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_MINER) && !this.entity.func_70605_aq().func_75640_a() && this.entity.field_70122_E && !this.entity.func_70661_as().func_75492_a((double)this.getMovePos().func_177958_n() + 0.5, (double)this.getMovePos().func_177956_o(), (double)this.getMovePos().func_177952_p() + 0.5, 1.0)) {
                BlockPos rayPos = this.entity.rayTraceBlockPos(this.targetBlock.func_177984_a());
                if (rayPos != null && !rayPos.equals((Object)this.targetBlock)) {
                    IBlockState block = this.entity.field_70170_p.func_180495_p(rayPos);
                    if (RatUtils.canRatBreakBlock(this.entity.field_70170_p, rayPos, this.entity) && block.func_185904_a().func_76230_c() && block.func_185904_a() != Material.field_151579_a) {
                        double distance = this.entity.func_70011_f(rayPos.func_177958_n(), rayPos.func_177956_o(), rayPos.func_177952_p());
                        SoundType soundType = block.func_177230_c().getSoundType(block, this.entity.field_70170_p, rayPos, null);
                        if (distance < 2.5) {
                            this.entity.field_70170_p.func_72960_a((Entity)this.entity, (byte)85);
                            this.entity.crafting = true;
                            if (distance < (double)0.6f) {
                                this.entity.field_70179_y *= 0.0;
                                this.entity.field_70159_w *= 0.0;
                                this.entity.func_70661_as().func_75499_g();
                                this.entity.func_70605_aq().field_188491_h = EntityMoveHelper.Action.WAIT;
                            }
                            ++this.breakingTime;
                            int hardness = (int)(block.func_185887_b(this.entity.field_70170_p, rayPos) * 100.0f);
                            int i = (int)((float)this.breakingTime / (float)hardness * 10.0f);
                            if (this.breakingTime % 10 == 0) {
                                this.entity.func_184185_a(soundType.func_185846_f(), soundType.field_185860_m, soundType.field_185861_n);
                                this.entity.func_184185_a(SoundEvents.field_187730_dW, 1.0f, 0.5f);
                            }
                            if (i != this.previousBreakProgress) {
                                this.entity.field_70170_p.func_175715_c(this.entity.func_145782_y(), rayPos, i);
                                this.previousBreakProgress = i;
                            }
                            if (this.breakingTime == hardness) {
                                this.entity.field_70170_p.func_72960_a((Entity)this.entity, (byte)86);
                                this.entity.func_184185_a(SoundEvents.field_187638_cR, 1.0f, 1.0f);
                                this.entity.func_184185_a(soundType.func_185845_c(), soundType.field_185860_m, soundType.field_185861_n);
                                this.breakingTime = 0;
                                this.previousBreakProgress = -1;
                                this.destroyBlock(rayPos, block);
                                this.entity.fleePos = rayPos;
                                this.targetBlock = null;
                                this.entity.crafting = false;
                                this.func_75251_c();
                            }
                        }
                    }
                }
            } else {
                this.entity.func_70661_as().func_75492_a((double)this.getMovePos().func_177958_n() + 0.5, (double)this.getMovePos().func_177956_o(), (double)this.getMovePos().func_177952_p() + 0.5, 1.0);
                double distance = this.entity.func_70011_f((double)this.targetBlock.func_177958_n() + 0.5, this.targetBlock.func_177956_o() + 1, (double)this.targetBlock.func_177952_p() + 0.5);
                if (distance < 2.5 && distance >= 1.86 && this.canSeeChest() && te instanceof IInventory) {
                    this.toggleChest((IInventory)te, true);
                }
                if (distance < 1.86 && this.canSeeChest()) {
                    ItemStack duplicate;
                    IItemHandler handler;
                    if (te instanceof IInventory) {
                        this.toggleChest((IInventory)te, false);
                    }
                    if (ItemHandlerHelper.insertItem((IItemHandler)(handler = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.entity.depositFacing)), (ItemStack)(duplicate = this.entity.func_184586_b(EnumHand.MAIN_HAND).func_77946_l()), (boolean)true).func_190926_b()) {
                        ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)duplicate, (boolean)false);
                        this.entity.func_184611_a(EnumHand.MAIN_HAND, ItemStack.field_190927_a);
                        this.targetBlock = null;
                        this.func_75251_c();
                    }
                }
            }
        }
    }

    private void destroyBlock(BlockPos pos, IBlockState state) {
        NonNullList drops = NonNullList.func_191196_a();
        state.func_177230_c().getDrops(drops, (IBlockAccess)this.entity.field_70170_p, pos, state, 0);
        if (!drops.isEmpty() && this.entity.canRatPickupItem((ItemStack)drops.get(0))) {
            for (ItemStack drop : drops) {
                this.entity.func_70099_a(drop, 0.0f);
            }
            this.entity.field_70170_p.func_175655_b(pos, false);
            this.entity.fleePos = pos;
        }
    }

    public void toggleChest(IInventory te, boolean open) {
        if (te instanceof TileEntityChest) {
            TileEntityChest chest = (TileEntityChest)te;
            if (open) {
                ++chest.field_145987_o;
                this.entity.field_70170_p.func_175641_c(this.targetBlock, chest.func_145838_q(), 1, chest.field_145987_o);
            } else if (chest.field_145987_o > 0) {
                chest.field_145987_o = 0;
                this.entity.field_70170_p.func_175641_c(this.targetBlock, chest.func_145838_q(), 1, chest.field_145987_o);
            }
        }
    }

    public class BlockSorter
    implements Comparator<BlockPos> {
        private final Entity entity;

        public BlockSorter(Entity entity) {
            this.entity = entity;
        }

        @Override
        public int compare(BlockPos pos1, BlockPos pos2) {
            double distance1 = this.getDistance(pos1);
            double distance2 = this.getDistance(pos2);
            return Double.compare(distance1, distance2);
        }

        private double getDistance(BlockPos pos) {
            double deltaX = this.entity.field_70165_t - ((double)pos.func_177958_n() + 0.5);
            double deltaY = this.entity.field_70163_u + (double)this.entity.func_70047_e() - ((double)pos.func_177956_o() + 0.5);
            double deltaZ = this.entity.field_70161_v - ((double)pos.func_177952_p() + 0.5);
            return deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ;
        }
    }
}

