/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity;

import com.github.alexthe666.rats.RatsMod;
import com.github.alexthe666.rats.server.blocks.BlockRatTube;
import com.github.alexthe666.rats.server.blocks.RatsBlockRegistry;
import com.github.alexthe666.rats.server.entity.EntityRat;
import com.github.alexthe666.rats.server.entity.RatCommand;
import com.github.alexthe666.rats.server.entity.tile.TileEntityRatTube;
import com.github.alexthe666.rats.server.items.RatsItemRegistry;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemSeeds;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.oredict.OreDictionary;

public class RatUtils {
    public static boolean isRatFood(ItemStack stack) {
        return (stack.func_77973_b() instanceof ItemFood || RatUtils.isSeeds(stack) || stack.func_77973_b() == Items.field_151015_O) && stack.func_77973_b() != RatsItemRegistry.RAW_RAT && stack.func_77973_b() != RatsItemRegistry.COOKED_RAT;
    }

    public static boolean shouldRaidItem(ItemStack stack) {
        return RatUtils.isRatFood(stack) && stack.func_77973_b() != RatsItemRegistry.CONTAMINATED_FOOD;
    }

    public static boolean isSeeds(ItemStack stack) {
        Item item = stack.func_77973_b();
        if (item instanceof ItemSeeds && item != Items.field_151075_bm) {
            return true;
        }
        NonNullList listAllseed = OreDictionary.getOres((String)"listAllseed");
        NonNullList listAllSeeds = OreDictionary.getOres((String)"listAllSeeds");
        NonNullList seed = OreDictionary.getOres((String)"seed");
        NonNullList seeds = OreDictionary.getOres((String)"seeds");
        return listAllseed.contains((Object)stack) || listAllSeeds.contains((Object)stack) || seed.contains((Object)stack) || seeds.contains((Object)stack);
    }

    public static boolean doesContainFood(IInventory inventory) {
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            if (!RatUtils.isRatFood(inventory.func_70301_a(i))) continue;
            return true;
        }
        return false;
    }

    public static ItemStack getFoodFromInventory(EntityRat rat, IInventory inventory, Random random) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            if (!RatUtils.shouldRaidItem(stack) || !rat.canRatPickupItem(stack)) continue;
            items.add(stack);
        }
        if (items.isEmpty()) {
            return ItemStack.field_190927_a;
        }
        if (items.size() == 1) {
            return (ItemStack)items.get(0);
        }
        return (ItemStack)items.get(random.nextInt(items.size() - 1));
    }

    public static int getContaminatedSlot(EntityRat rat, IInventory inventory, Random random) {
        ArrayList<Integer> items = new ArrayList<Integer>();
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            if (!stack.func_190926_b() && stack.func_77973_b() != RatsItemRegistry.CONTAMINATED_FOOD) continue;
            items.add(i);
        }
        if (items.isEmpty()) {
            return -1;
        }
        if (items.size() == 1) {
            return (Integer)items.get(0);
        }
        return (Integer)items.get(random.nextInt(items.size() - 1));
    }

    public static int getItemSlotFromItemHandler(EntityRat rat, IItemHandler handler, Random random) {
        ArrayList<Integer> items = new ArrayList<Integer>();
        if (handler == null) {
            return -1;
        }
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack stack = handler.extractItem(i, handler.getSlotLimit(i), true);
            if (!rat.canRatPickupItem(stack)) continue;
            items.add(i);
        }
        if (items.isEmpty()) {
            return -1;
        }
        if (items.size() == 1) {
            return (Integer)items.get(0);
        }
        return (Integer)items.get(random.nextInt(items.size()));
    }

    public static boolean isItemHandlerFull(IItemHandler handler, ItemStack mergeStack) {
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack itemstack = handler.getStackInSlot(i);
            if (!itemstack.func_190926_b() && (mergeStack == null || mergeStack.func_190926_b() || !itemstack.func_77969_a(mergeStack) || itemstack.func_190916_E() + mergeStack.func_190916_E() >= itemstack.func_77976_d())) continue;
            return true;
        }
        return false;
    }

    public static boolean isRatHoleInBoundingBox(AxisAlignedBB bb, World world) {
        int j2 = MathHelper.func_76128_c((double)bb.field_72340_a);
        int k2 = MathHelper.func_76143_f((double)bb.field_72336_d);
        int l2 = MathHelper.func_76128_c((double)bb.field_72338_b);
        int i3 = MathHelper.func_76143_f((double)bb.field_72337_e);
        int j3 = MathHelper.func_76128_c((double)bb.field_72339_c);
        int k3 = MathHelper.func_76143_f((double)bb.field_72334_f);
        BlockPos.PooledMutableBlockPos blockpos$pooledmutableblockpos = BlockPos.PooledMutableBlockPos.func_185346_s();
        for (int l3 = j2; l3 < k2; ++l3) {
            for (int i4 = l2; i4 < i3; ++i4) {
                for (int j4 = j3; j4 < k3; ++j4) {
                    IBlockState iblockstate1 = world.func_180495_p((BlockPos)blockpos$pooledmutableblockpos.func_181079_c(l3, i4, j4));
                    if (iblockstate1.func_177230_c() != RatsBlockRegistry.RAT_HOLE && iblockstate1.func_177230_c() != RatsBlockRegistry.RAT_CAGE) continue;
                    blockpos$pooledmutableblockpos.func_185344_t();
                    return true;
                }
            }
        }
        blockpos$pooledmutableblockpos.func_185344_t();
        return false;
    }

    @Nullable
    public static RayTraceResult rayTraceBlocksIgnoreRatholes(World world, Vec3d start, Vec3d end, boolean stopOnLiquid) {
        return RatUtils.rayTraceBlocksIgnoreRatholes(world, start, end, stopOnLiquid, false, true);
    }

    @Nullable
    public static RayTraceResult rayTraceBlocksIgnoreRatholes(World world, Vec3d vec31, Vec3d vec32, boolean stopOnLiquid, boolean ignoreBlockWithoutBoundingBox, boolean returnLastUncollidableBlock) {
        if (!(Double.isNaN(vec31.field_72450_a) || Double.isNaN(vec31.field_72448_b) || Double.isNaN(vec31.field_72449_c))) {
            if (!(Double.isNaN(vec32.field_72450_a) || Double.isNaN(vec32.field_72448_b) || Double.isNaN(vec32.field_72449_c))) {
                RayTraceResult raytraceresult;
                int i = MathHelper.func_76128_c((double)vec32.field_72450_a);
                int j = MathHelper.func_76128_c((double)vec32.field_72448_b);
                int k = MathHelper.func_76128_c((double)vec32.field_72449_c);
                int l = MathHelper.func_76128_c((double)vec31.field_72450_a);
                int i1 = MathHelper.func_76128_c((double)vec31.field_72448_b);
                int j1 = MathHelper.func_76128_c((double)vec31.field_72449_c);
                BlockPos blockpos = new BlockPos(l, i1, j1);
                IBlockState iblockstate = world.func_180495_p(blockpos);
                Block block = iblockstate.func_177230_c();
                if ((!ignoreBlockWithoutBoundingBox || iblockstate.func_185890_d((IBlockAccess)world, blockpos) != Block.field_185506_k) && block.func_176209_a(iblockstate, stopOnLiquid) && block != RatsBlockRegistry.RAT_HOLE && block != RatsBlockRegistry.RAT_CAGE && (raytraceresult = iblockstate.func_185910_a(world, blockpos, vec31, vec32)) != null) {
                    return raytraceresult;
                }
                RayTraceResult raytraceresult2 = null;
                int k1 = 200;
                while (k1-- >= 0) {
                    EnumFacing enumfacing;
                    if (Double.isNaN(vec31.field_72450_a) || Double.isNaN(vec31.field_72448_b) || Double.isNaN(vec31.field_72449_c)) {
                        return null;
                    }
                    if (l == i && i1 == j && j1 == k) {
                        return returnLastUncollidableBlock ? raytraceresult2 : null;
                    }
                    boolean flag2 = true;
                    boolean flag = true;
                    boolean flag1 = true;
                    double d0 = 999.0;
                    double d1 = 999.0;
                    double d2 = 999.0;
                    if (i > l) {
                        d0 = (double)l + 1.0;
                    } else if (i < l) {
                        d0 = (double)l + 0.0;
                    } else {
                        flag2 = false;
                    }
                    if (j > i1) {
                        d1 = (double)i1 + 1.0;
                    } else if (j < i1) {
                        d1 = (double)i1 + 0.0;
                    } else {
                        flag = false;
                    }
                    if (k > j1) {
                        d2 = (double)j1 + 1.0;
                    } else if (k < j1) {
                        d2 = (double)j1 + 0.0;
                    } else {
                        flag1 = false;
                    }
                    double d3 = 999.0;
                    double d4 = 999.0;
                    double d5 = 999.0;
                    double d6 = vec32.field_72450_a - vec31.field_72450_a;
                    double d7 = vec32.field_72448_b - vec31.field_72448_b;
                    double d8 = vec32.field_72449_c - vec31.field_72449_c;
                    if (flag2) {
                        d3 = (d0 - vec31.field_72450_a) / d6;
                    }
                    if (flag) {
                        d4 = (d1 - vec31.field_72448_b) / d7;
                    }
                    if (flag1) {
                        d5 = (d2 - vec31.field_72449_c) / d8;
                    }
                    if (d3 == -0.0) {
                        d3 = -1.0E-4;
                    }
                    if (d4 == -0.0) {
                        d4 = -1.0E-4;
                    }
                    if (d5 == -0.0) {
                        d5 = -1.0E-4;
                    }
                    if (d3 < d4 && d3 < d5) {
                        enumfacing = i > l ? EnumFacing.WEST : EnumFacing.EAST;
                        vec31 = new Vec3d(d0, vec31.field_72448_b + d7 * d3, vec31.field_72449_c + d8 * d3);
                    } else if (d4 < d5) {
                        enumfacing = j > i1 ? EnumFacing.DOWN : EnumFacing.UP;
                        vec31 = new Vec3d(vec31.field_72450_a + d6 * d4, d1, vec31.field_72449_c + d8 * d4);
                    } else {
                        enumfacing = k > j1 ? EnumFacing.NORTH : EnumFacing.SOUTH;
                        vec31 = new Vec3d(vec31.field_72450_a + d6 * d5, vec31.field_72448_b + d7 * d5, d2);
                    }
                    l = MathHelper.func_76128_c((double)vec31.field_72450_a) - (enumfacing == EnumFacing.EAST ? 1 : 0);
                    i1 = MathHelper.func_76128_c((double)vec31.field_72448_b) - (enumfacing == EnumFacing.UP ? 1 : 0);
                    j1 = MathHelper.func_76128_c((double)vec31.field_72449_c) - (enumfacing == EnumFacing.SOUTH ? 1 : 0);
                    blockpos = new BlockPos(l, i1, j1);
                    IBlockState iblockstate1 = world.func_180495_p(blockpos);
                    Block block1 = iblockstate1.func_177230_c();
                    if (ignoreBlockWithoutBoundingBox && iblockstate1.func_185904_a() != Material.field_151567_E && iblockstate1.func_185890_d((IBlockAccess)world, blockpos) == Block.field_185506_k || block1 == RatsBlockRegistry.RAT_HOLE || block1 == RatsBlockRegistry.RAT_CAGE) continue;
                    if (block1.func_176209_a(iblockstate1, stopOnLiquid)) {
                        RayTraceResult raytraceresult1 = iblockstate1.func_185910_a(world, blockpos, vec31, vec32);
                        if (raytraceresult1 == null) continue;
                        return raytraceresult1;
                    }
                    raytraceresult2 = new RayTraceResult(RayTraceResult.Type.MISS, vec31, enumfacing, blockpos);
                }
                return returnLastUncollidableBlock ? raytraceresult2 : null;
            }
            return null;
        }
        return null;
    }

    @Nullable
    public static RayTraceResult rayTraceBlocksIgnoreOurRattube(World world, Vec3d vec31, Vec3d vec32, boolean stopOnLiquid, boolean ignoreBlockWithoutBoundingBox, boolean returnLastUncollidableBlock) {
        if (!(Double.isNaN(vec31.field_72450_a) || Double.isNaN(vec31.field_72448_b) || Double.isNaN(vec31.field_72449_c))) {
            if (!(Double.isNaN(vec32.field_72450_a) || Double.isNaN(vec32.field_72448_b) || Double.isNaN(vec32.field_72449_c))) {
                RayTraceResult raytraceresult;
                int i = MathHelper.func_76128_c((double)vec32.field_72450_a);
                int j = MathHelper.func_76128_c((double)vec32.field_72448_b);
                int k = MathHelper.func_76128_c((double)vec32.field_72449_c);
                int l = MathHelper.func_76128_c((double)vec31.field_72450_a);
                int i1 = MathHelper.func_76128_c((double)vec31.field_72448_b);
                int j1 = MathHelper.func_76128_c((double)vec31.field_72449_c);
                BlockPos blockpos = new BlockPos(l, i1, j1);
                IBlockState iblockstate = world.func_180495_p(blockpos);
                Block block = iblockstate.func_177230_c();
                if (!(ignoreBlockWithoutBoundingBox && iblockstate.func_185890_d((IBlockAccess)world, blockpos) == Block.field_185506_k || !block.func_176209_a(iblockstate, stopOnLiquid) || block instanceof BlockRatTube || (raytraceresult = iblockstate.func_185910_a(world, blockpos, vec31, vec32)) == null)) {
                    return raytraceresult;
                }
                RayTraceResult raytraceresult2 = null;
                int k1 = 200;
                while (k1-- >= 0) {
                    EnumFacing enumfacing;
                    if (Double.isNaN(vec31.field_72450_a) || Double.isNaN(vec31.field_72448_b) || Double.isNaN(vec31.field_72449_c)) {
                        return null;
                    }
                    if (l == i && i1 == j && j1 == k) {
                        return returnLastUncollidableBlock ? raytraceresult2 : null;
                    }
                    boolean flag2 = true;
                    boolean flag = true;
                    boolean flag1 = true;
                    double d0 = 999.0;
                    double d1 = 999.0;
                    double d2 = 999.0;
                    if (i > l) {
                        d0 = (double)l + 1.0;
                    } else if (i < l) {
                        d0 = (double)l + 0.0;
                    } else {
                        flag2 = false;
                    }
                    if (j > i1) {
                        d1 = (double)i1 + 1.0;
                    } else if (j < i1) {
                        d1 = (double)i1 + 0.0;
                    } else {
                        flag = false;
                    }
                    if (k > j1) {
                        d2 = (double)j1 + 1.0;
                    } else if (k < j1) {
                        d2 = (double)j1 + 0.0;
                    } else {
                        flag1 = false;
                    }
                    double d3 = 999.0;
                    double d4 = 999.0;
                    double d5 = 999.0;
                    double d6 = vec32.field_72450_a - vec31.field_72450_a;
                    double d7 = vec32.field_72448_b - vec31.field_72448_b;
                    double d8 = vec32.field_72449_c - vec31.field_72449_c;
                    if (flag2) {
                        d3 = (d0 - vec31.field_72450_a) / d6;
                    }
                    if (flag) {
                        d4 = (d1 - vec31.field_72448_b) / d7;
                    }
                    if (flag1) {
                        d5 = (d2 - vec31.field_72449_c) / d8;
                    }
                    if (d3 == -0.0) {
                        d3 = -1.0E-4;
                    }
                    if (d4 == -0.0) {
                        d4 = -1.0E-4;
                    }
                    if (d5 == -0.0) {
                        d5 = -1.0E-4;
                    }
                    if (d3 < d4 && d3 < d5) {
                        enumfacing = i > l ? EnumFacing.WEST : EnumFacing.EAST;
                        vec31 = new Vec3d(d0, vec31.field_72448_b + d7 * d3, vec31.field_72449_c + d8 * d3);
                    } else if (d4 < d5) {
                        enumfacing = j > i1 ? EnumFacing.DOWN : EnumFacing.UP;
                        vec31 = new Vec3d(vec31.field_72450_a + d6 * d4, d1, vec31.field_72449_c + d8 * d4);
                    } else {
                        enumfacing = k > j1 ? EnumFacing.NORTH : EnumFacing.SOUTH;
                        vec31 = new Vec3d(vec31.field_72450_a + d6 * d5, vec31.field_72448_b + d7 * d5, d2);
                    }
                    l = MathHelper.func_76128_c((double)vec31.field_72450_a) - (enumfacing == EnumFacing.EAST ? 1 : 0);
                    i1 = MathHelper.func_76128_c((double)vec31.field_72448_b) - (enumfacing == EnumFacing.UP ? 1 : 0);
                    j1 = MathHelper.func_76128_c((double)vec31.field_72449_c) - (enumfacing == EnumFacing.SOUTH ? 1 : 0);
                    blockpos = new BlockPos(l, i1, j1);
                    IBlockState iblockstate1 = world.func_180495_p(blockpos);
                    Block block1 = iblockstate1.func_177230_c();
                    if (ignoreBlockWithoutBoundingBox && iblockstate1.func_185904_a() != Material.field_151567_E && iblockstate1.func_185890_d((IBlockAccess)world, blockpos) == Block.field_185506_k) continue;
                    if (block1.func_176209_a(iblockstate1, stopOnLiquid)) {
                        RayTraceResult raytraceresult1 = iblockstate1.func_185910_a(world, blockpos, vec31, vec32);
                        if (raytraceresult1 == null) continue;
                        return raytraceresult1;
                    }
                    raytraceresult2 = new RayTraceResult(RayTraceResult.Type.MISS, vec31, enumfacing, blockpos);
                }
                return returnLastUncollidableBlock ? raytraceresult2 : null;
            }
            return null;
        }
        return null;
    }

    public static boolean isPredator(Entity entity) {
        return entity instanceof EntityOcelot;
    }

    public static RatCommand wrapCommand(int newCommand) {
        int length = RatCommand.values().length;
        if (newCommand >= length) {
            newCommand = 0;
        }
        if (newCommand < 0) {
            newCommand = length - 1;
        }
        return RatCommand.values()[newCommand];
    }

    public static boolean isCheese(ItemStack cheese) {
        return cheese.func_77973_b() == RatsItemRegistry.CHEESE || OreDictionary.getOres((String)"foodCheese", (boolean)false).contains((Object)cheese);
    }

    @Nullable
    public static Vec3d findRandomCageOrTubeTarget(EntityRat rat, int xz, int y) {
        return RatUtils.generateRandomCageOrTubePos(rat, xz, y, null, false);
    }

    @Nullable
    public static Vec3d generateRandomCageOrTubePos(EntityRat rat, int searchWidth, int searchHeight, @Nullable Vec3d positionVector, boolean water) {
        double d1;
        double d0;
        PathNavigate pathnavigate = rat.func_70661_as();
        Random random = rat.func_70681_au();
        boolean flag = rat.func_110175_bO() ? (d0 = rat.func_180486_cf().func_177954_c((double)MathHelper.func_76128_c((double)rat.field_70165_t), (double)MathHelper.func_76128_c((double)rat.field_70163_u), (double)MathHelper.func_76128_c((double)rat.field_70161_v)) + 4.0) < (d1 = (double)(rat.func_110174_bM() + (float)searchWidth)) * d1 : false;
        boolean flag1 = false;
        float f = -99999.0f;
        int k1 = 0;
        int i = 0;
        int j = 0;
        for (int k = 0; k < 10; ++k) {
            float f1;
            int l = random.nextInt(2 * searchWidth + 1) - searchWidth;
            int i1 = random.nextInt(2 * searchHeight + 1) - searchHeight;
            int j1 = random.nextInt(2 * searchWidth + 1) - searchWidth;
            if (positionVector != null && !((double)l * positionVector.field_72450_a + (double)j1 * positionVector.field_72449_c >= 0.0)) continue;
            if (rat.func_110175_bO() && searchWidth > 1) {
                BlockPos blockpos = rat.func_180486_cf();
                l = rat.field_70165_t > (double)blockpos.func_177958_n() ? (l -= random.nextInt(searchWidth / 2)) : (l += random.nextInt(searchWidth / 2));
                j1 = rat.field_70161_v > (double)blockpos.func_177952_p() ? (j1 -= random.nextInt(searchWidth / 2)) : (j1 += random.nextInt(searchWidth / 2));
            }
            BlockPos blockpos1 = new BlockPos((double)l + rat.field_70165_t, (double)i1 + rat.field_70163_u, (double)j1 + rat.field_70161_v);
            if (flag && !rat.func_180485_d(blockpos1) || rat.field_70170_p.func_180495_p(blockpos1).func_177230_c() != RatsBlockRegistry.RAT_CAGE && !(rat.field_70170_p.func_180495_p(blockpos1).func_177230_c() instanceof BlockRatTube) || !((f1 = rat.func_180484_a(blockpos1 = RatUtils.findLowestRatCage(blockpos1, (EntityCreature)rat))) > f)) continue;
            f = f1;
            k1 = l;
            i = i1;
            j = j1;
            flag1 = true;
        }
        if (flag1) {
            return new Vec3d((double)k1 + rat.field_70165_t, (double)i + rat.field_70163_u, (double)j + rat.field_70161_v);
        }
        return null;
    }

    @Nullable
    public static Vec3d generateRandomCagePos(EntityRat rat, int searchWidth, int searchHeight, @Nullable Vec3d positionVector, boolean water) {
        double d1;
        double d0;
        PathNavigate pathnavigate = rat.func_70661_as();
        Random random = rat.func_70681_au();
        boolean flag = rat.func_110175_bO() ? (d0 = rat.func_180486_cf().func_177954_c((double)MathHelper.func_76128_c((double)rat.field_70165_t), (double)MathHelper.func_76128_c((double)rat.field_70163_u), (double)MathHelper.func_76128_c((double)rat.field_70161_v)) + 4.0) < (d1 = (double)(rat.func_110174_bM() + (float)searchWidth)) * d1 : false;
        boolean flag1 = false;
        float f = -99999.0f;
        int k1 = 0;
        int i = 0;
        int j = 0;
        for (int k = 0; k < 10; ++k) {
            float f1;
            int l = random.nextInt(2 * searchWidth + 1) - searchWidth;
            int i1 = random.nextInt(2 * searchHeight + 1) - searchHeight;
            int j1 = random.nextInt(2 * searchWidth + 1) - searchWidth;
            if (positionVector != null && !((double)l * positionVector.field_72450_a + (double)j1 * positionVector.field_72449_c >= 0.0)) continue;
            if (rat.func_110175_bO() && searchWidth > 1) {
                BlockPos blockpos = rat.func_180486_cf();
                l = rat.field_70165_t > (double)blockpos.func_177958_n() ? (l -= random.nextInt(searchWidth / 2)) : (l += random.nextInt(searchWidth / 2));
                j1 = rat.field_70161_v > (double)blockpos.func_177952_p() ? (j1 -= random.nextInt(searchWidth / 2)) : (j1 += random.nextInt(searchWidth / 2));
            }
            BlockPos blockpos1 = new BlockPos((double)l + rat.field_70165_t, (double)i1 + rat.field_70163_u, (double)j1 + rat.field_70161_v);
            if (flag && !rat.func_180485_d(blockpos1) || rat.field_70170_p.func_180495_p(blockpos1).func_177230_c() != RatsBlockRegistry.RAT_CAGE || !((f1 = rat.func_180484_a(blockpos1 = RatUtils.findLowestRatCage(blockpos1, (EntityCreature)rat))) > f)) continue;
            f = f1;
            k1 = l;
            i = i1;
            j = j1;
            flag1 = true;
        }
        if (flag1) {
            return new Vec3d((double)k1 + rat.field_70165_t, (double)i + rat.field_70163_u, (double)j + rat.field_70161_v);
        }
        return null;
    }

    @Nullable
    public static Vec3d generateRandomTubePos(EntityRat rat, int searchWidth, int searchHeight, @Nullable Vec3d positionVector, boolean water) {
        double d1;
        double d0;
        PathNavigate pathnavigate = rat.func_70661_as();
        Random random = rat.func_70681_au();
        boolean flag = rat.func_110175_bO() ? (d0 = rat.func_180486_cf().func_177954_c((double)MathHelper.func_76128_c((double)rat.field_70165_t), (double)MathHelper.func_76128_c((double)rat.field_70163_u), (double)MathHelper.func_76128_c((double)rat.field_70161_v)) + 4.0) < (d1 = (double)(rat.func_110174_bM() + (float)searchWidth)) * d1 : false;
        boolean flag1 = false;
        float f = -99999.0f;
        int k1 = 0;
        int i = 0;
        int j = 0;
        for (int k = 0; k < 10; ++k) {
            float f1;
            int l = random.nextInt(2 * searchWidth + 1) - searchWidth;
            int i1 = random.nextInt(2 * searchHeight + 1) - searchHeight;
            int j1 = random.nextInt(2 * searchWidth + 1) - searchWidth;
            if (positionVector != null && !((double)l * positionVector.field_72450_a + (double)j1 * positionVector.field_72449_c >= 0.0)) continue;
            if (rat.func_110175_bO() && searchWidth > 1) {
                BlockPos blockpos = rat.func_180486_cf();
                l = rat.field_70165_t > (double)blockpos.func_177958_n() ? (l -= random.nextInt(searchWidth / 2)) : (l += random.nextInt(searchWidth / 2));
                j1 = rat.field_70161_v > (double)blockpos.func_177952_p() ? (j1 -= random.nextInt(searchWidth / 2)) : (j1 += random.nextInt(searchWidth / 2));
            }
            BlockPos blockpos1 = new BlockPos((double)l + rat.field_70165_t, (double)i1 + rat.field_70163_u, (double)j1 + rat.field_70161_v);
            if (flag && !rat.func_180485_d(blockpos1) || !(rat.field_70170_p.func_180495_p(blockpos1).func_177230_c() instanceof BlockRatTube) || !((f1 = rat.func_180484_a(blockpos1 = RatUtils.findLowestRatCage(blockpos1, (EntityCreature)rat))) > f)) continue;
            f = f1;
            k1 = l;
            i = i1;
            j = j1;
            flag1 = true;
        }
        if (flag1) {
            return new Vec3d((double)k1 + rat.field_70165_t, (double)i + rat.field_70163_u, (double)j + rat.field_70161_v);
        }
        return null;
    }

    public static BlockPos findLowestRatCage(BlockPos pos, EntityCreature rat) {
        if (rat.field_70170_p.func_180495_p(pos.func_177977_b()).func_177230_c() != RatsBlockRegistry.RAT_CAGE && !(rat.field_70170_p.func_180495_p(pos.func_177977_b()).func_177230_c() instanceof BlockRatTube)) {
            return pos;
        }
        BlockPos blockpos = pos.func_177977_b();
        while (blockpos.func_177956_o() > 0 && rat.field_70170_p.func_180495_p(blockpos).func_177230_c() != RatsBlockRegistry.RAT_CAGE && !(rat.field_70170_p.func_180495_p(blockpos).func_177230_c() instanceof BlockRatTube)) {
            blockpos = blockpos.func_177977_b();
        }
        return blockpos;
    }

    public static BlockPos findLowestWater(BlockPos pos, EntityCreature rat) {
        if (rat.field_70170_p.func_180495_p(pos).func_185904_a() == Material.field_151586_h) {
            return pos;
        }
        BlockPos blockpos = pos.func_177977_b();
        while (blockpos.func_177956_o() > 0 && rat.field_70170_p.func_180495_p(blockpos).func_185904_a() != Material.field_151586_h) {
            blockpos = blockpos.func_177977_b();
        }
        return blockpos;
    }

    public static boolean canRatBreakBlock(World world, BlockPos pos, EntityRat rat) {
        IBlockState blockState = world.func_180495_p(pos);
        float hardness = blockState.func_185887_b(world, pos);
        return hardness != -1.0f && hardness <= RatsMod.CONFIG_OPTIONS.ratStrengthThreshold && blockState.func_177230_c().canEntityDestroy(blockState, (IBlockAccess)world, pos, (Entity)rat) && EntityWither.func_181033_a((Block)blockState.func_177230_c());
    }

    public static boolean isRatTube(IBlockAccess world, BlockPos offset) {
        return world.func_175625_s(offset) instanceof TileEntityRatTube;
    }

    public static boolean isConnectedToRatTube(IBlockAccess world, BlockPos pos) {
        if (world.func_175623_d(pos)) {
            for (EnumFacing facing : EnumFacing.values()) {
                if (!RatUtils.isRatTube(world, pos.func_177972_a(facing))) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isOpenRatTube(IBlockAccess world, EntityRat rat, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() instanceof BlockRatTube) {
            for (int i = 0; i < EnumFacing.values().length; ++i) {
                PropertyBool bool = BlockRatTube.ALL_OPEN_PROPS[i];
                if (!((Boolean)state.func_177229_b((IProperty)bool)).booleanValue() || rat == null) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isLinkedToTube(IBlockAccess world, BlockPos offset) {
        return RatUtils.isRatTube(world, offset) || RatUtils.isConnectedToRatTube(world, offset);
    }

    public static BlockPos offsetTubeEntrance(IBlockAccess worldIn, BlockPos pos) {
        IBlockState state = worldIn.func_180495_p(pos);
        if (state.func_177230_c() instanceof BlockRatTube) {
            for (int i = 0; i < EnumFacing.values().length; ++i) {
                PropertyBool bool = BlockRatTube.ALL_OPEN_PROPS[i];
                if (!((Boolean)state.func_177229_b((IProperty)bool)).booleanValue()) continue;
                return pos.func_177972_a(EnumFacing.values()[i]);
            }
        }
        return pos;
    }

    public static Vec3d generateRandomWaterPos(EntityCreature p_191379_0_, int p_191379_1_, int p_191379_2_, @Nullable Vec3d p_191379_3_, boolean p_191379_4_) {
        double d1;
        double d0;
        PathNavigate pathnavigate = p_191379_0_.func_70661_as();
        Random random = p_191379_0_.func_70681_au();
        boolean flag = p_191379_0_.func_110175_bO() ? (d0 = p_191379_0_.func_180486_cf().func_177954_c((double)MathHelper.func_76128_c((double)p_191379_0_.field_70165_t), (double)MathHelper.func_76128_c((double)p_191379_0_.field_70163_u), (double)MathHelper.func_76128_c((double)p_191379_0_.field_70161_v)) + 4.0) < (d1 = (double)(p_191379_0_.func_110174_bM() + (float)p_191379_1_)) * d1 : false;
        boolean flag1 = false;
        float f = -99999.0f;
        int k1 = 0;
        int i = 0;
        int j = 0;
        for (int k = 0; k < 10; ++k) {
            float f1;
            int l = random.nextInt(2 * p_191379_1_ + 1) - p_191379_1_;
            int i1 = random.nextInt(2 * p_191379_2_ + 1) - p_191379_2_;
            int j1 = random.nextInt(2 * p_191379_1_ + 1) - p_191379_1_;
            if (p_191379_3_ != null && !((double)l * p_191379_3_.field_72450_a + (double)j1 * p_191379_3_.field_72449_c >= 0.0)) continue;
            if (p_191379_0_.func_110175_bO() && p_191379_1_ > 1) {
                BlockPos blockpos = p_191379_0_.func_180486_cf();
                l = p_191379_0_.field_70165_t > (double)blockpos.func_177958_n() ? (l -= random.nextInt(p_191379_1_ / 2)) : (l += random.nextInt(p_191379_1_ / 2));
                j1 = p_191379_0_.field_70161_v > (double)blockpos.func_177952_p() ? (j1 -= random.nextInt(p_191379_1_ / 2)) : (j1 += random.nextInt(p_191379_1_ / 2));
            }
            BlockPos blockpos1 = new BlockPos((double)l + p_191379_0_.field_70165_t, (double)i1 + p_191379_0_.field_70163_u, (double)j1 + p_191379_0_.field_70161_v);
            if (flag && !p_191379_0_.func_180485_d(blockpos1) || !pathnavigate.func_188555_b(blockpos1) || !p_191379_4_ && RatUtils.isWaterDestination(blockpos1 = RatUtils.moveAboveSolid(blockpos1, p_191379_0_), p_191379_0_) || !((f1 = p_191379_0_.func_180484_a(blockpos1)) > f)) continue;
            f = f1;
            k1 = l;
            i = i1;
            j = j1;
            flag1 = true;
        }
        if (flag1) {
            return new Vec3d((double)k1 + p_191379_0_.field_70165_t, (double)i + p_191379_0_.field_70163_u, (double)j + p_191379_0_.field_70161_v);
        }
        return null;
    }

    private static BlockPos moveAboveSolid(BlockPos p_191378_0_, EntityCreature p_191378_1_) {
        if (!p_191378_1_.field_70170_p.func_180495_p(p_191378_0_).func_185904_a().func_76220_a()) {
            return p_191378_0_;
        }
        BlockPos blockpos = p_191378_0_.func_177984_a();
        while (blockpos.func_177956_o() < p_191378_1_.field_70170_p.func_72800_K() && p_191378_1_.field_70170_p.func_180495_p(blockpos).func_185904_a().func_76220_a()) {
            blockpos = blockpos.func_177984_a();
        }
        return blockpos;
    }

    private static boolean isWaterDestination(BlockPos p_191380_0_, EntityCreature p_191380_1_) {
        return p_191380_1_.field_70170_p.func_180495_p(p_191380_0_).func_185904_a() == Material.field_151586_h;
    }

    public static boolean canSpawnInDimension(World world) {
        if (RatsMod.CONFIG_OPTIONS.blacklistedRatDimensions.length > 0) {
            for (int i = 0; i < RatsMod.CONFIG_OPTIONS.blacklistedRatDimensions.length; ++i) {
                if (RatsMod.CONFIG_OPTIONS.blacklistedRatDimensions[i] != world.field_73011_w.getDimension()) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isCow(Entity entity) {
        String s = EntityList.func_75621_b((Entity)entity);
        if (s == null) {
            s = "generic";
        }
        return entity instanceof EntityCow || s.contains("cow");
    }

    public static class TubeSorter
    implements Comparator<EnumFacing> {
        private final EntityRat theEntity;

        public TubeSorter(EntityRat theEntityIn) {
            this.theEntity = theEntityIn;
        }

        @Override
        public int compare(EnumFacing p_compare_1_, EnumFacing p_compare_2_) {
            double d1;
            BlockPos pos1 = new BlockPos((Entity)this.theEntity).func_177972_a(p_compare_1_);
            BlockPos pos2 = new BlockPos((Entity)this.theEntity).func_177972_a(p_compare_2_);
            double d0 = this.theEntity.tubeTarget.func_185332_f(pos1.func_177958_n(), pos1.func_177956_o(), pos1.func_177952_p());
            return d0 < (d1 = this.theEntity.tubeTarget.func_185332_f(pos2.func_177958_n(), pos2.func_177956_o(), pos2.func_177952_p())) ? -1 : (d0 > d1 ? 1 : 0);
        }
    }
}

