/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity;

import com.github.alexthe666.rats.RatsMod;
import com.github.alexthe666.rats.server.entity.EntityBlackDeath;
import com.github.alexthe666.rats.server.entity.IPlagueLegion;
import com.github.alexthe666.rats.server.entity.ai.BlackDeathAITargetNonPlagued;
import com.github.alexthe666.rats.server.misc.RatsSoundRegistry;
import com.google.common.base.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PreYggdrasilConverter;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class EntityPlagueCloud
extends EntityMob
implements IPlagueLegion {
    protected static final DataParameter<Optional<UUID>> OWNER_UNIQUE_ID = EntityDataManager.func_187226_a(EntityPlagueCloud.class, (DataSerializer)DataSerializers.field_187203_m);

    public EntityPlagueCloud(World worldIn) {
        super(worldIn);
        this.func_70105_a(1.0f, 1.5f);
        this.field_70765_h = new AIMoveControl(this);
    }

    public boolean func_70687_e(PotionEffect potioneffectIn) {
        if (potioneffectIn.func_188419_a() == RatsMod.PLAGUE_POTION) {
            return false;
        }
        return super.func_70687_e(potioneffectIn);
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187945_hs;
    }

    protected SoundEvent func_184615_bR() {
        return RatsSoundRegistry.RATLANTEAN_SPIRIT_DIE;
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.func_189654_d(true);
        double d0 = this.field_70737_aN > 0 ? 1.0 : 0.0;
        double d1 = 0.01;
        double d2 = 0.0;
        double x = this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N;
        double y = this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O) - (double)this.field_70131_O;
        double z = this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N;
        float f = (this.field_70130_N + this.field_70131_O + this.field_70130_N) * 0.333f + 0.5f;
        if (this.particleDistSq(x, y, z) < (double)(f * f)) {
            if (this.field_70146_Z.nextBoolean()) {
                RatsMod.PROXY.spawnParticle("black_death", x, y + 1.5, z, d0, d1, d2);
            } else {
                this.field_70170_p.func_175688_a(EnumParticleTypes.SPELL_MOB, x, y + 1.5, z, d0, d1, d2, new int[0]);
            }
        }
        if (this.getOwnerId() != null && this.getOwner() != null && this.getOwner() instanceof EntityBlackDeath) {
            EntityBlackDeath death = (EntityBlackDeath)this.getOwner();
            if (death.func_70638_az() != null && !death.func_70638_az().field_70128_L) {
                this.func_70624_b(death.func_70638_az());
            } else {
                float radius = 9.0f - (float)Math.sin((double)death.field_70173_aa * 0.4) * 0.25f;
                int maxRatStuff = 360 / Math.max(death.getCloudsSummoned(), 1);
                int ratIndex = this.func_145782_y() % Math.max(death.getCloudsSummoned(), 1);
                float angle = (float)Math.PI / 180 * ((float)(ratIndex * maxRatStuff) + (float)this.field_70173_aa * 4.1f);
                double extraX = (double)(radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)))) + death.field_70165_t;
                double extraZ = (double)(radius * MathHelper.func_76134_b((float)angle)) + death.field_70161_v;
                this.func_70605_aq().func_75642_a(extraX, death.field_70163_u + 2.0 + (double)this.field_70146_Z.nextInt(2), extraZ, 1.0);
            }
        }
        if (this.func_70638_az() != null && this.func_70638_az().field_70128_L) {
            this.func_70624_b(null);
        }
    }

    public void func_70106_y() {
        if (!this.field_70128_L && this.getOwnerId() != null && this.getOwner() != null && this.getOwner() instanceof EntityBlackDeath) {
            EntityBlackDeath illagerPiper = (EntityBlackDeath)this.getOwner();
            illagerPiper.setCloudsSummoned(illagerPiper.getCloudsSummoned() - 1);
        }
        this.field_70128_L = true;
    }

    public double particleDistSq(double toX, double toY, double toZ) {
        double d0 = this.field_70165_t - toX;
        double d1 = this.field_70163_u - toY;
        double d2 = this.field_70161_v - toZ;
        return d0 * d0 + d1 * d1 + d2 * d2;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(OWNER_UNIQUE_ID, (Object)Optional.absent());
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AIMeleeAttack(this));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new AIMoveRandom());
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 3.0f, 1.0f));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityLiving.class, 8.0f));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[]{EntityPlagueCloud.class}));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new BlackDeathAITargetNonPlagued((EntityCreature)this, EntityLivingBase.class, false));
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean flag = super.func_70652_k(entityIn);
        if (flag && entityIn instanceof EntityLivingBase) {
            ((EntityLivingBase)entityIn).func_70690_d(new PotionEffect(RatsMod.PLAGUE_POTION, 600, 0));
        }
        return flag;
    }

    protected void func_184231_a(double y, boolean onGroundIn, IBlockState state, BlockPos pos) {
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        if (this.getOwnerId() == null) {
            compound.func_74778_a("OwnerUUID", "");
        } else {
            compound.func_74778_a("OwnerUUID", this.getOwnerId().toString());
        }
    }

    public void func_70037_a(NBTTagCompound compound) {
        String s;
        super.func_70037_a(compound);
        if (compound.func_150297_b("OwnerUUID", 8)) {
            s = compound.func_74779_i("OwnerUUID");
        } else {
            String s1 = compound.func_74779_i("Owner");
            s = PreYggdrasilConverter.func_187473_a((MinecraftServer)this.func_184102_h(), (String)s1);
        }
        if (!s.isEmpty()) {
            try {
                this.setOwnerId(UUID.fromString(s));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public UUID getOwnerId() {
        return (UUID)((Optional)this.field_70180_af.func_187225_a(OWNER_UNIQUE_ID)).orNull();
    }

    public void setOwnerId(@Nullable UUID p_184754_1_) {
        this.field_70180_af.func_187227_b(OWNER_UNIQUE_ID, (Object)Optional.fromNullable((Object)p_184754_1_));
    }

    public EntityLivingBase getOwner() {
        try {
            Entity entity;
            EntityPlayer player;
            UUID uuid = this.getOwnerId();
            EntityPlayer entityPlayer = player = uuid == null ? null : this.field_70170_p.func_152378_a(uuid);
            if (player != null) {
                return player;
            }
            if (!this.field_70170_p.field_72995_K && (entity = this.field_70170_p.func_73046_m().func_71218_a(this.field_71093_bK).func_175733_a(uuid)) instanceof EntityLivingBase) {
                return (EntityLivingBase)entity;
            }
        }
        catch (IllegalArgumentException var2) {
            return null;
        }
        return null;
    }

    class AIMeleeAttack
    extends EntityAIBase {
        private final EntityPlagueCloud parentEntity;
        public int attackTimer;

        public AIMeleeAttack(EntityPlagueCloud ghast) {
            this.parentEntity = ghast;
        }

        public boolean func_75250_a() {
            return this.parentEntity.func_70638_az() != null;
        }

        public void func_75249_e() {
            this.attackTimer = 0;
        }

        public void func_75251_c() {
        }

        public void func_75246_d() {
            EntityLivingBase entitylivingbase = this.parentEntity.func_70638_az();
            double d0 = 64.0;
            if (entitylivingbase.func_70068_e((Entity)this.parentEntity) >= 2.0 || !this.parentEntity.func_70685_l((Entity)entitylivingbase)) {
                EntityPlagueCloud.this.field_70765_h.func_75642_a(entitylivingbase.field_70165_t, entitylivingbase.field_70163_u + 1.0, entitylivingbase.field_70161_v, 0.5);
            }
            if (entitylivingbase.func_70068_e((Entity)this.parentEntity) < 5.0) {
                World world = this.parentEntity.field_70170_p;
                ++this.attackTimer;
                if (this.attackTimer == 5) {
                    this.parentEntity.func_70652_k((Entity)entitylivingbase);
                    this.attackTimer = -10;
                }
            } else if (this.attackTimer > 0) {
                --this.attackTimer;
            }
        }
    }

    class AIMoveRandom
    extends EntityAIBase {
        public AIMoveRandom() {
            this.func_75248_a(1);
        }

        public boolean func_75250_a() {
            return !EntityPlagueCloud.this.func_70605_aq().func_75640_a() && EntityPlagueCloud.this.field_70146_Z.nextInt(2) == 0;
        }

        public boolean func_75253_b() {
            return false;
        }

        public void func_75246_d() {
            BlockPos blockpos = new BlockPos((Entity)EntityPlagueCloud.this);
            for (int i = 0; i < 3; ++i) {
                BlockPos blockpos1 = blockpos.func_177982_a(EntityPlagueCloud.this.field_70146_Z.nextInt(15) - 7, EntityPlagueCloud.this.field_70146_Z.nextInt(11) - 5, EntityPlagueCloud.this.field_70146_Z.nextInt(15) - 7);
                if (!EntityPlagueCloud.this.field_70170_p.func_175623_d(blockpos1)) continue;
                EntityPlagueCloud.this.field_70765_h.func_75642_a((double)blockpos1.func_177958_n() + 0.5, (double)blockpos1.func_177956_o() + 0.5, (double)blockpos1.func_177952_p() + 0.5, 0.25);
                if (EntityPlagueCloud.this.func_70638_az() != null) break;
                EntityPlagueCloud.this.func_70671_ap().func_75650_a((double)blockpos1.func_177958_n() + 0.5, (double)blockpos1.func_177956_o() + 0.5, (double)blockpos1.func_177952_p() + 0.5, 180.0f, 20.0f);
                break;
            }
        }
    }

    class AIMoveControl
    extends EntityMoveHelper {
        public AIMoveControl(EntityPlagueCloud vex) {
            super((EntityLiving)vex);
        }

        public void func_75641_c() {
            if (this.field_188491_h == EntityMoveHelper.Action.MOVE_TO) {
                double d0 = this.field_75646_b - EntityPlagueCloud.this.field_70165_t;
                double d1 = this.field_75647_c - EntityPlagueCloud.this.field_70163_u;
                double d2 = this.field_75644_d - EntityPlagueCloud.this.field_70161_v;
                double d3 = d0 * d0 + d1 * d1 + d2 * d2;
                if ((d3 = (double)MathHelper.func_76133_a((double)d3)) < EntityPlagueCloud.this.func_174813_aQ().func_72320_b()) {
                    this.field_188491_h = EntityMoveHelper.Action.WAIT;
                    EntityPlagueCloud.this.field_70159_w *= 0.5;
                    EntityPlagueCloud.this.field_70181_x *= 0.5;
                    EntityPlagueCloud.this.field_70179_y *= 0.5;
                } else {
                    EntityPlagueCloud.this.field_70159_w += d0 / d3 * 0.05 * this.field_75645_e;
                    EntityPlagueCloud.this.field_70181_x += d1 / d3 * 0.05 * this.field_75645_e;
                    EntityPlagueCloud.this.field_70179_y += d2 / d3 * 0.05 * this.field_75645_e;
                    if (EntityPlagueCloud.this.func_70638_az() == null) {
                        EntityPlagueCloud.this.field_70761_aq = EntityPlagueCloud.this.field_70177_z = -((float)MathHelper.func_181159_b((double)EntityPlagueCloud.this.field_70159_w, (double)EntityPlagueCloud.this.field_70179_y)) * 57.295776f;
                    } else {
                        double d4 = EntityPlagueCloud.this.func_70638_az().field_70165_t - EntityPlagueCloud.this.field_70165_t;
                        double d5 = EntityPlagueCloud.this.func_70638_az().field_70161_v - EntityPlagueCloud.this.field_70161_v;
                        EntityPlagueCloud.this.field_70761_aq = EntityPlagueCloud.this.field_70177_z = -((float)MathHelper.func_181159_b((double)d4, (double)d5)) * 57.295776f;
                    }
                }
            }
        }
    }
}

