/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity;

import com.github.alexthe666.rats.RatsMod;
import com.github.alexthe666.rats.server.entity.EntityGolemBeam;
import com.github.alexthe666.rats.server.entity.IRatlantean;
import com.github.alexthe666.rats.server.misc.RatsSoundRegistry;
import com.google.common.base.Predicate;
import javax.annotation.Nullable;
import net.ilexiconn.llibrary.server.animation.Animation;
import net.ilexiconn.llibrary.server.animation.AnimationHandler;
import net.ilexiconn.llibrary.server.animation.IAnimatedEntity;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.BossInfo;
import net.minecraft.world.BossInfoServer;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.event.ForgeEventFactory;

public class EntityMarbleCheeseGolem
extends EntityMob
implements IAnimatedEntity,
IRangedAttackMob,
IRatlantean {
    public static final Animation ANIMATION_MELEE = Animation.create((int)15);
    public static final Animation ANIMATION_RANGED = Animation.create((int)15);
    public static final ResourceLocation LOOT = LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("rats", "marbled_cheese_golem"));
    private static final Predicate<EntityLivingBase> NOT_RATLANTEAN = new Predicate<EntityLivingBase>(){

        public boolean apply(@Nullable EntityLivingBase entity) {
            return entity.func_70089_S() && !(entity instanceof IRatlantean);
        }
    };
    private final BossInfoServer bossInfo = new BossInfoServer(this.func_145748_c_(), BossInfo.Color.GREEN, BossInfo.Overlay.PROGRESS);
    private int blockBreakCounter;
    private int animationTick;
    private boolean useRangedAttack = false;
    private Animation currentAnimation;

    public EntityMarbleCheeseGolem(World worldIn) {
        super(worldIn);
        this.func_70606_j(this.func_110138_aP());
        this.func_70105_a(2.0f, 3.5f);
        this.field_70178_ae = true;
        ((PathNavigateGround)this.func_70661_as()).func_179693_d(true);
        this.field_70728_aV = 50;
        this.field_70138_W = 2.0f;
        this.field_70765_h = new AIMoveControl(this);
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public static boolean canDestroyBlock(Block blockIn) {
        return blockIn != Blocks.field_150357_h && blockIn != Blocks.field_150384_bq && blockIn != Blocks.field_150378_br && blockIn != Blocks.field_150483_bI && blockIn != Blocks.field_185776_dc && blockIn != Blocks.field_185777_dd && blockIn != Blocks.field_180401_cv && blockIn != Blocks.field_185779_df && blockIn != Blocks.field_189881_dj && blockIn != Blocks.field_180384_M && blockIn != Blocks.field_185775_db;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)RatsMod.CONFIG_OPTIONS.ratlanteanAutomatonHealth);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.8);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a((double)RatsMod.CONFIG_OPTIONS.ratlanteanAutomatonAttack);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(128.0);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(10.0);
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.UNDEFINED;
    }

    protected boolean func_184228_n(Entity entityIn) {
        return false;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AIFollowPrey(this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new AIMoveRandom());
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityLiving.class, 0, false, false, NOT_RATLANTEAN));
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
        if (this.blockBreakCounter > 0) {
            --this.blockBreakCounter;
            if (this.blockBreakCounter == 0 && ForgeEventFactory.getMobGriefingEvent((World)this.field_70170_p, (Entity)this)) {
                int i1 = MathHelper.func_76128_c((double)this.field_70163_u);
                int l1 = MathHelper.func_76128_c((double)this.field_70165_t);
                int i2 = MathHelper.func_76128_c((double)this.field_70161_v);
                boolean flag = false;
                for (int k2 = -2; k2 <= 2; ++k2) {
                    for (int l2 = -2; l2 <= 2; ++l2) {
                        for (int j = 1; j <= 3; ++j) {
                            int i3 = l1 + k2;
                            int k = i1 + j;
                            int l = i2 + l2;
                            BlockPos blockpos = new BlockPos(i3, k, l);
                            IBlockState iblockstate = this.field_70170_p.func_180495_p(blockpos);
                            Block block = iblockstate.func_177230_c();
                            if (block instanceof BlockLiquid || !EntityMarbleCheeseGolem.canDestroyBlock(block) || block.isAir(iblockstate, (IBlockAccess)this.field_70170_p, blockpos) || !block.canEntityDestroy(iblockstate, (IBlockAccess)this.field_70170_p, blockpos, (Entity)this) || !ForgeEventFactory.onEntityDestroyBlock((EntityLivingBase)this, (BlockPos)blockpos, (IBlockState)iblockstate)) continue;
                            flag = this.field_70170_p.func_175655_b(blockpos, true) || flag;
                        }
                    }
                }
                if (flag) {
                    this.field_70170_p.func_180498_a(null, 1022, new BlockPos((Entity)this), 0);
                }
            }
        }
    }

    public boolean func_184222_aU() {
        return false;
    }

    public boolean func_70652_k(Entity entityIn) {
        if (this.getAnimation() == NO_ANIMATION) {
            this.setAnimation(this.useRangedAttack ? ANIMATION_MELEE : ANIMATION_RANGED);
        }
        return true;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if (source != DamageSource.field_76369_e && !(source.func_76346_g() instanceof EntityMarbleCheeseGolem)) {
            if (this.blockBreakCounter <= 0) {
                this.blockBreakCounter = 20;
            }
            return super.func_70097_a(source, amount);
        }
        return false;
    }

    public void func_82196_d(EntityLivingBase target, float distanceFactor) {
        this.useRangedAttack = true;
        if (this.getAnimation() == NO_ANIMATION) {
            this.setAnimation(ANIMATION_RANGED);
        }
    }

    public void func_184724_a(boolean swingingArms) {
    }

    protected SoundEvent func_184639_G() {
        return RatsSoundRegistry.RATLANTEAN_AUTOMATON_IDLE;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return RatsSoundRegistry.RATLANTEAN_AUTOMATON_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return RatsSoundRegistry.RATLANTEAN_AUTOMATON_DIE;
    }

    public void func_70636_d() {
        double extraY;
        double extraZ;
        double extraX;
        float angle;
        float radius;
        super.func_70636_d();
        if (this.blockBreakCounter <= 0) {
            this.blockBreakCounter = 20;
        }
        if (this.func_70638_az() != null) {
            boolean bl = this.useRangedAttack = this.func_70032_d((Entity)this.func_70638_az()) > 10.0f;
        }
        if (this.useRangedAttack && this.getAnimation() != ANIMATION_RANGED && this.func_70638_az() != null && this.func_70685_l((Entity)this.func_70638_az())) {
            this.setAnimation(ANIMATION_RANGED);
            this.func_70625_a((Entity)this.func_70638_az(), 360.0f, 80.0f);
        }
        if (!this.useRangedAttack && this.func_70638_az() != null && this.func_70032_d((Entity)this.func_70638_az()) < 7.0f && this.func_70685_l((Entity)this.func_70638_az())) {
            if (this.getAnimation() == NO_ANIMATION) {
                this.setAnimation(ANIMATION_MELEE);
                this.func_184185_a(SoundEvents.field_187730_dW, 1.0f, 0.5f + this.field_70146_Z.nextFloat() * 0.5f);
            }
            this.func_70625_a((Entity)this.func_70638_az(), 360.0f, 80.0f);
            if (this.getAnimation() == ANIMATION_MELEE && this.getAnimationTick() == 10) {
                this.func_70638_az().func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)this.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111264_e).func_111126_e());
                this.func_70638_az().func_70653_a((Entity)this.func_70638_az(), 1.5f, this.field_70165_t - this.func_70638_az().field_70165_t, this.field_70161_v - this.func_70638_az().field_70161_v);
                this.useRangedAttack = this.field_70146_Z.nextBoolean();
            }
        }
        if (this.field_70170_p.field_72995_K && this.field_70146_Z.nextDouble() < 0.5) {
            radius = -0.5f;
            angle = (float)Math.PI / 180 * this.field_70761_aq;
            extraX = (double)(radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)))) + this.field_70165_t;
            extraZ = (double)(radius * MathHelper.func_76134_b((float)angle)) + this.field_70161_v;
            extraY = 1.25 + this.field_70163_u;
            this.field_70170_p.func_175688_a(EnumParticleTypes.END_ROD, extraX + (double)(this.field_70146_Z.nextFloat() * 0.5f) - 0.25, extraY, extraZ + (double)(this.field_70146_Z.nextFloat() * 0.5f) - 0.25, 0.0, (double)-0.1f, 0.0, new int[0]);
        }
        if (this.useRangedAttack && this.getAnimation() == ANIMATION_RANGED && this.getAnimationTick() == 6) {
            radius = -3.8f;
            angle = (float)Math.PI / 180 * this.field_70761_aq - 160.0f;
            extraX = (double)(radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)))) + this.field_70165_t;
            extraZ = (double)(radius * MathHelper.func_76134_b((float)angle)) + this.field_70161_v;
            extraY = (double)2.4f + this.field_70163_u;
            double targetRelativeX = (this.func_70638_az() == null ? this.func_70676_i((float)1.0f).field_72450_a : this.func_70638_az().field_70165_t) - extraX;
            double targetRelativeY = (this.func_70638_az() == null ? this.func_70676_i((float)1.0f).field_72448_b : this.func_70638_az().field_70163_u) - extraY;
            double targetRelativeZ = (this.func_70638_az() == null ? this.func_70676_i((float)1.0f).field_72449_c : this.func_70638_az().field_70161_v) - extraZ;
            EntityGolemBeam beam = new EntityGolemBeam(this.field_70170_p, (EntityLivingBase)this);
            beam.func_70107_b(extraX, extraY, extraZ);
            beam.func_70186_c(targetRelativeX, targetRelativeY, targetRelativeZ, 2.0f, 0.1f);
            this.func_184185_a(RatsSoundRegistry.LASER, 1.0f, 0.75f + this.field_70146_Z.nextFloat() * 0.5f);
            if (!this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_72838_d((Entity)beam);
            }
            this.useRangedAttack = this.field_70146_Z.nextBoolean();
        }
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
    }

    public Animation[] getAnimations() {
        return new Animation[]{ANIMATION_MELEE, ANIMATION_RANGED};
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (this.func_145818_k_()) {
            this.bossInfo.func_186739_a(this.func_145748_c_());
        }
    }

    public void func_96094_a(String name) {
        super.func_96094_a(name);
        this.bossInfo.func_186739_a(this.func_145748_c_());
    }

    public void func_184178_b(EntityPlayerMP player) {
        super.func_184178_b(player);
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(EntityPlayerMP player) {
        super.func_184203_c(player);
        this.bossInfo.func_186761_b(player);
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LOOT;
    }

    class AIFollowPrey
    extends EntityAIBase {
        private final EntityMarbleCheeseGolem parentEntity;
        public int attackTimer;
        private double followDist;

        public AIFollowPrey(EntityMarbleCheeseGolem ghast) {
            this.parentEntity = ghast;
        }

        public boolean func_75250_a() {
            this.followDist = EntityMarbleCheeseGolem.this.func_174813_aQ().func_72320_b();
            EntityLivingBase entitylivingbase = this.parentEntity.func_70638_az();
            double maxFollow = this.parentEntity.useRangedAttack ? 5.0 * this.followDist : this.followDist;
            return entitylivingbase != null && ((double)entitylivingbase.func_70032_d((Entity)this.parentEntity) >= maxFollow || !this.parentEntity.func_70685_l((Entity)entitylivingbase));
        }

        public void func_75249_e() {
            this.attackTimer = 0;
        }

        public void func_75251_c() {
        }

        public void func_75246_d() {
            double maxFollow;
            EntityLivingBase entitylivingbase = this.parentEntity.func_70638_az();
            double d = maxFollow = this.parentEntity.useRangedAttack ? 5.0 * this.followDist : this.followDist;
            if ((double)entitylivingbase.func_70032_d((Entity)this.parentEntity) >= maxFollow || !this.parentEntity.func_70685_l((Entity)entitylivingbase)) {
                EntityMarbleCheeseGolem.this.field_70765_h.func_75642_a(entitylivingbase.field_70165_t, entitylivingbase.field_70163_u + 1.0, entitylivingbase.field_70161_v, 1.0);
            }
        }
    }

    class AIMoveRandom
    extends EntityAIBase {
        public AIMoveRandom() {
            this.func_75248_a(1);
        }

        public boolean func_75250_a() {
            return !EntityMarbleCheeseGolem.this.func_70605_aq().func_75640_a() && EntityMarbleCheeseGolem.this.field_70146_Z.nextInt(2) == 0;
        }

        public boolean func_75253_b() {
            return false;
        }

        public void func_75246_d() {
            BlockPos blockpos = new BlockPos((Entity)EntityMarbleCheeseGolem.this);
            for (int i = 0; i < 3; ++i) {
                BlockPos blockpos1 = blockpos.func_177982_a(EntityMarbleCheeseGolem.this.field_70146_Z.nextInt(15) - 7, EntityMarbleCheeseGolem.this.field_70146_Z.nextInt(11) - 5, EntityMarbleCheeseGolem.this.field_70146_Z.nextInt(15) - 7);
                if (!EntityMarbleCheeseGolem.this.field_70170_p.func_175623_d(blockpos1)) continue;
                EntityMarbleCheeseGolem.this.field_70765_h.func_75642_a((double)blockpos1.func_177958_n() + 0.5, (double)blockpos1.func_177956_o() + 0.5, (double)blockpos1.func_177952_p() + 0.5, 1.0);
                if (EntityMarbleCheeseGolem.this.func_70638_az() != null) break;
                EntityMarbleCheeseGolem.this.func_70671_ap().func_75650_a((double)blockpos1.func_177958_n() + 0.5, (double)blockpos1.func_177956_o() + 0.5, (double)blockpos1.func_177952_p() + 0.5, 180.0f, 20.0f);
                break;
            }
        }
    }

    class AIMoveControl
    extends EntityMoveHelper {
        public AIMoveControl(EntityMarbleCheeseGolem vex) {
            super((EntityLiving)vex);
        }

        public void func_75641_c() {
            if (this.field_188491_h == EntityMoveHelper.Action.MOVE_TO) {
                double d0 = this.field_75646_b - EntityMarbleCheeseGolem.this.field_70165_t;
                double d1 = this.field_75647_c - EntityMarbleCheeseGolem.this.field_70163_u;
                double d2 = this.field_75644_d - EntityMarbleCheeseGolem.this.field_70161_v;
                double d3 = d0 * d0 + d1 * d1 + d2 * d2;
                if ((d3 = (double)MathHelper.func_76133_a((double)d3)) < EntityMarbleCheeseGolem.this.func_174813_aQ().func_72320_b()) {
                    this.field_188491_h = EntityMoveHelper.Action.WAIT;
                    EntityMarbleCheeseGolem.this.field_70159_w *= 0.5;
                    EntityMarbleCheeseGolem.this.field_70181_x *= 0.5;
                    EntityMarbleCheeseGolem.this.field_70179_y *= 0.5;
                } else {
                    EntityMarbleCheeseGolem.this.field_70159_w += d0 / d3 * 0.05 * this.field_75645_e;
                    EntityMarbleCheeseGolem.this.field_70181_x += d1 / d3 * 0.05 * this.field_75645_e;
                    EntityMarbleCheeseGolem.this.field_70179_y += d2 / d3 * 0.05 * this.field_75645_e;
                    if (EntityMarbleCheeseGolem.this.func_70638_az() == null) {
                        EntityMarbleCheeseGolem.this.field_70761_aq = EntityMarbleCheeseGolem.this.field_70177_z = -((float)MathHelper.func_181159_b((double)EntityMarbleCheeseGolem.this.field_70159_w, (double)EntityMarbleCheeseGolem.this.field_70179_y)) * 57.295776f;
                    } else {
                        double d4 = EntityMarbleCheeseGolem.this.func_70638_az().field_70165_t - EntityMarbleCheeseGolem.this.field_70165_t;
                        double d5 = EntityMarbleCheeseGolem.this.func_70638_az().field_70161_v - EntityMarbleCheeseGolem.this.field_70161_v;
                        EntityMarbleCheeseGolem.this.field_70761_aq = EntityMarbleCheeseGolem.this.field_70177_z = -((float)MathHelper.func_181159_b((double)d4, (double)d5)) * 57.295776f;
                    }
                }
            }
        }
    }
}

