/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.client.render.tile;

import com.github.alexthe666.rats.client.model.ModelAutoCurdler;
import com.github.alexthe666.rats.server.blocks.BlockAutoCurdler;
import com.github.alexthe666.rats.server.blocks.BlockRatTrap;
import com.github.alexthe666.rats.server.entity.tile.TileEntityAutoCurdler;
import net.minecraft.block.properties.IProperty;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public class RenderAutoCurdler
extends TileEntitySpecialRenderer<TileEntityAutoCurdler> {
    private static final ModelAutoCurdler MODEL_AUTO_CURDLER = new ModelAutoCurdler();
    private static final ResourceLocation TEXTURE = new ResourceLocation("rats:textures/model/auto_curdler.png");

    public void render(TileEntityAutoCurdler entity, double x, double y, double z, float f, int f1, float alpha) {
        float rotation = 0.0f;
        if (entity != null && entity.func_145831_w() != null && entity instanceof TileEntityAutoCurdler) {
            if (entity.func_145831_w().func_180495_p(entity.func_174877_v()).func_177230_c() instanceof BlockAutoCurdler) {
                if (entity.func_145831_w().func_180495_p(entity.func_174877_v()).func_177229_b((IProperty)BlockRatTrap.FACING) == EnumFacing.NORTH) {
                    rotation = 180.0f;
                }
                if (entity.func_145831_w().func_180495_p(entity.func_174877_v()).func_177229_b((IProperty)BlockRatTrap.FACING) == EnumFacing.EAST) {
                    rotation = -90.0f;
                }
                if (entity.func_145831_w().func_180495_p(entity.func_174877_v()).func_177229_b((IProperty)BlockRatTrap.FACING) == EnumFacing.WEST) {
                    rotation = 90.0f;
                }
            }
            if (entity.tank.getFluidAmount() > 0) {
                RenderAutoCurdler.renderMilk(x, y, z, rotation, entity.tank.getFluid());
            }
        }
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + 1.5f), (float)((float)z + 0.5f));
        GL11.glPushMatrix();
        GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)rotation, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glPushMatrix();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TEXTURE);
        MODEL_AUTO_CURDLER.render(0.0625f);
        GL11.glPopMatrix();
        GL11.glPopMatrix();
        GL11.glPopMatrix();
    }

    public static void renderMilk(double x, double y, double z, float rotation, FluidStack fluidStack) {
        float textureYPos = 0.6f * ((float)fluidStack.amount / 5000.0f);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + 1.5f), (float)((float)z + 0.5f));
        GL11.glPushMatrix();
        GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)rotation, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)-0.5f, (float)0.5f, (float)-0.5f);
        GL11.glPushMatrix();
        AxisAlignedBB boundingBox = new AxisAlignedBB(0.25, (double)(0.6f - textureYPos), 0.25, 0.75, 0.5, 0.75);
        TextureAtlasSprite sprite = Minecraft.func_71410_x().func_147117_R().func_110572_b(fluidStack.getFluid().getStill(fluidStack).toString());
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexbuffer = tessellator.func_178180_c();
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181710_j);
        double avgY = boundingBox.field_72337_e - boundingBox.field_72338_b;
        double avgX = Math.abs(boundingBox.field_72336_d - boundingBox.field_72340_a);
        double avgZ = Math.abs(boundingBox.field_72334_f - boundingBox.field_72339_c);
        float f1 = sprite.func_94209_e();
        float f2 = sprite.func_94212_f();
        float f2_alt_x = (float)Math.min((double)sprite.func_94212_f(), (double)f1 + avgX * (double)Math.abs(sprite.func_94212_f() - sprite.func_94209_e()));
        float f2_alt_z = (float)Math.min((double)sprite.func_94212_f(), (double)f1 + avgZ * (double)Math.abs(sprite.func_94212_f() - sprite.func_94209_e()));
        float f3 = sprite.func_94206_g();
        float f4 = sprite.func_94210_h();
        float f4_alt = (float)Math.min((double)sprite.func_94210_h(), (double)f3 + avgY * (double)Math.abs(sprite.func_94210_h() - sprite.func_94206_g()));
        float f4_alt_x = (float)Math.min((double)sprite.func_94210_h(), (double)f3 + avgX * (double)Math.abs(sprite.func_94210_h() - sprite.func_94206_g()));
        float f4_alt_z = (float)Math.min((double)sprite.func_94210_h(), (double)f3 + avgZ * (double)Math.abs(sprite.func_94210_h() - sprite.func_94206_g()));
        vertexbuffer.func_181662_b(boundingBox.field_72340_a, boundingBox.field_72337_e, boundingBox.field_72339_c).func_187315_a((double)f2_alt_x, (double)f3).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
        vertexbuffer.func_181662_b(boundingBox.field_72336_d, boundingBox.field_72337_e, boundingBox.field_72339_c).func_187315_a((double)f1, (double)f3).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
        vertexbuffer.func_181662_b(boundingBox.field_72336_d, boundingBox.field_72338_b, boundingBox.field_72339_c).func_187315_a((double)f1, (double)f4_alt).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
        vertexbuffer.func_181662_b(boundingBox.field_72340_a, boundingBox.field_72338_b, boundingBox.field_72339_c).func_187315_a((double)f2_alt_x, (double)f4_alt).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
        vertexbuffer.func_181662_b(boundingBox.field_72340_a, boundingBox.field_72338_b, boundingBox.field_72334_f).func_187315_a((double)f1, (double)f4_alt).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
        vertexbuffer.func_181662_b(boundingBox.field_72336_d, boundingBox.field_72338_b, boundingBox.field_72334_f).func_187315_a((double)f2_alt_x, (double)f4_alt).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
        vertexbuffer.func_181662_b(boundingBox.field_72336_d, boundingBox.field_72337_e, boundingBox.field_72334_f).func_187315_a((double)f2_alt_x, (double)f3).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
        vertexbuffer.func_181662_b(boundingBox.field_72340_a, boundingBox.field_72337_e, boundingBox.field_72334_f).func_187315_a((double)f1, (double)f3).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
        vertexbuffer.func_181662_b(boundingBox.field_72340_a, boundingBox.field_72338_b, boundingBox.field_72339_c).func_187315_a((double)f1, (double)f4_alt_z).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
        vertexbuffer.func_181662_b(boundingBox.field_72336_d, boundingBox.field_72338_b, boundingBox.field_72339_c).func_187315_a((double)f2_alt_x, (double)f4_alt_z).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
        vertexbuffer.func_181662_b(boundingBox.field_72336_d, boundingBox.field_72338_b, boundingBox.field_72334_f).func_187315_a((double)f2_alt_x, (double)f3).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
        vertexbuffer.func_181662_b(boundingBox.field_72340_a, boundingBox.field_72338_b, boundingBox.field_72334_f).func_187315_a((double)f1, (double)f3).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
        vertexbuffer.func_181662_b(boundingBox.field_72340_a, boundingBox.field_72337_e, boundingBox.field_72334_f).func_187315_a((double)f1, (double)f4_alt_z).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
        vertexbuffer.func_181662_b(boundingBox.field_72336_d, boundingBox.field_72337_e, boundingBox.field_72334_f).func_187315_a((double)f2_alt_x, (double)f4_alt_z).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
        vertexbuffer.func_181662_b(boundingBox.field_72336_d, boundingBox.field_72337_e, boundingBox.field_72339_c).func_187315_a((double)f2_alt_x, (double)f3).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
        vertexbuffer.func_181662_b(boundingBox.field_72340_a, boundingBox.field_72337_e, boundingBox.field_72339_c).func_187315_a((double)f1, (double)f3).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
        vertexbuffer.func_181662_b(boundingBox.field_72340_a, boundingBox.field_72338_b, boundingBox.field_72334_f).func_187315_a((double)f2_alt_z, (double)f4_alt).func_181663_c(-1.0f, 0.0f, 0.0f).func_181675_d();
        vertexbuffer.func_181662_b(boundingBox.field_72340_a, boundingBox.field_72337_e, boundingBox.field_72334_f).func_187315_a((double)f2_alt_z, (double)f3).func_181663_c(-1.0f, 0.0f, 0.0f).func_181675_d();
        vertexbuffer.func_181662_b(boundingBox.field_72340_a, boundingBox.field_72337_e, boundingBox.field_72339_c).func_187315_a((double)f1, (double)f3).func_181663_c(-1.0f, 0.0f, 0.0f).func_181675_d();
        vertexbuffer.func_181662_b(boundingBox.field_72340_a, boundingBox.field_72338_b, boundingBox.field_72339_c).func_187315_a((double)f1, (double)f4_alt).func_181663_c(-1.0f, 0.0f, 0.0f).func_181675_d();
        vertexbuffer.func_181662_b(boundingBox.field_72336_d, boundingBox.field_72338_b, boundingBox.field_72339_c).func_187315_a((double)f2_alt_z, (double)f4_alt).func_181663_c(1.0f, 0.0f, 0.0f).func_181675_d();
        vertexbuffer.func_181662_b(boundingBox.field_72336_d, boundingBox.field_72337_e, boundingBox.field_72339_c).func_187315_a((double)f2_alt_z, (double)f3).func_181663_c(1.0f, 0.0f, 0.0f).func_181675_d();
        vertexbuffer.func_181662_b(boundingBox.field_72336_d, boundingBox.field_72337_e, boundingBox.field_72334_f).func_187315_a((double)f1, (double)f3).func_181663_c(1.0f, 0.0f, 0.0f).func_181675_d();
        vertexbuffer.func_181662_b(boundingBox.field_72336_d, boundingBox.field_72338_b, boundingBox.field_72334_f).func_187315_a((double)f1, (double)f4_alt).func_181663_c(1.0f, 0.0f, 0.0f).func_181675_d();
        tessellator.func_78381_a();
        GL11.glPopMatrix();
        GL11.glPopMatrix();
        GL11.glPopMatrix();
    }
}

