/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.client.render;

import com.github.alexthe666.rats.server.items.ItemRatNuggetOre;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;

public class NuggetColorRegister {
    public static final ItemStack FALLBACK_STACK = new ItemStack(Items.field_151042_j);
    public static Map<String, Integer> TEXTURES_TO_COLOR = new HashMap<String, Integer>();

    public static int getNuggetColor(ItemStack stack) {
        ItemStack poopStack = ItemRatNuggetOre.getIngot(stack, FALLBACK_STACK);
        String poopName = poopStack.func_82833_r();
        if (TEXTURES_TO_COLOR.get(poopName) != null) {
            return TEXTURES_TO_COLOR.get(poopName);
        }
        Object texture = null;
        int color = 0xFFFFFF;
        try {
            BufferedImage bufferedimage = NuggetColorRegister.getBufferedImage(NuggetColorRegister.getTextureAtlas(poopStack));
            Color texColour = NuggetColorRegister.getAverageColour(bufferedimage);
            color = texColour.getRGB();
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        TEXTURES_TO_COLOR.put(poopName, color);
        return color;
    }

    private static Color getAverageColour(BufferedImage image) {
        float red = 0.0f;
        float green = 0.0f;
        float blue = 0.0f;
        float count = 0.0f;
        for (float i = (float)image.getMinX(); i < (float)(image.getMinX() + image.getWidth()); i += 1.0f) {
            for (float j = (float)image.getMinY(); j < (float)(image.getMinY() + image.getHeight()); j += 1.0f) {
                Color c = new Color(image.getRGB((int)i, (int)j));
                if (c.getAlpha() != 255 || c.getRed() <= 50 && c.getBlue() <= 50 && c.getGreen() <= 50) continue;
                red += (float)c.getRed();
                green += (float)c.getGreen();
                blue += (float)c.getBlue();
                count += 1.0f;
            }
        }
        return new Color((int)(red / count), (int)(green / count), (int)(blue / count));
    }

    private static TextureAtlasSprite getTextureAtlas(ItemStack oreStack) {
        return Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178087_a(oreStack.func_77973_b(), oreStack.func_77960_j());
    }

    private static BufferedImage getBufferedImage(TextureAtlasSprite textureAtlasSprite) {
        int iconWidth = textureAtlasSprite.func_94211_a();
        int iconHeight = textureAtlasSprite.func_94216_b();
        int frameCount = textureAtlasSprite.func_110970_k();
        if (iconWidth <= 0 || iconHeight <= 0 || frameCount <= 0) {
            return null;
        }
        BufferedImage bufferedImage = new BufferedImage(iconWidth, iconHeight * frameCount, 6);
        for (int i = 0; i < frameCount; ++i) {
            int[][] frame = textureAtlasSprite.func_147965_a(i);
            int[] largest = frame[0];
            bufferedImage.setRGB(0, i * iconHeight, iconWidth, iconHeight, largest, 0, iconWidth);
        }
        return bufferedImage;
    }
}

