/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.client.gui;

import com.github.alexthe666.rats.RatsMod;
import com.github.alexthe666.rats.client.ClientProxy;
import com.github.alexthe666.rats.server.entity.EntityRat;
import com.github.alexthe666.rats.server.message.MessageCheeseStaffSync;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiPageButtonList;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiSlider;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class GuiRadiusStaff
extends GuiScreen {
    protected static final ResourceLocation TEXTURE = new ResourceLocation("rats:textures/gui/cheese_staff.png");
    private final GuiPageButtonList.GuiResponder sliderResponder;
    private final GuiSlider.FormatHelper formatHelper;
    private final EntityRat rat;
    private int sliderValue;
    private int prevSliderValue;

    public GuiRadiusStaff(EntityRat rat) {
        this.prevSliderValue = this.sliderValue;
        this.rat = rat;
        this.prevSliderValue = this.sliderValue = rat.getSearchRadius();
        this.func_73866_w_();
        this.sliderResponder = new GuiPageButtonList.GuiResponder(){

            public void func_175321_a(int id, boolean value) {
            }

            public void func_175320_a(int id, float value) {
                GuiRadiusStaff.this.setSliderValue(id, value);
            }

            public void func_175319_a(int id, String value) {
            }
        };
        this.formatHelper = new GuiSlider.FormatHelper(){

            public String func_175318_a(int id, String name, float value) {
                return name + ": " + Math.round(value);
            }
        };
    }

    public static void drawEntityOnScreen(int posX, int posY, int scale, float mouseX, float mouseY, EntityRat entity) {
        GlStateManager.func_179142_g();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)posX, (float)posY, (float)30.0f);
        GlStateManager.func_179152_a((float)(-scale), (float)scale, (float)scale);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        float f2 = entity.field_70761_aq;
        float f3 = entity.field_70177_z;
        float f4 = entity.field_70125_A;
        float f5 = entity.field_70758_at;
        float f6 = entity.field_70759_as;
        GlStateManager.func_179114_b((float)135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        RenderHelper.func_74519_b();
        GlStateManager.func_179114_b((float)-135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)0.0f);
        RenderManager rendermanager = Minecraft.func_71410_x().func_175598_ae();
        rendermanager.func_178631_a(180.0f);
        GlStateManager.func_179114_b((float)(Minecraft.func_71410_x().field_71439_g.field_70173_aa % 360), (float)0.0f, (float)1.0f, (float)0.0f);
        rendermanager.func_178633_a(false);
        entity.field_70761_aq = 0.0f;
        entity.field_70177_z = 0.0f;
        entity.field_70125_A = 0.0f;
        entity.field_70758_at = 0.0f;
        entity.field_70759_as = 0.0f;
        rendermanager.func_188391_a((Entity)entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, false);
        rendermanager.func_178633_a(true);
        entity.field_70761_aq = f2;
        entity.field_70177_z = f3;
        entity.field_70125_A = f4;
        entity.field_70758_at = f5;
        entity.field_70759_as = f6;
        GlStateManager.func_179121_F();
        RenderHelper.func_74518_a();
        GlStateManager.func_179101_C();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
        GlStateManager.func_179090_x();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
    }

    private void setSliderValue(int id, float value) {
        this.sliderValue = Math.round(value);
        if (this.prevSliderValue != this.sliderValue) {
            RatsMod.NETWORK_WRAPPER.sendToServer((IMessage)new MessageCheeseStaffSync(this.rat.func_145782_y(), BlockPos.field_177992_a, EnumFacing.UP, 5, this.sliderValue));
            this.rat.setSearchRadius(Math.round(this.sliderValue));
        }
        this.prevSliderValue = this.sliderValue;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.clear();
        int i = this.field_146294_l / 2;
        int j = (this.field_146295_m - 166) / 2;
        String topText = I18n.func_135052_a((String)"entity.rat.staff.set_radius_loc", (Object[])new Object[]{this.getPosName()});
        String secondText = I18n.func_135052_a((String)"entity.rat.staff.reset_radius", (Object[])new Object[0]);
        int maxLength = Math.max(150, Minecraft.func_71410_x().field_71466_p.func_78256_a(topText) + 20);
        this.field_146292_n.add(new GuiButton(0, i - maxLength / 2, j + 60, maxLength, 20, topText));
        this.field_146292_n.add(new GuiSlider(this.sliderResponder, 1, i - 75, j + 85, I18n.func_135052_a((String)"entity.rat.staff.radius", (Object[])new Object[0]), 1.0f, RatsMod.CONFIG_OPTIONS.maxRatRadius, this.sliderValue, this.formatHelper){});
        this.field_146292_n.add(new GuiButton(2, i - maxLength / 2, j + 110, maxLength, 20, secondText));
    }

    private String getPosName() {
        return "(" + ClientProxy.refrencedPos.func_177958_n() + ", " + ClientProxy.refrencedPos.func_177956_o() + ", " + ClientProxy.refrencedPos.func_177952_p() + ")";
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        if (this.field_146297_k != null) {
            try {
                this.func_146276_q_();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        super.func_73863_a(mouseX, mouseY, partialTicks);
        int i = (this.field_146294_l - 248) / 2 + 10;
        int j = (this.field_146295_m - 166) / 2 + 8;
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)10.0f);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiRadiusStaff.drawEntityOnScreen(i + 114, j + 40, 70, 0.0f, 0.0f, this.rat);
        GlStateManager.func_179121_F();
    }

    public boolean func_73868_f() {
        return false;
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146124_l && button.field_146127_k == 0) {
            BlockPos pos = ClientProxy.refrencedPos;
            RatsMod.NETWORK_WRAPPER.sendToServer((IMessage)new MessageCheeseStaffSync(this.rat.func_145782_y(), pos, EnumFacing.UP, 4, 0));
            this.rat.setSearchRadiusCenter(pos);
        }
        if (button.field_146124_l && button.field_146127_k == 2) {
            RatsMod.NETWORK_WRAPPER.sendToServer((IMessage)new MessageCheeseStaffSync(this.rat.func_145782_y(), BlockPos.field_177992_a, EnumFacing.UP, 6, 0));
            this.rat.setSearchRadiusCenter(null);
            this.rat.setSearchRadius(RatsMod.CONFIG_OPTIONS.defaultRatRadius);
        }
    }
}

