/*
 * Decompiled with CFR 0.152.
 */
package leviathan143.loottweaker.common.zenscript.factory;

import crafttweaker.api.data.IData;
import leviathan143.loottweaker.common.ErrorHandler;
import leviathan143.loottweaker.common.darkmagic.LootTableManagerAccessors;
import leviathan143.loottweaker.common.lib.DataParser;
import leviathan143.loottweaker.common.zenscript.wrapper.ZenLootConditionWrapper;
import net.minecraft.world.storage.loot.conditions.KilledByPlayer;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.conditions.RandomChance;
import net.minecraft.world.storage.loot.conditions.RandomChanceWithLooting;

public class LootConditionFactoryImpl {
    private final DataParser loggingParser = new DataParser(LootTableManagerAccessors.getGsonInstance(), e -> errorHandler.error(e.getMessage()));

    public LootConditionFactoryImpl(ErrorHandler errorHandler) {
    }

    public ZenLootConditionWrapper randomChance(float chance) {
        return new ZenLootConditionWrapper((LootCondition)new RandomChance(chance));
    }

    public ZenLootConditionWrapper randomChanceWithLooting(float chance, float lootingMultiplier) {
        return new ZenLootConditionWrapper((LootCondition)new RandomChanceWithLooting(chance, lootingMultiplier));
    }

    public ZenLootConditionWrapper killedByPlayer() {
        return new ZenLootConditionWrapper((LootCondition)new KilledByPlayer(false));
    }

    public ZenLootConditionWrapper killedByNonPlayer() {
        return new ZenLootConditionWrapper((LootCondition)new KilledByPlayer(true));
    }

    public ZenLootConditionWrapper parse(IData json) {
        return this.loggingParser.parse(json, LootCondition.class).map(ZenLootConditionWrapper::new).orElse(ZenLootConditionWrapper.INVALID);
    }
}

