/*
 * Decompiled with CFR 0.152.
 */
package ivorius.ivtoolkit.transform;

import com.google.common.collect.ImmutableSet;
import ivorius.ivtoolkit.math.AxisAlignedTransform2D;
import ivorius.ivtoolkit.math.MinecraftTransforms;
import ivorius.ivtoolkit.tools.EntityCreatureAccessor;
import ivorius.ivtoolkit.transform.AreaTransformable;
import ivorius.ivtoolkit.transform.Mover;
import java.util.Arrays;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.Pair;

public class PosTransformer {
    public static void transformTileEntityPos(TileEntity tileEntity, AxisAlignedTransform2D transform, int[] size) {
        if (tileEntity instanceof AreaTransformable) {
            ((AreaTransformable)tileEntity).transform(transform.getRotation(), transform.isMirrorX(), size);
        } else {
            Pair<Rotation, Mirror> mct = MinecraftTransforms.to(transform);
            tileEntity.func_189668_a((Mirror)mct.getRight());
            tileEntity.func_189667_a((Rotation)mct.getLeft());
            Mover.setTileEntityPos(tileEntity, transform.apply(tileEntity.func_174877_v(), size));
        }
    }

    public static void transformEntityPos(Entity entity, AxisAlignedTransform2D transform, int[] size) {
        if (entity instanceof AreaTransformable) {
            ((AreaTransformable)entity).transform(transform.getRotation(), transform.isMirrorX(), size);
        } else {
            double[] newEntityPos = transform.applyOn(new double[]{entity.field_70165_t, entity.field_70163_u, entity.field_70161_v}, size);
            Pair<Rotation, Mirror> mct = MinecraftTransforms.to(transform);
            float yaw = entity.func_184217_a((Mirror)mct.getRight());
            entity.func_70012_b(newEntityPos[0], newEntityPos[1], newEntityPos[2], yaw += entity.field_70177_z - entity.func_184229_a((Rotation)mct.getLeft()), entity.field_70125_A);
            if (entity instanceof EntityCreature) {
                EntityCreature entityCreature = (EntityCreature)entity;
                EntityCreatureAccessor.setHomePosition(entityCreature, transform.apply(entityCreature.func_180486_cf(), size));
            }
        }
    }

    public static IBlockState transformBlockState(IBlockState state, AxisAlignedTransform2D transform) {
        return MinecraftTransforms.map(transform, (rotation, mirror) -> state.func_185902_a(mirror).func_185907_a(rotation));
    }

    @Deprecated
    public static void transformBlock(World world, BlockPos coord, AxisAlignedTransform2D transform) {
    }

    @Deprecated
    public static void transformBlock(AxisAlignedTransform2D transform, World world, IBlockState state, BlockPos coord, Block block) {
        PosTransformer.transformBlockDefault(transform, world, state, coord, block);
    }

    @Deprecated
    public static void transformBlockDefault(AxisAlignedTransform2D transform, World world, IBlockState state, BlockPos coord, Block block) {
        IBlockState newState = state;
        ImmutableSet propertySet = state.func_177228_b().entrySet();
        for (Map.Entry entry : propertySet) {
            IProperty property = (IProperty)entry.getKey();
            if (property.func_177699_b() != EnumFacing.class || !property.func_177700_c().containsAll(Arrays.asList(EnumFacing.field_176754_o))) continue;
            EnumFacing value = (EnumFacing)entry.getValue();
            newState = newState.func_177226_a(property, (Comparable)transform.apply(value));
        }
        if (newState != state) {
            world.func_175656_a(coord, newState);
        }
    }
}

