/*
 * Decompiled with CFR 0.152.
 */
package ivorius.ivtoolkit.rendering.grid;

import ivorius.ivtoolkit.rendering.Icon;
import java.util.Collection;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.EnumFacing;

public class CubeMesh {
    public static void renderSides(Collection<EnumFacing> sides, double x1, double y1, double z1, double x2, double y2, double z2, Icon icon) {
        for (EnumFacing direction : sides) {
            CubeMesh.renderSide(direction, x1, y1, z1, x2, y2, z2, icon);
        }
    }

    public static void renderSide(EnumFacing side, double x1, double y1, double z1, double x2, double y2, double z2, Icon icon) {
        switch (side) {
            case NORTH: {
                CubeMesh.renderNorth(x1, y1, x2, y2, z1, icon);
                break;
            }
            case EAST: {
                CubeMesh.renderEast(z1, y1, z2, y2, x2, icon);
                break;
            }
            case SOUTH: {
                CubeMesh.renderSouth(x1, y1, x2, y2, z2, icon);
                break;
            }
            case WEST: {
                CubeMesh.renderWest(z1, y1, z2, y2, x1, icon);
                break;
            }
            case UP: {
                CubeMesh.renderUp(x1, z1, x2, z2, y2, icon);
                break;
            }
            case DOWN: {
                CubeMesh.renderDown(x1, z1, x2, z2, y1, icon);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public static void renderNorth(double x1, double y1, double x2, double y2, double z, Icon icon) {
        BufferBuilder renderer = Tessellator.func_178181_a().func_178180_c();
        renderer.func_181662_b(x1, y1, z).func_187315_a((double)icon.getMinU(), (double)icon.getMinV()).func_181675_d();
        renderer.func_181662_b(x1, y2, z).func_187315_a((double)icon.getMaxU(), (double)icon.getMinV()).func_181675_d();
        renderer.func_181662_b(x2, y2, z).func_187315_a((double)icon.getMaxU(), (double)icon.getMaxV()).func_181675_d();
        renderer.func_181662_b(x2, y1, z).func_187315_a((double)icon.getMinU(), (double)icon.getMaxV()).func_181675_d();
    }

    public static void renderEast(double z1, double y1, double z2, double y2, double x, Icon icon) {
        BufferBuilder renderer = Tessellator.func_178181_a().func_178180_c();
        renderer.func_181662_b(x, y1, z1).func_187315_a((double)icon.getMinU(), (double)icon.getMinV()).func_181675_d();
        renderer.func_181662_b(x, y2, z1).func_187315_a((double)icon.getMinU(), (double)icon.getMaxV()).func_181675_d();
        renderer.func_181662_b(x, y2, z2).func_187315_a((double)icon.getMaxU(), (double)icon.getMaxV()).func_181675_d();
        renderer.func_181662_b(x, y1, z2).func_187315_a((double)icon.getMaxU(), (double)icon.getMinV()).func_181675_d();
    }

    public static void renderSouth(double x1, double y1, double x2, double y2, double z, Icon icon) {
        BufferBuilder renderer = Tessellator.func_178181_a().func_178180_c();
        renderer.func_181662_b(x1, y1, z).func_187315_a((double)icon.getMinU(), (double)icon.getMinV()).func_181675_d();
        renderer.func_181662_b(x2, y1, z).func_187315_a((double)icon.getMinU(), (double)icon.getMaxV()).func_181675_d();
        renderer.func_181662_b(x2, y2, z).func_187315_a((double)icon.getMaxU(), (double)icon.getMaxV()).func_181675_d();
        renderer.func_181662_b(x1, y2, z).func_187315_a((double)icon.getMaxU(), (double)icon.getMinV()).func_181675_d();
    }

    public static void renderWest(double z1, double y1, double z2, double y2, double x, Icon icon) {
        BufferBuilder renderer = Tessellator.func_178181_a().func_178180_c();
        renderer.func_181662_b(x, y1, z1).func_187315_a((double)icon.getMinU(), (double)icon.getMinV()).func_181675_d();
        renderer.func_181662_b(x, y1, z2).func_187315_a((double)icon.getMaxU(), (double)icon.getMinV()).func_181675_d();
        renderer.func_181662_b(x, y2, z2).func_187315_a((double)icon.getMaxU(), (double)icon.getMaxV()).func_181675_d();
        renderer.func_181662_b(x, y2, z1).func_187315_a((double)icon.getMinU(), (double)icon.getMaxV()).func_181675_d();
    }

    public static void renderUp(double x1, double z1, double x2, double z2, double y, Icon icon) {
        BufferBuilder renderer = Tessellator.func_178181_a().func_178180_c();
        renderer.func_181662_b(x1, y, z1).func_187315_a((double)icon.getMinU(), (double)icon.getMinV()).func_181675_d();
        renderer.func_181662_b(x1, y, z2).func_187315_a((double)icon.getMinU(), (double)icon.getMaxV()).func_181675_d();
        renderer.func_181662_b(x2, y, z2).func_187315_a((double)icon.getMaxU(), (double)icon.getMaxV()).func_181675_d();
        renderer.func_181662_b(x2, y, z1).func_187315_a((double)icon.getMaxU(), (double)icon.getMinV()).func_181675_d();
    }

    public static void renderDown(double x1, double z1, double x2, double z2, double y, Icon icon) {
        BufferBuilder renderer = Tessellator.func_178181_a().func_178180_c();
        renderer.func_181662_b(x1, y, z1).func_187315_a((double)icon.getMinU(), (double)icon.getMinV()).func_181675_d();
        renderer.func_181662_b(x2, y, z1).func_187315_a((double)icon.getMaxU(), (double)icon.getMinV()).func_181675_d();
        renderer.func_181662_b(x2, y, z2).func_187315_a((double)icon.getMaxU(), (double)icon.getMaxV()).func_181675_d();
        renderer.func_181662_b(x1, y, z2).func_187315_a((double)icon.getMinU(), (double)icon.getMaxV()).func_181675_d();
    }
}

