/*
 * Decompiled with CFR 0.152.
 */
package ivorius.ivtoolkit.maze.components;

import com.google.common.collect.Lists;
import ivorius.ivtoolkit.IvToolkit;
import ivorius.ivtoolkit.maze.components.ConnectionStrategy;
import ivorius.ivtoolkit.maze.components.MazeComponents;
import ivorius.ivtoolkit.maze.components.MazePassage;
import ivorius.ivtoolkit.maze.components.MazePredicate;
import ivorius.ivtoolkit.maze.components.MazeRoom;
import ivorius.ivtoolkit.maze.components.MorphingMazeComponent;
import ivorius.ivtoolkit.maze.components.MultiMazeComponent;
import ivorius.ivtoolkit.maze.components.PlacedMazeComponent;
import ivorius.ivtoolkit.maze.components.ShiftedMazeComponent;
import ivorius.ivtoolkit.maze.components.WeightedMazeComponent;
import ivorius.ivtoolkit.random.WeightedSelector;
import ivorius.ivtoolkit.random.WeightedShuffler;
import ivorius.ivtoolkit.util.IvFunctions;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.ToDoubleFunction;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Triple;

public class MazeComponentConnector {
    public static int INFINITE_REVERSES = -1;

    public static <M extends WeightedMazeComponent<C>, C> List<PlacedMazeComponent<M, C>> connect(MorphingMazeComponent<C> maze, List<M> components, ConnectionStrategy<C> connectionStrategy, MazePredicate<C> predicate, Random random, int reverses) {
        List multis = IvFunctions.group(components, c -> Triple.of(c.rooms(), c.exits(), c.reachability())).stream().map(c -> new MultiMazeComponent(Lists.newArrayList((Iterable)c))).collect(Collectors.toList());
        return MazeComponentConnector.connectMulti(maze, multis, connectionStrategy, predicate, random, reverses).stream().map(placed -> ((MultiMazeComponent)placed.component()).place(placed.shift(), random)).collect(Collectors.toList());
    }

    protected static <M extends MultiMazeComponent<MO, C>, MO extends WeightedMazeComponent<C>, C> List<PlacedMazeComponent<M, C>> connectMulti(MorphingMazeComponent<C> maze, List<M> components, ConnectionStrategy<C> connectionStrategy, MazePredicate<C> predicate, Random random, int reverses) {
        ArrayList<ReverseInfo> placeOrder = new ArrayList<ReverseInfo>();
        ReverseInfo reversing = null;
        ArrayList<PlacedMazeComponent<M, C>> result = new ArrayList<PlacedMazeComponent<M, C>>();
        LinkedList exitStack = new LinkedList();
        Predicate<ShiftedMazeComponent> componentPredicate = ((Predicate<ShiftedMazeComponent>)input -> !MazeComponents.overlap(maze, input)).and(input -> predicate.canPlace(maze, input));
        MazeComponentConnector.addAllExits(predicate, exitStack, maze.exits().entrySet(), random);
        while (exitStack.size() > 0) {
            if (reversing == null) {
                if (maze.rooms().contains(exitStack.peekLast().getLeft())) {
                    exitStack.removeLast();
                    continue;
                }
                reversing = new ReverseInfo();
                reversing.exitStack = (LinkedList)exitStack.clone();
                reversing.maze = maze.copy();
                reversing.shuffleSeed = random.nextLong();
            } else {
                predicate.willUnplace(maze, reversing.placed);
                exitStack = (LinkedList)reversing.exitStack.clone();
                maze.set(reversing.maze);
                predicate.didUnplace(maze, reversing.placed);
                result.remove(result.size() - 1);
            }
            Triple triple = (Triple)exitStack.removeLast();
            MazeRoom room = (MazeRoom)triple.getLeft();
            MazePassage exit = (MazePassage)((Object)triple.getMiddle());
            Object connection = triple.getRight();
            ToDoubleFunction<ShiftedMazeComponent> weightFunction = shifted -> ((MultiMazeComponent)shifted.getComponent()).getWeight() * (double)MazeComponents.connectWeight(maze, shifted, connectionStrategy);
            List shiftedComponents = components.stream().flatMap(MazeComponents.shiftAllFunction(exit, connection, connectionStrategy)).map(input -> new WeightedSelector.SimpleItem<ShiftedMazeComponent>(weightFunction.applyAsDouble((ShiftedMazeComponent)input), (ShiftedMazeComponent)input)).filter(w -> w.getWeight() >= 0.0).collect(Collectors.toCollection(ArrayList::new));
            ShiftedMazeComponent placing = null;
            if (reversing.triedIndices > shiftedComponents.size()) {
                throw new RuntimeException("Maze component selection not static.");
            }
            if (reversing.triedIndices < shiftedComponents.size()) {
                Iterator shuffler = WeightedShuffler.iterateShuffled(new Random(reversing.shuffleSeed), shiftedComponents);
                for (int i = 0; i < reversing.triedIndices; ++i) {
                    shuffler.next();
                }
                for (ShiftedMazeComponent comp : () -> shuffler) {
                    ++reversing.triedIndices;
                    if (!componentPredicate.test(comp)) continue;
                    placing = comp;
                    break;
                }
            }
            if (placing == null) {
                if (reverses == 0) {
                    IvToolkit.logger.warn("Did not find fitting component for maze!");
                    IvToolkit.logger.warn("Suggested: X with exits " + maze.exits().entrySet().stream().filter(MazeComponentConnector.entryConnectsTo(room)).collect(Collectors.toList()));
                    reversing = null;
                    continue;
                }
                if (reverses > 0) {
                    --reverses;
                }
                if (placeOrder.size() == 0) {
                    IvToolkit.logger.warn("Maze is not completable!");
                    IvToolkit.logger.warn("Switching to flawed mode.");
                    reverses = 0;
                    reversing = null;
                    continue;
                }
                reversing = (ReverseInfo)placeOrder.remove(placeOrder.size() - 1);
                continue;
            }
            reversing.placed = placing;
            predicate.willPlace(maze, placing);
            MazeComponentConnector.addAllExits(predicate, exitStack, placing.exits().entrySet(), random);
            maze.add(placing);
            result.add(new PlacedMazeComponent((WeightedMazeComponent)placing.getComponent(), placing.getShift()));
            predicate.didPlace(maze, placing);
            placeOrder.add(reversing);
            reversing = null;
        }
        return result;
    }

    private static Predicate<Map.Entry<MazePassage, ?>> entryConnectsTo(MazeRoom finalRoom) {
        return input -> input != null && ((MazePassage)((Object)((Object)input.getKey()))).has(finalRoom);
    }

    private static <M extends WeightedMazeComponent<C>, C> void addAllExits(MazePredicate<C> placementStrategy, List<Triple<MazeRoom, MazePassage, C>> exitStack, Set<Map.Entry<MazePassage, C>> entries, Random random) {
        for (Map.Entry<MazePassage, C> exit : entries) {
            MazePassage connection = exit.getKey();
            C c = exit.getValue();
            if (placementStrategy.isDirtyConnection(connection.getLeft(), connection.getRight(), c)) {
                MazeComponentConnector.addRandomly(exitStack, random, connection, c, connection.getLeft());
            }
            if (!placementStrategy.isDirtyConnection(connection.getRight(), connection.getLeft(), c)) continue;
            MazeComponentConnector.addRandomly(exitStack, random, connection, c, connection.getRight());
        }
    }

    private static <C> void addRandomly(List<Triple<MazeRoom, MazePassage, C>> exitStack, Random random, MazePassage connection, C c, MazeRoom left) {
        exitStack.add(random.nextInt(exitStack.size() + 1), Triple.of((Object)left, (Object)((Object)connection), c));
    }

    private static class ReverseInfo<M extends WeightedMazeComponent<C>, C> {
        public long shuffleSeed;
        public int triedIndices;
        public MorphingMazeComponent<C> maze;
        public LinkedList<Triple<MazeRoom, MazePassage, C>> exitStack;
        public ShiftedMazeComponent<M, C> placed;

        private ReverseInfo() {
        }
    }
}

