/*
 * Decompiled with CFR 0.152.
 */
package logictechcorp.libraryex.world.generation.trait;

import com.electronwill.nightconfig.core.Config;
import java.util.Random;
import java.util.function.Consumer;
import logictechcorp.libraryex.utility.ConfigHelper;
import logictechcorp.libraryex.world.generation.trait.BiomeTrait;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class BiomeTraitBoulder
extends BiomeTrait {
    protected IBlockState blockToSpawn;
    protected IBlockState blockToTarget;
    protected int boulderRadius;

    protected BiomeTraitBoulder(Builder builder) {
        super(builder);
        this.blockToSpawn = builder.blockToSpawn;
        this.blockToTarget = builder.blockToTarget;
        this.boulderRadius = builder.boulderRadius;
    }

    public static BiomeTraitBoulder create(Consumer<Builder> consumer) {
        Builder builder = new Builder();
        consumer.accept(builder);
        return builder.create();
    }

    @Override
    public void readFromConfig(Config config) {
        super.readFromConfig(config);
        this.blockToSpawn = ConfigHelper.getBlockState(config, "blockToSpawn");
        this.blockToTarget = ConfigHelper.getBlockState(config, "blockToTarget");
        this.boulderRadius = (Integer)config.getOrElse("boulderRadius", (Object)4);
    }

    @Override
    public void writeToConfig(Config config) {
        super.writeToConfig(config);
        ConfigHelper.setBlockState(config, "blockToSpawn", this.blockToSpawn);
        ConfigHelper.setBlockState(config, "blockToTarget", this.blockToTarget);
        config.add("boulderRadius", (Object)this.boulderRadius);
    }

    @Override
    public boolean generate(World world, BlockPos pos, Random random) {
        if (this.blockToSpawn == null || this.blockToTarget == null) {
            return false;
        }
        while (true) {
            IBlockState state;
            if (pos.func_177956_o() <= 3 || !world.func_175623_d(pos.func_177977_b()) && this.blockToTarget == (state = world.func_180495_p(pos.func_177977_b()))) {
                if (pos.func_177956_o() <= 3) {
                    return false;
                }
                for (int i = 0; this.boulderRadius >= 0 && i < 3; ++i) {
                    int posX = this.boulderRadius + random.nextInt(2);
                    int posY = this.boulderRadius + random.nextInt(2);
                    int posZ = this.boulderRadius + random.nextInt(2);
                    float distance = (float)(posX + posY + posZ) * 0.333f + 0.5f;
                    for (BlockPos posLocal : BlockPos.func_177980_a((BlockPos)pos.func_177982_a(-posX, -posY, -posZ), (BlockPos)pos.func_177982_a(posX, posY, posZ))) {
                        if (!(posLocal.func_177951_i((Vec3i)pos) <= (double)(distance * distance))) continue;
                        world.func_180501_a(posLocal, this.blockToSpawn, 4);
                    }
                    pos = pos.func_177982_a(-(this.boulderRadius + 1) + random.nextInt(2 + this.boulderRadius * 2), 0 - random.nextInt(2), -(this.boulderRadius + 1) + random.nextInt(2 + this.boulderRadius * 2));
                }
                return true;
            }
            pos = pos.func_177977_b();
        }
    }

    public static class Builder
    extends BiomeTrait.Builder {
        private IBlockState blockToSpawn = Blocks.field_150341_Y.func_176223_P();
        private IBlockState blockToTarget = Blocks.field_150349_c.func_176223_P();
        private int boulderRadius = 4;

        public Builder blockToSpawn(IBlockState blockToSpawn) {
            this.blockToSpawn = blockToSpawn;
            return this;
        }

        public Builder blockToTarget(IBlockState blockToTarget) {
            this.blockToTarget = blockToTarget;
            return this;
        }

        public Builder boulderRadius(int boulderRadius) {
            this.boulderRadius = boulderRadius;
            return this;
        }

        public BiomeTraitBoulder create() {
            return new BiomeTraitBoulder(this);
        }
    }
}

