/*
 * Decompiled with CFR 0.152.
 */
package logictechcorp.libraryex.block;

import java.util.Collection;
import java.util.List;
import java.util.Random;
import logictechcorp.libraryex.block.BlockMod;
import logictechcorp.libraryex.block.property.BlockProperties;
import logictechcorp.libraryex.utility.RandomHelper;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatBase;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class BlockModLeaf
extends BlockMod
implements IShearable {
    public static final PropertyBool DECAY = PropertyBool.func_177716_a((String)"decay");
    private int[] surroundings;

    public BlockModLeaf(ResourceLocation registryName, BlockProperties properties) {
        super(registryName, properties);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)DECAY, (Comparable)Boolean.valueOf(true)));
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return Blocks.field_150362_t.func_180664_k();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return Blocks.field_150362_t.func_176225_a(state, world, pos, side);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World world, BlockPos pos, Random random) {
        if (world.func_175727_C(pos.func_177984_a()) && !world.func_180495_p(pos.func_177977_b()).isSideSolid((IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP) && random.nextInt(15) == 1) {
            world.func_175688_a(EnumParticleTypes.DRIP_WATER, (double)((float)pos.func_177958_n() + random.nextFloat()), (double)pos.func_177956_o() - 0.05, (double)((float)pos.func_177952_p() + random.nextFloat()), 0.0, 0.0, 0.0, new int[0]);
        }
    }

    public boolean func_149662_c(IBlockState state) {
        return Blocks.field_150362_t.func_149662_c(state);
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random random) {
        if (!world.field_72995_K && ((Boolean)state.func_177229_b((IProperty)DECAY)).booleanValue()) {
            int posX = pos.func_177958_n();
            int posY = pos.func_177956_o();
            int posZ = pos.func_177952_p();
            if (this.surroundings == null) {
                this.surroundings = new int[32768];
            }
            if (world.func_175707_a(new BlockPos(posX - 5, posY - 5, posZ - 5), new BlockPos(posX + 5, posY + 5, posZ + 5))) {
                BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
                for (int offsetX = -4; offsetX <= 4; ++offsetX) {
                    for (int offsetY = -4; offsetY <= 4; ++offsetY) {
                        for (int offsetZ = -4; offsetZ <= 4; ++offsetZ) {
                            IBlockState testState = world.func_180495_p((BlockPos)mutableBlockPos.func_181079_c(posX + offsetX, posY + offsetY, posZ + offsetZ));
                            Block testBlock = testState.func_177230_c();
                            if (!testBlock.canSustainLeaves(testState, (IBlockAccess)world, (BlockPos)mutableBlockPos.func_181079_c(posX + offsetX, posY + offsetY, posZ + offsetZ))) {
                                if (testBlock.isLeaves(testState, (IBlockAccess)world, (BlockPos)mutableBlockPos.func_181079_c(posX + offsetX, posY + offsetY, posZ + offsetZ))) {
                                    this.surroundings[(offsetX + 16) * 1024 + (offsetY + 16) * 32 + offsetZ + 16] = -2;
                                    continue;
                                }
                                this.surroundings[(offsetX + 16) * 1024 + (offsetY + 16) * 32 + offsetZ + 16] = -1;
                                continue;
                            }
                            this.surroundings[(offsetX + 16) * 1024 + (offsetY + 16) * 32 + offsetZ + 16] = 0;
                        }
                    }
                }
                for (int check = 1; check <= 4; ++check) {
                    for (int localX = -4; localX <= 4; ++localX) {
                        for (int localY = -4; localY <= 4; ++localY) {
                            for (int localZ = -4; localZ <= 4; ++localZ) {
                                if (this.surroundings[(localX + 16) * 1024 + (localY + 16) * 32 + localZ + 16] != check - 1) continue;
                                if (this.surroundings[(localX + 16 - 1) * 1024 + (localY + 16) * 32 + localZ + 16] == -2) {
                                    this.surroundings[(localX + 16 - 1) * 1024 + (localY + 16) * 32 + localZ + 16] = check;
                                }
                                if (this.surroundings[(localX + 16 + 1) * 1024 + (localY + 16) * 32 + localZ + 16] == -2) {
                                    this.surroundings[(localX + 16 + 1) * 1024 + (localY + 16) * 32 + localZ + 16] = check;
                                }
                                if (this.surroundings[(localX + 16) * 1024 + (localY + 16 - 1) * 32 + localZ + 16] == -2) {
                                    this.surroundings[(localX + 16) * 1024 + (localY + 16 - 1) * 32 + localZ + 16] = check;
                                }
                                if (this.surroundings[(localX + 16) * 1024 + (localY + 16 + 1) * 32 + localZ + 16] == -2) {
                                    this.surroundings[(localX + 16) * 1024 + (localY + 16 + 1) * 32 + localZ + 16] = check;
                                }
                                if (this.surroundings[(localX + 16) * 1024 + (localY + 16) * 32 + (localZ + 16 - 1)] == -2) {
                                    this.surroundings[(localX + 16) * 1024 + (localY + 16) * 32 + (localZ + 16 - 1)] = check;
                                }
                                if (this.surroundings[(localX + 16) * 1024 + (localY + 16) * 32 + localZ + 16 + 1] != -2) continue;
                                this.surroundings[(localX + 16) * 1024 + (localY + 16) * 32 + localZ + 16 + 1] = check;
                            }
                        }
                    }
                }
            }
            if (this.surroundings[16912] >= 0) {
                world.func_180501_a(pos, state.func_177226_a((IProperty)DECAY, (Comparable)Boolean.valueOf(false)), 4);
            } else {
                this.destroy(world, pos);
            }
        }
    }

    public int func_149745_a(Random random) {
        return random.nextInt(20) == 0 ? 1 : 0;
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        int posZ;
        int posY;
        int posX = pos.func_177958_n();
        if (world.func_175707_a(new BlockPos(posX - 2, (posY = pos.func_177956_o()) - 2, (posZ = pos.func_177952_p()) - 2), new BlockPos(posX + 2, posY + 2, posZ + 2))) {
            for (int offsetX = -1; offsetX <= 1; ++offsetX) {
                for (int offsetY = -1; offsetY <= 1; ++offsetY) {
                    for (int offsetZ = -1; offsetZ <= 1; ++offsetZ) {
                        BlockPos newPos = pos.func_177982_a(offsetX, offsetY, offsetZ);
                        IBlockState checkState = world.func_180495_p(newPos);
                        if (!checkState.func_177230_c().isLeaves(checkState, (IBlockAccess)world, newPos)) continue;
                        checkState.func_177230_c().beginLeavesDecay(checkState, world, newPos);
                    }
                }
            }
        }
    }

    public boolean func_176214_u(IBlockState state) {
        return false;
    }

    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity tileEntity, ItemStack stack) {
        if (!world.field_72995_K && stack.func_77973_b() == Items.field_151097_aZ) {
            StatBase statBase = StatList.func_188055_a((Block)this);
            if (statBase != null) {
                player.func_71029_a(statBase);
            }
            BlockModLeaf.func_180635_a((World)world, (BlockPos)pos, (ItemStack)new ItemStack(Item.func_150898_a((Block)this)));
        } else {
            super.func_180657_a(world, player, pos, state, tileEntity, stack);
        }
    }

    public boolean isShearable(ItemStack item, IBlockAccess world, BlockPos pos) {
        return true;
    }

    public List<ItemStack> onSheared(ItemStack item, IBlockAccess world, BlockPos pos, int fortune) {
        return NonNullList.func_191197_a((int)1, (Object)new ItemStack((Block)this));
    }

    public boolean isLeaves(IBlockState state, IBlockAccess world, BlockPos pos) {
        return true;
    }

    public void beginLeavesDecay(IBlockState state, World world, BlockPos pos) {
        if (!((Boolean)state.func_177229_b((IProperty)DECAY)).booleanValue()) {
            world.func_180501_a(pos, state.func_177226_a((IProperty)DECAY, (Comparable)Boolean.valueOf(true)), 4);
        }
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ItemStack drop;
        Random random = world instanceof World ? ((World)world).field_73012_v : RandomHelper.getRandom();
        int chance = this.getRareDropChance();
        if (fortune > 0 && (chance -= 2 << fortune) < 10) {
            chance = 10;
        }
        if (random.nextInt(chance) == 0 && !(drop = new ItemStack(this.func_180660_a(state, random, fortune), 1, this.func_180651_a(state))).func_190926_b()) {
            drops.add((Object)drop);
        }
        chance = 200;
        if (fortune > 0 && (chance -= 10 << fortune) < 40) {
            chance = 40;
        }
        this.captureDrops(true);
        if (world instanceof World) {
            this.dropRareItem((World)world, pos, chance);
        }
        drops.addAll((Collection)this.captureDrops(false));
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)DECAY, (Comparable)Boolean.valueOf(meta != 0));
    }

    public int func_176201_c(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)DECAY) != false ? 1 : 0;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{DECAY});
    }

    protected void destroy(World world, BlockPos pos) {
        this.func_176226_b(world, pos, world.func_180495_p(pos), 0);
        world.func_175698_g(pos);
    }

    public abstract Item func_180660_a(IBlockState var1, Random var2, int var3);

    protected abstract void dropRareItem(World var1, BlockPos var2, int var3);

    protected abstract int getRareDropChance();
}

