/*
 * Decompiled with CFR 0.152.
 */
package com.fuzs.letmesleep.handler;

import com.fuzs.letmesleep.LetMeSleep;
import com.fuzs.letmesleep.handler.ConfigBuildHandler;
import com.fuzs.letmesleep.helper.ClearPotionsHelper;
import com.fuzs.letmesleep.util.ClearPotions;
import com.fuzs.letmesleep.util.SetSpawnPoint;
import java.util.Optional;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.entity.player.PlayerWakeUpEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class WakeUpHandler {
    @SubscribeEvent
    public void onPlayerWake(PlayerWakeUpEvent evt) {
        if (!evt.getEntityPlayer().field_70170_p.field_72995_K) {
            boolean flag;
            EntityPlayerMP player = (EntityPlayerMP)evt.getEntityPlayer();
            WorldServer world = (WorldServer)player.field_70170_p;
            BlockPos spawn = player.getBedLocation(player.field_71093_bK);
            boolean bl = flag = !ConfigBuildHandler.generalConfig.setSpawnAlways && spawn != null && EntityPlayer.func_180467_a((World)world, (BlockPos)spawn, (boolean)false) != null;
            if (ConfigBuildHandler.generalConfig.setSpawn != SetSpawnPoint.VANILLA || flag) {
                IBlockState iblockstate;
                IBlockState iBlockState = iblockstate = player.field_71081_bT == null ? null : player.field_70170_p.func_180495_p(player.field_71081_bT);
                if (player.field_71081_bT != null && iblockstate.func_177230_c().isBed(iblockstate, (IBlockAccess)player.field_70170_p, player.field_71081_bT, (Entity)player)) {
                    iblockstate.func_177230_c().setBedOccupied((IBlockAccess)player.field_70170_p, player.field_71081_bT, (EntityPlayer)player, false);
                    BlockPos blockpos = iblockstate.func_177230_c().getBedSpawnPosition(iblockstate, (IBlockAccess)player.field_70170_p, player.field_71081_bT, (EntityPlayer)player);
                    if (blockpos == null) {
                        blockpos = player.field_71081_bT.func_177984_a();
                    }
                    player.func_70107_b((double)((float)blockpos.func_177958_n() + 0.5f), (double)((float)blockpos.func_177956_o() + 0.1f), (double)((float)blockpos.func_177952_p() + 0.5f));
                }
                player.field_71081_bT = null;
            }
            if (evt.shouldSetSpawn() && !evt.wakeImmediately() && !evt.updateWorld()) {
                ClearPotions clearPotions;
                if (ConfigBuildHandler.wakeUpConfig.heal) {
                    int i = ConfigBuildHandler.wakeUpConfig.healAmount;
                    player.func_70691_i(i == 0 ? player.func_110138_aP() : (float)i);
                }
                if (ConfigBuildHandler.wakeUpConfig.starve) {
                    int j = ConfigBuildHandler.wakeUpConfig.starveAmount;
                    int k = player.func_71024_bL().func_75116_a();
                    player.func_71024_bL().func_75114_a(MathHelper.func_76125_a((int)(k - (j == 0 ? k : j)), (int)0, (int)20));
                }
                if ((clearPotions = ConfigBuildHandler.wakeUpConfig.clearPotions) == ClearPotions.BOTH) {
                    player.func_70674_bp();
                } else if (clearPotions == ClearPotions.POSITIVE) {
                    ClearPotionsHelper.clearActivePotions((EntityLivingBase)player, true);
                } else if (clearPotions == ClearPotions.NEGATIVE) {
                    ClearPotionsHelper.clearActivePotions((EntityLivingBase)player, false);
                }
                if (ConfigBuildHandler.wakeUpConfig.effects) {
                    this.applyPotions(player);
                }
            }
        }
    }

    private void applyPotions(EntityPlayerMP player) {
        String[] effects;
        for (String s : effects = ConfigBuildHandler.wakeUpConfig.potionEffects) {
            String error = "Potion effect to be applied on waking up has been specified incorrectly!";
            String[] values = s.split(",");
            Optional<Object> potionOptional = Optional.empty();
            int duration = 0;
            int amplifier = 0;
            boolean showParticles = false;
            if (values.length > 0) {
                String[] name = values[0].split(":");
                if (name.length > 1) {
                    ResourceLocation location = new ResourceLocation(name[0], name[1]);
                    potionOptional = Optional.ofNullable(ForgeRegistries.POTIONS.getValue(location));
                } else {
                    LetMeSleep.LOGGER.error(error);
                }
            } else {
                LetMeSleep.LOGGER.error(error);
            }
            try {
                if (values.length > 1) {
                    duration = Integer.parseInt(values[1]) * 20;
                } else {
                    LetMeSleep.LOGGER.error(error);
                }
                if (values.length > 2) {
                    amplifier = Integer.parseInt(values[2]);
                }
            }
            catch (NumberFormatException e) {
                LetMeSleep.LOGGER.error(error, (Throwable)e);
            }
            if (values.length > 3) {
                boolean bl = showParticles = !Boolean.parseBoolean(values[3]);
            }
            if (!potionOptional.isPresent()) continue;
            PotionEffect potion = new PotionEffect((Potion)potionOptional.get(), duration, amplifier, false, showParticles);
            player.func_70690_d(potion);
        }
    }
}

