/*
 * Decompiled with CFR 0.152.
 */
package com.fuzs.letmesleep.handler;

import com.fuzs.letmesleep.handler.ConfigBuildHandler;
import com.fuzs.letmesleep.helper.ReflectionHelper;
import com.fuzs.letmesleep.helper.SetSpawnHelper;
import com.fuzs.letmesleep.network.NetworkHandler;
import com.fuzs.letmesleep.network.message.MessageRequestSpawn;
import com.fuzs.letmesleep.util.SetSpawnPoint;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.ChatLine;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiChat;
import net.minecraft.client.gui.GuiNewChat;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiSleepMP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.event.entity.player.PlayerSetSpawnEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.lwjgl.input.Mouse;

public class SetSpawnHandler {
    private final Minecraft mc = Minecraft.func_71410_x();

    @SubscribeEvent
    public void onSetSpawn(PlayerSetSpawnEvent evt) {
        boolean flag;
        boolean bl = flag = ConfigBuildHandler.generalConfig.setSpawn == SetSpawnPoint.BUTTON || ConfigBuildHandler.generalConfig.setSpawn == SetSpawnPoint.CHAT;
        if (flag && evt.getEntityPlayer().field_70170_p.field_72995_K && evt.getNewSpawn() != null && evt.isForced()) {
            MessageRequestSpawn message = new MessageRequestSpawn(evt.getNewSpawn());
            NetworkHandler.sendToServer(message);
        }
    }

    @SubscribeEvent
    public void onInitGuiPost(GuiScreenEvent.InitGuiEvent.Post evt) {
        if (evt.getGui() instanceof GuiSleepMP && this.mc.field_71439_g != null) {
            EntityPlayerSP player = this.mc.field_71439_g;
            BlockPos pos = player.field_71081_bT;
            if (pos != null && SetSpawnHelper.isNewSpawnAllowed(player.field_70170_p, (EntityPlayer)player, pos, SetSpawnPoint.BUTTON)) {
                GuiSleepMP screen = (GuiSleepMP)evt.getGui();
                GuiButton setSpawn = new GuiButton(5, screen.field_146294_l / 2 - 100, screen.field_146295_m - 64, 200, 20, new TextComponentTranslation("multiplayer.spawn.button", new Object[0]).func_150254_d());
                evt.getButtonList().add(setSpawn);
            }
        }
    }

    @SubscribeEvent
    public void onActionPerformed(GuiScreenEvent.ActionPerformedEvent.Post evt) {
        if (evt.getGui() instanceof GuiSleepMP && this.mc.field_71439_g != null) {
            EntityPlayerSP player = this.mc.field_71439_g;
            BlockPos pos = player.field_71081_bT;
            if (evt.getButton().field_146127_k == 5 && pos != null) {
                evt.getButton().field_146125_m = false;
                MessageRequestSpawn message = new MessageRequestSpawn(pos);
                NetworkHandler.sendToServer(message);
            }
        }
    }

    @SubscribeEvent
    public void onMouseClickedPre(GuiScreenEvent.MouseInputEvent.Pre evt) {
        ITextComponent itextcomponent;
        if (evt.getGui() instanceof GuiChat && Mouse.getEventButton() == 0 && (itextcomponent = this.mc.field_71456_v.func_146158_b().func_146236_a(Mouse.getX(), Mouse.getY())) != null) {
            evt.setCanceled(this.handleComponentClicked(itextcomponent));
        }
    }

    private boolean handleComponentClicked(ITextComponent itextcomponent) {
        if (itextcomponent != null) {
            ClickEvent clickevent = itextcomponent.func_150256_b().func_150235_h();
            if (!GuiScreen.func_146272_n() && clickevent != null && clickevent.func_150669_a() == ClickEvent.Action.CHANGE_PAGE) {
                EntityPlayerSP player = this.mc.field_71439_g;
                BlockPos pos = player.field_71081_bT;
                if (pos != null) {
                    MessageRequestSpawn message = new MessageRequestSpawn(pos);
                    NetworkHandler.sendToServer(message);
                    this.removeSpawnMessage();
                }
                return true;
            }
        }
        return false;
    }

    @SubscribeEvent
    public void onGuiOpen(GuiOpenEvent evt) {
        if (this.mc.field_71462_r instanceof GuiSleepMP) {
            this.removeSpawnMessage();
        }
    }

    private void removeSpawnMessage() {
        GuiNewChat chat = this.mc.field_71456_v.func_146158_b();
        List<ChatLine> chatLines = ReflectionHelper.getChatLines(chat);
        List<ChatLine> drawnChatLines = ReflectionHelper.getDrawnChatLines(chat);
        if (chatLines != null && drawnChatLines != null) {
            Optional.ofNullable(TextFormatting.func_110646_a((String)SetSpawnHelper.createRespawnMessage().func_150260_c())).ifPresent(template -> {
                chatLines.removeIf(chatline -> template.equals(TextFormatting.func_110646_a((String)chatline.func_151461_a().func_150260_c())));
                drawnChatLines.removeIf(chatline -> template.equals(TextFormatting.func_110646_a((String)chatline.func_151461_a().func_150260_c())));
            });
        }
    }
}

