/*
 * Decompiled with CFR 0.152.
 */
package com.fuzs.letmesleep.handler;

import com.fuzs.letmesleep.util.ClearPotions;
import com.fuzs.letmesleep.util.SetSpawnPoint;
import net.minecraftforge.common.config.Config;

@Config(modid="letmesleep")
public class ConfigBuildHandler {
    @Config.Name(value="general")
    public static GeneralConfig generalConfig = new GeneralConfig();
    @Config.Name(value="sleep_timings")
    public static SleepTimingsConfig sleepTimingsConfig = new SleepTimingsConfig();
    @Config.Name(value="sleeping_checks")
    public static SleepConfig sleepConfig = new SleepConfig();
    @Config.Name(value="wake_up_actions")
    public static WakeUpConfig wakeUpConfig = new WakeUpConfig();

    public static class WakeUpConfig {
        @Config.Name(value="Heal Player")
        @Config.Comment(value={"Should the player be healed when waking up."})
        public boolean heal = true;
        @Config.Name(value="Heal Amount")
        @Config.RangeInt(min=0)
        @Config.Comment(value={"Amount of health the player should be healed by. Set to 0 to fully heal."})
        public int healAmount = 0;
        @Config.Name(value="Loose Food")
        @Config.Comment(value={"Should the player loose some food after waking up."})
        public boolean starve = false;
        @Config.Name(value="Food Amount")
        @Config.Comment(value={"Amount of food to loose when waking up. Set to 0 to completely starve the player. Negative values will feed the player instead."})
        public int starveAmount = 3;
        @Config.Name(value="Clear Potions")
        @Config.Comment(value={"Clear potion effects after the player wakes up."})
        public ClearPotions clearPotions = ClearPotions.BOTH;
        @Config.Name(value="Apply Effects")
        @Config.Comment(value={"Should custom potion effects be applied to the player after waking up."})
        public boolean effects = false;
        @Config.Name(value="Effects To Apply")
        @Config.Comment(value={"Potion effects to be given to the player after waking up. Enter as \"modid:effect,duration,amplifier,hideParticles\", values are based on /effect command. Amplifier and hideParticles are optional."})
        public String[] potionEffects = new String[]{"minecraft:regeneration,30,0,false"};
        @Config.Name(value="Persistent Chat")
        @Config.Comment(value={"Keep chat open after waking up if it contains any text."})
        public boolean persistentChat = true;
    }

    public static class SleepConfig {
        @Config.Name(value="Range Check")
        @Config.Comment(value={"Check if the player is close enough to the bed."})
        public boolean rangeCheck = false;
        @Config.Name(value="Obstruction Check")
        @Config.Comment(value={"Check if the bed has enough open space above it."})
        public boolean obstructionCheck = true;
        @Config.Name(value="Monster Check")
        @Config.Comment(value={"Check if monsters are nearby."})
        public boolean monsterCheck = true;
        @Config.Name(value="Glowing Monsters")
        @Config.Comment(value={"Should monsters preventing the player from sleeping glow."})
        public boolean glow = true;
        @Config.Name(value="Glow Duration")
        @Config.Comment(value={"Duration in ticks for which the monsters nearby will glow."})
        @Config.RangeInt(min=0)
        public int glowDuration = 60;
        @Config.Name(value="Named Monsters")
        @Config.Comment(value={"Should named monsters prevent the player from sleeping."})
        public boolean namedMonsters = false;
        @Config.Name(value="Persistent Monsters")
        @Config.Comment(value={"Should persistent monsters (unable to despawn via a vanilla tag) prevent the player from sleeping."})
        public boolean persistentMonsters = false;
    }

    public static class SleepTimingsConfig {
        @Config.Name(value="Bedtime Start")
        @Config.Comment(value={"Time from when onwards sleeping in a bed is possible."})
        @Config.RangeInt(min=0, max=24000)
        public int bedtimeStart = 12541;
        @Config.Name(value="Bedtime End")
        @Config.Comment(value={"Time until when sleeping is possible."})
        @Config.RangeInt(min=0, max=24000)
        public int bedtimeEnd = 23458;
        @Config.Name(value="Sleep During Thunder")
        @Config.Comment(value={"Is going to bed during a thunderstorm permitted."})
        public boolean bedtimeThunder = true;
        @Config.Name(value="Sleep During Rain")
        @Config.Comment(value={"Is going to bed when it's raining permitted."})
        public boolean bedtimeRain = false;
        @Config.Name(value="Time 12h Format")
        @Config.Comment(value={"Use 12h format for status messages."})
        public boolean timeTwelve = false;
        @Config.Name(value="Clock Time Tooltip")
        @Config.Comment(value={"Add current time to the clock item tooltip."})
        public boolean timeClock = true;
        @Config.Name(value="Instant Sleeping")
        @Config.Comment(value={"Removes the falling asleep animation, so you wake up instantly after going to bed. Some options from \\\"Set Respawn Point\\\" will no longer be accessible then."})
        public boolean instantSleeping = false;
        @Config.Name(value="Wake Up Time")
        @Config.Comment(value={"Time being set after sleeping successfully."})
        @Config.RangeInt(min=0, max=24000)
        public int wakeUpTime = 0;
    }

    public static class GeneralConfig {
        @Config.Name(value="Set Respawn Point")
        @Config.Comment(value={"How beds should be used for setting the respawn point."})
        public SetSpawnPoint setSpawn = SetSpawnPoint.INTERACT;
        @Config.Name(value="Always Set Spawn")
        @Config.Comment(value={"Disable to prevent setting a new respawn point when there is already one present at another bed. The other bed will have to be removed to set a new respawn point."})
        public boolean setSpawnAlways = true;
        @Config.Name(value="Spawn Monster")
        @Config.Comment(value={"Spawn a monster and wake player when sleeping in an insufficiently lit area."})
        public boolean spawnMonster = true;
        @Config.Name(value="Spawn Monster Chance")
        @Config.Comment(value={"Chance to spawn a monster, higher numbers make it more likely to happen."})
        @Config.RangeInt(min=0)
        public int spawnMonsterChance = 5;
    }
}

