/*
 * Decompiled with CFR 0.152.
 */
package com.fuzs.letmesleep.handler;

import com.fuzs.letmesleep.handler.ConfigBuildHandler;
import com.fuzs.letmesleep.helper.ReflectionHelper;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DungeonHooks;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class BadDreamHandler {
    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent evt) {
        if (evt.phase != TickEvent.Phase.START || evt.world.field_72995_K) {
            return;
        }
        WorldServer world = (WorldServer)evt.world;
        if (!(!world.func_73056_e() || ConfigBuildHandler.generalConfig.spawnMonster && this.performSleepSpawning((World)world, world.field_73010_i, world.func_175659_aa().func_151525_a()))) {
            if (world.func_82736_K().func_82766_b("doDaylightCycle")) {
                long dayTime = world.func_72820_D() + 24000L;
                long wakeUpTime = ConfigBuildHandler.sleepTimingsConfig.wakeUpTime;
                world.func_72877_b(dayTime - (24000L - wakeUpTime + dayTime) % 24000L);
            }
            this.wakeAllPlayers(world);
        }
    }

    private boolean performSleepSpawning(World world, List<? extends EntityPlayer> playerlist, int difficulty) {
        boolean flag = false;
        for (EntityPlayer entityPlayer : playerlist) {
            if (entityPlayer.func_184812_l_() || entityPlayer.func_175149_v() || entityPlayer.field_71081_bT == null) continue;
            boolean flag1 = false;
            BlockPos bedPos = entityPlayer.field_71081_bT;
            for (int i = 0; i < difficulty * ConfigBuildHandler.generalConfig.spawnMonsterChance && !flag1; ++i) {
                PathPoint pathpoint;
                Entity entity;
                boolean lightCheck;
                EnumFacing direction = ((EnumFacing)world.func_180495_p(bedPos).func_177229_b((IProperty)BlockHorizontal.field_185512_D)).func_176734_d();
                double d1 = world.field_73012_v.nextDouble() - world.field_73012_v.nextDouble();
                double d2 = world.field_73012_v.nextDouble() - world.field_73012_v.nextDouble();
                double xCoord = (double)bedPos.func_177958_n() + d1 * (2.0 + (double)(Math.signum(d1) == (double)Math.signum(direction.func_82601_c()) ? Math.abs(direction.func_82601_c()) : 0)) + 0.5;
                double yCoord = bedPos.func_177956_o() + world.field_73012_v.nextInt(3) - 1;
                double zCoord = (double)bedPos.func_177952_p() + d2 * (2.0 + (double)(Math.signum(d2) == (double)Math.signum(direction.func_82599_e()) ? Math.abs(direction.func_82599_e()) : 0)) + 0.5;
                BlockPos pos = new BlockPos(xCoord, yCoord, zCoord);
                boolean solidCheck = world.func_180495_p(pos.func_177977_b()).isSideSolid((IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP);
                boolean bl = lightCheck = world.func_175671_l(pos) < 8;
                if (!solidCheck || !lightCheck || !((entity = (Entity)Optional.ofNullable(ForgeRegistries.ENTITIES.getValue(DungeonHooks.getRandomDungeonMob((Random)world.field_73012_v))).map(entityEntry -> entityEntry.newInstance(world)).orElse(null)) instanceof EntityLiving)) continue;
                EntityLiving mob = (EntityLiving)entity;
                mob.func_70012_b(xCoord, yCoord, zCoord, world.field_73012_v.nextFloat() * 360.0f, 0.0f);
                if (!entity.field_70170_p.func_184144_a(entity, entity.func_174813_aQ()).isEmpty() || entity.field_70170_p.func_72953_d(entity.func_174813_aQ())) continue;
                mob.field_70122_E = true;
                Path path = mob.func_70661_as().func_75494_a((Entity)entityPlayer);
                if (path == null || path.func_75874_d() <= 1 || (pathpoint = path.func_75870_c()) == null || !world.func_175636_b((double)pathpoint.field_75839_a, (double)pathpoint.field_75837_b, (double)pathpoint.field_75838_c, 1.5)) continue;
                mob.func_180482_a(world.func_175649_E(new BlockPos(entity)), null);
                mob.func_70624_b((EntityLivingBase)entityPlayer);
                mob.func_70642_aH();
                this.addEntityPassengers(world, entity);
                entityPlayer.func_70999_a(true, false, false);
                flag1 = true;
                flag = true;
            }
        }
        return flag;
    }

    private void addEntityPassengers(World world, Entity entity) {
        if (world.func_72838_d(entity)) {
            for (Entity e : entity.func_184188_bt()) {
                this.addEntityPassengers(world, e);
            }
        }
    }

    private void wakeAllPlayers(WorldServer world) {
        Method wakeAllPlayers = ReflectionHelper.getWakeAllPlayers();
        if (wakeAllPlayers != null) {
            try {
                wakeAllPlayers.invoke((Object)world, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }
}

