/*
 * Decompiled with CFR 0.152.
 */
package com.aranaira.enderio.core.client.render;

import com.aranaira.enderio.core.api.client.render.VertexTransform;
import com.aranaira.enderio.core.common.util.NNList;
import com.aranaira.enderio.core.common.vecmath.Vector2f;
import com.aranaira.enderio.core.common.vecmath.Vector3d;
import com.aranaira.enderio.core.common.vecmath.Vector3f;
import com.aranaira.enderio.core.common.vecmath.Vertex;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;

public final class BoundingBox
extends AxisAlignedBB {
    @Nonnull
    public static final BoundingBox UNIT_CUBE = new BoundingBox(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);

    public BoundingBox(@Nonnull BlockPos pos1, @Nonnull BlockPos pos2) {
        super(pos1, pos2);
    }

    public BoundingBox(@Nonnull AxisAlignedBB bb) {
        super(bb.field_72340_a, bb.field_72338_b, bb.field_72339_c, bb.field_72336_d, bb.field_72337_e, bb.field_72334_f);
    }

    public BoundingBox(float minX, float minY, float minZ, float maxX, float maxY, float maxZ) {
        super((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ);
    }

    public BoundingBox(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        super(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public BoundingBox(@Nonnull Vector3d min, @Nonnull Vector3d max) {
        super(min.x, min.y, min.z, max.x, max.y, max.z);
    }

    public BoundingBox(@Nonnull BlockPos bc) {
        super((double)bc.func_177958_n(), (double)bc.func_177956_o(), (double)bc.func_177952_p(), (double)(bc.func_177958_n() + 1), (double)(bc.func_177956_o() + 1), (double)(bc.func_177952_p() + 1));
    }

    @Nonnull
    public BoundingBox expandBy(@Nonnull BoundingBox other) {
        return new BoundingBox(Math.min(this.field_72340_a, other.field_72340_a), Math.min(this.field_72338_b, other.field_72338_b), Math.min(this.field_72339_c, other.field_72339_c), Math.max(this.field_72336_d, other.field_72336_d), Math.max(this.field_72337_e, other.field_72337_e), Math.max(this.field_72334_f, other.field_72334_f));
    }

    public boolean contains(@Nonnull BoundingBox other) {
        return this.field_72340_a <= other.field_72340_a && this.field_72338_b <= other.field_72338_b && this.field_72339_c <= other.field_72339_c && this.field_72336_d >= other.field_72336_d && this.field_72337_e >= other.field_72337_e && this.field_72334_f >= other.field_72334_f;
    }

    public boolean contains(@Nonnull BlockPos pos) {
        return this.field_72340_a <= (double)pos.func_177958_n() && this.field_72338_b <= (double)pos.func_177956_o() && this.field_72339_c <= (double)pos.func_177952_p() && this.field_72336_d >= (double)pos.func_177958_n() && this.field_72337_e >= (double)pos.func_177956_o() && this.field_72334_f >= (double)pos.func_177952_p();
    }

    public boolean intersects(@Nonnull BoundingBox other) {
        return other.field_72336_d > this.field_72340_a && other.field_72340_a < this.field_72336_d && other.field_72337_e > this.field_72338_b && other.field_72338_b < this.field_72337_e && other.field_72334_f > this.field_72339_c && other.field_72339_c < this.field_72334_f;
    }

    @Nonnull
    public BoundingBox scale(float xyz) {
        return this.scale((double)xyz, (double)xyz, (double)xyz);
    }

    @Nonnull
    public BoundingBox scale(double xyz) {
        return this.scale(xyz, xyz, xyz);
    }

    @Nonnull
    public BoundingBox scale(float x, float y, float z) {
        return this.scale((double)x, (double)y, (double)z);
    }

    @Nonnull
    public BoundingBox scale(double x, double y, double z) {
        double w = (this.field_72336_d - this.field_72340_a) * (1.0 - x) / 2.0;
        double h = (this.field_72337_e - this.field_72338_b) * (1.0 - y) / 2.0;
        double d = (this.field_72334_f - this.field_72339_c) * (1.0 - z) / 2.0;
        return new BoundingBox(this.field_72340_a + w, this.field_72338_b + h, this.field_72339_c + d, this.field_72336_d - w, this.field_72337_e - h, this.field_72334_f - d);
    }

    @Nonnull
    public BoundingBox translate(float x, float y, float z) {
        return new BoundingBox(this.field_72340_a + (double)x, this.field_72338_b + (double)y, this.field_72339_c + (double)z, this.field_72336_d + (double)x, this.field_72337_e + (double)y, this.field_72334_f + (double)z);
    }

    @Nonnull
    public BoundingBox translate(@Nonnull Vector3d translation) {
        return this.translate((float)translation.x, (float)translation.y, (float)translation.z);
    }

    @Nonnull
    public BoundingBox translate(@Nonnull Vector3f vec) {
        return this.translate(vec.x, vec.y, vec.z);
    }

    @Nonnull
    public List<Vertex> getCornersWithUvForFace(@Nonnull EnumFacing face) {
        return this.getCornersWithUvForFace(face, 0.0f, 1.0f, 0.0f, 1.0f);
    }

    @Nonnull
    public NNList<Vertex> getCornersWithUvForFace(@Nonnull EnumFacing face, float minU, float maxU, float minV, float maxV) {
        NNList<Vertex> result = new NNList<Vertex>();
        switch (face) {
            case NORTH: {
                result.add(new Vertex(new Vector3d(this.field_72336_d, this.field_72338_b, this.field_72339_c), new Vector3f(0.0f, 0.0f, -1.0f), new Vector2f(minU, minV)));
                result.add(new Vertex(new Vector3d(this.field_72340_a, this.field_72338_b, this.field_72339_c), new Vector3f(0.0f, 0.0f, -1.0f), new Vector2f(maxU, minV)));
                result.add(new Vertex(new Vector3d(this.field_72340_a, this.field_72337_e, this.field_72339_c), new Vector3f(0.0f, 0.0f, -1.0f), new Vector2f(maxU, maxV)));
                result.add(new Vertex(new Vector3d(this.field_72336_d, this.field_72337_e, this.field_72339_c), new Vector3f(0.0f, 0.0f, -1.0f), new Vector2f(minU, maxV)));
                break;
            }
            case SOUTH: {
                result.add(new Vertex(new Vector3d(this.field_72340_a, this.field_72338_b, this.field_72334_f), new Vector3f(0.0f, 0.0f, 1.0f), new Vector2f(maxU, minV)));
                result.add(new Vertex(new Vector3d(this.field_72336_d, this.field_72338_b, this.field_72334_f), new Vector3f(0.0f, 0.0f, 1.0f), new Vector2f(minU, minV)));
                result.add(new Vertex(new Vector3d(this.field_72336_d, this.field_72337_e, this.field_72334_f), new Vector3f(0.0f, 0.0f, 1.0f), new Vector2f(minU, maxV)));
                result.add(new Vertex(new Vector3d(this.field_72340_a, this.field_72337_e, this.field_72334_f), new Vector3f(0.0f, 0.0f, 1.0f), new Vector2f(maxU, maxV)));
                break;
            }
            case EAST: {
                result.add(new Vertex(new Vector3d(this.field_72336_d, this.field_72337_e, this.field_72339_c), new Vector3f(1.0f, 0.0f, 0.0f), new Vector2f(maxU, maxV)));
                result.add(new Vertex(new Vector3d(this.field_72336_d, this.field_72337_e, this.field_72334_f), new Vector3f(1.0f, 0.0f, 0.0f), new Vector2f(minU, maxV)));
                result.add(new Vertex(new Vector3d(this.field_72336_d, this.field_72338_b, this.field_72334_f), new Vector3f(1.0f, 0.0f, 0.0f), new Vector2f(minU, minV)));
                result.add(new Vertex(new Vector3d(this.field_72336_d, this.field_72338_b, this.field_72339_c), new Vector3f(1.0f, 0.0f, 0.0f), new Vector2f(maxU, minV)));
                break;
            }
            case WEST: {
                result.add(new Vertex(new Vector3d(this.field_72340_a, this.field_72338_b, this.field_72339_c), new Vector3f(-1.0f, 0.0f, 0.0f), new Vector2f(maxU, minV)));
                result.add(new Vertex(new Vector3d(this.field_72340_a, this.field_72338_b, this.field_72334_f), new Vector3f(-1.0f, 0.0f, 0.0f), new Vector2f(minU, minV)));
                result.add(new Vertex(new Vector3d(this.field_72340_a, this.field_72337_e, this.field_72334_f), new Vector3f(-1.0f, 0.0f, 0.0f), new Vector2f(minU, maxV)));
                result.add(new Vertex(new Vector3d(this.field_72340_a, this.field_72337_e, this.field_72339_c), new Vector3f(-1.0f, 0.0f, 0.0f), new Vector2f(maxU, maxV)));
                break;
            }
            case UP: {
                result.add(new Vertex(new Vector3d(this.field_72336_d, this.field_72337_e, this.field_72334_f), new Vector3f(0.0f, 1.0f, 0.0f), new Vector2f(minU, minV)));
                result.add(new Vertex(new Vector3d(this.field_72336_d, this.field_72337_e, this.field_72339_c), new Vector3f(0.0f, 1.0f, 0.0f), new Vector2f(minU, maxV)));
                result.add(new Vertex(new Vector3d(this.field_72340_a, this.field_72337_e, this.field_72339_c), new Vector3f(0.0f, 1.0f, 0.0f), new Vector2f(maxU, maxV)));
                result.add(new Vertex(new Vector3d(this.field_72340_a, this.field_72337_e, this.field_72334_f), new Vector3f(0.0f, 1.0f, 0.0f), new Vector2f(maxU, minV)));
                break;
            }
            default: {
                result.add(new Vertex(new Vector3d(this.field_72340_a, this.field_72338_b, this.field_72339_c), new Vector3f(0.0f, -1.0f, 0.0f), new Vector2f(maxU, maxV)));
                result.add(new Vertex(new Vector3d(this.field_72336_d, this.field_72338_b, this.field_72339_c), new Vector3f(0.0f, -1.0f, 0.0f), new Vector2f(minU, maxV)));
                result.add(new Vertex(new Vector3d(this.field_72336_d, this.field_72338_b, this.field_72334_f), new Vector3f(0.0f, -1.0f, 0.0f), new Vector2f(minU, minV)));
                result.add(new Vertex(new Vector3d(this.field_72340_a, this.field_72338_b, this.field_72334_f), new Vector3f(0.0f, -1.0f, 0.0f), new Vector2f(maxU, minV)));
            }
        }
        return result;
    }

    @Nonnull
    public List<Vector3f> getCornersForFace(@Nonnull EnumFacing face) {
        ArrayList<Vector3f> result = new ArrayList<Vector3f>(4);
        switch (face) {
            case NORTH: {
                result.add(new Vector3f(this.field_72340_a, this.field_72337_e, this.field_72339_c));
                result.add(new Vector3f(this.field_72336_d, this.field_72337_e, this.field_72339_c));
                result.add(new Vector3f(this.field_72336_d, this.field_72338_b, this.field_72339_c));
                result.add(new Vector3f(this.field_72340_a, this.field_72338_b, this.field_72339_c));
                break;
            }
            case SOUTH: {
                result.add(new Vector3f(this.field_72340_a, this.field_72337_e, this.field_72334_f));
                result.add(new Vector3f(this.field_72340_a, this.field_72338_b, this.field_72334_f));
                result.add(new Vector3f(this.field_72336_d, this.field_72338_b, this.field_72334_f));
                result.add(new Vector3f(this.field_72336_d, this.field_72337_e, this.field_72334_f));
                break;
            }
            case EAST: {
                result.add(new Vector3f(this.field_72336_d, this.field_72338_b, this.field_72334_f));
                result.add(new Vector3f(this.field_72336_d, this.field_72338_b, this.field_72339_c));
                result.add(new Vector3f(this.field_72336_d, this.field_72337_e, this.field_72339_c));
                result.add(new Vector3f(this.field_72336_d, this.field_72337_e, this.field_72334_f));
                break;
            }
            case WEST: {
                result.add(new Vector3f(this.field_72340_a, this.field_72337_e, this.field_72334_f));
                result.add(new Vector3f(this.field_72340_a, this.field_72337_e, this.field_72339_c));
                result.add(new Vector3f(this.field_72340_a, this.field_72338_b, this.field_72339_c));
                result.add(new Vector3f(this.field_72340_a, this.field_72338_b, this.field_72334_f));
                break;
            }
            case UP: {
                result.add(new Vector3f(this.field_72336_d, this.field_72337_e, this.field_72334_f));
                result.add(new Vector3f(this.field_72336_d, this.field_72337_e, this.field_72339_c));
                result.add(new Vector3f(this.field_72340_a, this.field_72337_e, this.field_72339_c));
                result.add(new Vector3f(this.field_72340_a, this.field_72337_e, this.field_72334_f));
                break;
            }
            default: {
                result.add(new Vector3f(this.field_72340_a, this.field_72338_b, this.field_72334_f));
                result.add(new Vector3f(this.field_72340_a, this.field_72338_b, this.field_72339_c));
                result.add(new Vector3f(this.field_72336_d, this.field_72338_b, this.field_72339_c));
                result.add(new Vector3f(this.field_72336_d, this.field_72338_b, this.field_72334_f));
            }
        }
        return result;
    }

    @Nonnull
    public List<Vector3d> getCornersForFaceD(@Nonnull EnumFacing face) {
        ArrayList<Vector3d> result = new ArrayList<Vector3d>(4);
        switch (face) {
            case NORTH: {
                result.add(new Vector3d(this.field_72340_a, this.field_72337_e, this.field_72339_c));
                result.add(new Vector3d(this.field_72336_d, this.field_72337_e, this.field_72339_c));
                result.add(new Vector3d(this.field_72336_d, this.field_72338_b, this.field_72339_c));
                result.add(new Vector3d(this.field_72340_a, this.field_72338_b, this.field_72339_c));
                break;
            }
            case SOUTH: {
                result.add(new Vector3d(this.field_72340_a, this.field_72337_e, this.field_72334_f));
                result.add(new Vector3d(this.field_72340_a, this.field_72338_b, this.field_72334_f));
                result.add(new Vector3d(this.field_72336_d, this.field_72338_b, this.field_72334_f));
                result.add(new Vector3d(this.field_72336_d, this.field_72337_e, this.field_72334_f));
                break;
            }
            case EAST: {
                result.add(new Vector3d(this.field_72336_d, this.field_72338_b, this.field_72334_f));
                result.add(new Vector3d(this.field_72336_d, this.field_72338_b, this.field_72339_c));
                result.add(new Vector3d(this.field_72336_d, this.field_72337_e, this.field_72339_c));
                result.add(new Vector3d(this.field_72336_d, this.field_72337_e, this.field_72334_f));
                break;
            }
            case WEST: {
                result.add(new Vector3d(this.field_72340_a, this.field_72337_e, this.field_72334_f));
                result.add(new Vector3d(this.field_72340_a, this.field_72337_e, this.field_72339_c));
                result.add(new Vector3d(this.field_72340_a, this.field_72338_b, this.field_72339_c));
                result.add(new Vector3d(this.field_72340_a, this.field_72338_b, this.field_72334_f));
                break;
            }
            case UP: {
                result.add(new Vector3d(this.field_72336_d, this.field_72337_e, this.field_72334_f));
                result.add(new Vector3d(this.field_72336_d, this.field_72337_e, this.field_72339_c));
                result.add(new Vector3d(this.field_72340_a, this.field_72337_e, this.field_72339_c));
                result.add(new Vector3d(this.field_72340_a, this.field_72337_e, this.field_72334_f));
                break;
            }
            default: {
                result.add(new Vector3d(this.field_72340_a, this.field_72338_b, this.field_72334_f));
                result.add(new Vector3d(this.field_72340_a, this.field_72338_b, this.field_72339_c));
                result.add(new Vector3d(this.field_72336_d, this.field_72338_b, this.field_72339_c));
                result.add(new Vector3d(this.field_72336_d, this.field_72338_b, this.field_72334_f));
            }
        }
        return result;
    }

    @Nonnull
    public Vector3d getBBCenter() {
        return new Vector3d(this.field_72340_a + (this.field_72336_d - this.field_72340_a) / 2.0, this.field_72338_b + (this.field_72337_e - this.field_72338_b) / 2.0, this.field_72339_c + (this.field_72334_f - this.field_72339_c) / 2.0);
    }

    public double sizeX() {
        return Math.abs(this.field_72336_d - this.field_72340_a);
    }

    public double sizeY() {
        return Math.abs(this.field_72337_e - this.field_72338_b);
    }

    public double sizeZ() {
        return Math.abs(this.field_72334_f - this.field_72339_c);
    }

    @Nonnull
    public Vector3d getMin() {
        return new Vector3d(this.field_72340_a, this.field_72338_b, this.field_72339_c);
    }

    @Nonnull
    public Vector3d getMax() {
        return new Vector3d(this.field_72336_d, this.field_72337_e, this.field_72334_f);
    }

    public double getArea() {
        return this.sizeX() * this.sizeY() * this.sizeZ();
    }

    @Nonnull
    public BoundingBox fixMinMax() {
        double mnX = this.field_72340_a;
        double mnY = this.field_72338_b;
        double mnZ = this.field_72339_c;
        double mxX = this.field_72336_d;
        double mxY = this.field_72337_e;
        double mxZ = this.field_72334_f;
        boolean mod = false;
        if (this.field_72340_a > this.field_72336_d) {
            mnX = this.field_72336_d;
            mxX = this.field_72340_a;
            mod = true;
        }
        if (this.field_72338_b > this.field_72337_e) {
            mnY = this.field_72337_e;
            mxY = this.field_72338_b;
            mod = true;
        }
        if (this.field_72339_c > this.field_72334_f) {
            mnZ = this.field_72334_f;
            mxZ = this.field_72339_c;
            mod = true;
        }
        if (!mod) {
            return this;
        }
        return new BoundingBox(mnX, mnY, mnZ, mxX, mxY, mxZ);
    }

    @Nonnull
    public BoundingBox transform(@Nonnull VertexTransform vertexTransform) {
        Vector3d min = new Vector3d(this.field_72340_a, this.field_72338_b, this.field_72339_c);
        Vector3d max = new Vector3d(this.field_72336_d, this.field_72337_e, this.field_72334_f);
        vertexTransform.apply(min);
        vertexTransform.apply(max);
        return new BoundingBox(Math.min(min.x, max.x), Math.min(min.y, max.y), Math.min(min.z, max.z), Math.max(min.x, max.x), Math.max(min.y, max.y), Math.max(min.z, max.z));
    }

    @Nonnull
    public BoundingBox expand(double x, double y, double z) {
        return new BoundingBox(this.field_72340_a - x, this.field_72338_b - y, this.field_72339_c - z, this.field_72336_d + x, this.field_72337_e + y, this.field_72334_f + z);
    }

    @Nonnull
    public BoundingBox setMaxY(double y2) {
        return new BoundingBox(this.field_72340_a, this.field_72338_b, this.field_72339_c, this.field_72336_d, y2, this.field_72334_f);
    }

    @Nonnull
    public BoundingBox expand(double xyz) {
        return new BoundingBox(this.field_72340_a - xyz, this.field_72338_b - xyz, this.field_72339_c - xyz, this.field_72336_d + xyz, this.field_72337_e + xyz, this.field_72334_f + xyz);
    }

    @Nonnull
    public Vec3d func_189972_c() {
        return new Vec3d(this.field_72340_a + (this.field_72336_d - this.field_72340_a) * 0.5, this.field_72338_b + (this.field_72337_e - this.field_72338_b) * 0.5, this.field_72339_c + (this.field_72334_f - this.field_72339_c) * 0.5);
    }
}

