/*
 * Decompiled with CFR 0.152.
 */
package com.aranaira.arcanearchives.util;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.handler.codec.EncoderException;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;

public class NetworkUtils {
    public static void writeNBT(ByteBuf buf, @Nullable NBTTagCompound nbt) {
        if (nbt == null) {
            buf.writeByte(0);
        } else {
            try {
                CompressedStreamTools.func_74800_a((NBTTagCompound)nbt, (DataOutput)new ByteBufOutputStream(buf));
            }
            catch (IOException ioexception) {
                throw new EncoderException((Throwable)ioexception);
            }
        }
    }

    public static NBTTagCompound readNBT(ByteBuf buf) {
        int i = buf.readerIndex();
        byte b0 = buf.readByte();
        if (b0 == 0) {
            return null;
        }
        buf.readerIndex(i);
        try {
            return CompressedStreamTools.func_152456_a((DataInput)new ByteBufInputStream(buf), (NBTSizeTracker)new NBTSizeTracker(0x200000L));
        }
        catch (IOException ioexception) {
            throw new EncoderException((Throwable)ioexception);
        }
    }

    public static void writeExtendedItemStack(PacketBuffer buf, ItemStack stack) {
        if (stack.func_190926_b()) {
            buf.writeShort(-1);
        } else {
            buf.writeShort(Item.func_150891_b((Item)stack.func_77973_b()));
            buf.writeShort(stack.func_190916_E());
            buf.writeShort(stack.func_77960_j());
            NBTTagCompound nbttagcompound = null;
            if (stack.func_77973_b().func_77645_m() || stack.func_77973_b().func_77651_p()) {
                nbttagcompound = stack.func_77973_b().getNBTShareTag(stack);
            }
            buf.func_150786_a(nbttagcompound);
        }
    }

    public static void writeExtendedItemStack(ByteBuf buf, ItemStack stack) {
        if (stack.func_190926_b()) {
            buf.writeShort(-1);
        } else {
            buf.writeShort(Item.func_150891_b((Item)stack.func_77973_b()));
            buf.writeShort(stack.func_190916_E());
            buf.writeShort(stack.func_77960_j());
            NBTTagCompound nbttagcompound = null;
            if (stack.func_77973_b().func_77645_m() || stack.func_77973_b().func_77651_p()) {
                nbttagcompound = stack.func_77973_b().getNBTShareTag(stack);
            }
            NetworkUtils.writeNBT(buf, nbttagcompound);
        }
    }

    public static void writeExtendedItemStackFromClientToServer(ByteBuf buf, ItemStack stack) {
        if (stack.func_190926_b()) {
            buf.writeShort(-1);
        } else {
            buf.writeShort(Item.func_150891_b((Item)stack.func_77973_b()));
            buf.writeShort(stack.func_190916_E());
            buf.writeShort(stack.func_77960_j());
            NBTTagCompound nbttagcompound = null;
            if (stack.func_77973_b().func_77645_m() || stack.func_77973_b().func_77651_p()) {
                nbttagcompound = stack.func_77978_p();
            }
            NetworkUtils.writeNBT(buf, nbttagcompound);
        }
    }

    public static void writeExtendedItemStackFromClientToServer(PacketBuffer buf, ItemStack stack) {
        if (stack.func_190926_b()) {
            buf.writeShort(-1);
        } else {
            buf.writeShort(Item.func_150891_b((Item)stack.func_77973_b()));
            buf.writeShort(stack.func_190916_E());
            buf.writeShort(stack.func_77960_j());
            NBTTagCompound nbttagcompound = null;
            if (stack.func_77973_b().func_77645_m() || stack.func_77973_b().func_77651_p()) {
                nbttagcompound = stack.func_77978_p();
            }
            buf.func_150786_a(nbttagcompound);
        }
    }

    public static ItemStack readExtendedItemStack(ByteBuf buf) throws IOException {
        short i = buf.readShort();
        if (i < 0) {
            return ItemStack.field_190927_a;
        }
        short j = buf.readShort();
        short k = buf.readShort();
        ItemStack itemstack = new ItemStack(Item.func_150899_d((int)i), (int)j, (int)k);
        itemstack.func_77982_d(NetworkUtils.readNBT(buf));
        return itemstack;
    }

    public static ItemStack readExtendedItemStack(PacketBuffer buf) throws IOException {
        short i = buf.readShort();
        if (i < 0) {
            return ItemStack.field_190927_a;
        }
        short j = buf.readShort();
        short k = buf.readShort();
        ItemStack itemstack = new ItemStack(Item.func_150899_d((int)i), (int)j, (int)k);
        itemstack.func_77982_d(buf.func_150793_b());
        return itemstack;
    }
}

