/*
 * Decompiled with CFR 0.152.
 */
package com.aranaira.arcanearchives.util;

import com.aranaira.arcanearchives.ArcaneArchives;
import com.aranaira.arcanearchives.data.HiveNetwork;
import com.aranaira.arcanearchives.data.ServerNetwork;
import com.aranaira.arcanearchives.tileentities.ImmanenceTileEntity;
import com.aranaira.arcanearchives.tileentities.MonitoringCrystalTileEntity;
import com.aranaira.arcanearchives.tileentities.interfaces.IManifestTileEntity;
import com.aranaira.arcanearchives.types.BlockPosDimension;
import com.aranaira.arcanearchives.types.ISerializeByteBuf;
import com.aranaira.arcanearchives.types.IteRef;
import com.aranaira.arcanearchives.types.iterators.SlotIterable;
import com.aranaira.arcanearchives.types.lists.ITileList;
import com.aranaira.arcanearchives.util.ByteUtils;
import com.aranaira.arcanearchives.util.ItemUtils;
import com.aranaira.arcanearchives.util.TileUtils;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.client.util.RecipeItemHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.items.IItemHandler;

public class ManifestUtils {
    public static void resolveItemEntries(List<ItemEntry> entries, ItemEntry entry) {
        if (entry.stack.func_77976_d() == 1) {
            ItemStack stack = entry.stack.func_77946_l();
            stack.func_190920_e(1);
            for (int i = 0; i < entry.stack.func_190916_E(); ++i) {
                entries.add(entry.copy(stack.func_77946_l()));
            }
        } else {
            entries.add(entry);
        }
    }

    public static List<CollatedEntry> parsePreManifest(Map<Integer, List<ItemEntry>> preManifest, ServerNetwork network) {
        EntityPlayer player = network.getPlayer();
        HashMap<ItemStack, List> phase1 = new HashMap<ItemStack, List>();
        for (int packed : preManifest.keySet()) {
            block1: for (ItemEntry entry : preManifest.get(packed)) {
                for (ItemStack keyStack : phase1.keySet()) {
                    if (!ItemUtils.areStacksEqualIgnoreSize(entry.stack, keyStack)) continue;
                    List phaseList = phase1.computeIfAbsent(keyStack, k -> new ArrayList());
                    ManifestUtils.resolveItemEntries(phaseList, entry);
                    continue block1;
                }
                ItemStack keyStack = entry.stack.func_77946_l();
                keyStack.func_190920_e(1);
                ArrayList<ItemEntry> entries = new ArrayList<ItemEntry>();
                ManifestUtils.resolveItemEntries(entries, entry);
                phase1.put(keyStack, entries);
            }
        }
        BlockPos playerPos = player.func_180425_c();
        int dimension = player.field_71093_bK;
        ArrayList<CollatedEntry> phase2 = new ArrayList<CollatedEntry>();
        for (Map.Entry entry : phase1.entrySet()) {
            CollatedEntry inRange = new CollatedEntry((ItemStack)entry.getKey());
            inRange.inRange = true;
            CollatedEntry outOfRange = new CollatedEntry((ItemStack)entry.getKey());
            outOfRange.outOfRange = true;
            CollatedEntry outOfDimension = new CollatedEntry((ItemStack)entry.getKey());
            outOfDimension.outOfDimension = true;
            List entries = (List)entry.getValue();
            for (ItemEntry itemEntry : entries) {
                EntryDescriptor descriptor = new EntryDescriptor(itemEntry.stack.func_190916_E(), itemEntry.description, itemEntry.pos, itemEntry.dimension);
                if (itemEntry.dimension != dimension) {
                    outOfDimension.descriptions.add(descriptor);
                    outOfDimension.consume(itemEntry.stack);
                    continue;
                }
                if (!network.inRange(playerPos, itemEntry.pos)) {
                    outOfRange.descriptions.add(descriptor);
                    outOfRange.consume(itemEntry.stack);
                    continue;
                }
                inRange.descriptions.add(descriptor);
                inRange.consume(itemEntry.stack);
            }
            if (!inRange.descriptions.isEmpty()) {
                phase2.add(inRange);
            }
            if (!outOfDimension.descriptions.isEmpty()) {
                phase2.add(outOfDimension);
            }
            if (outOfRange.descriptions.isEmpty()) continue;
            phase2.add(outOfRange);
        }
        return phase2;
    }

    public static Map<Integer, List<ItemEntry>> buildItemEntryList(ServerNetwork network) {
        ITileList tiles = network.getTiles();
        if (network.isHiveMember()) {
            HiveNetwork hive = network.getHiveNetwork();
            tiles = hive.getTiles();
        }
        EntityPlayer player = network.getPlayer();
        Int2ObjectOpenHashMap preManifest = new Int2ObjectOpenHashMap();
        preManifest.defaultReturnValue(null);
        HashSet<BlockPosDimension> done = new HashSet<BlockPosDimension>();
        for (IteRef ref : TileUtils.filterAssignableClass(tiles, IManifestTileEntity.class)) {
            ImmanenceTileEntity ite;
            if (ref == null || (ite = ref.getTile()) == null) continue;
            IManifestTileEntity mte = (IManifestTileEntity)((Object)ite);
            if (done.contains(BlockPosDimension.fromITE(ite))) continue;
            if (mte.isSingleStackInventory()) {
                ItemStack stack = mte.getSingleStack();
                List<ItemEntry> entry = ManifestUtils.getEntryList((Int2ObjectOpenHashMap<List<ItemEntry>>)preManifest, RecipeItemHelper.func_194113_b((ItemStack)stack));
                entry.add(new ItemEntry(stack, ite.func_174877_v(), ite.dimension, mte.getDescriptor()));
                done.add(BlockPosDimension.fromITE(ite));
                continue;
            }
            if (mte instanceof MonitoringCrystalTileEntity) {
                IItemHandler handler;
                MonitoringCrystalTileEntity mce = (MonitoringCrystalTileEntity)ite;
                if (mce.getTarget() == null) continue;
                BlockPosDimension target = new BlockPosDimension(mce.getTarget(), mce.dimension);
                if (done.contains(target)) {
                    if (player != null) {
                        player.func_145747_a((ITextComponent)new TextComponentTranslation("arcanearchives.error.monitoring_crystal", new Object[]{target.getX(), target.getY(), target.getZ(), target.dimension}));
                    } else {
                        ArcaneArchives.logger.error("Multiple Monitoring Crystals were found for network " + network.getUuid().toString() + " targetgeting " + String.format("%d/%d/%d in dimension %d", target.getX(), target.getY(), target.getZ(), target.dimension));
                    }
                }
                if ((handler = mce.getInventory()) != null) {
                    for (ItemStack is : new SlotIterable(handler)) {
                        if (is.func_190926_b()) continue;
                        List<ItemEntry> entries = ManifestUtils.getEntryList((Int2ObjectOpenHashMap<List<ItemEntry>>)preManifest, RecipeItemHelper.func_194113_b((ItemStack)is));
                        entries.add(new ItemEntry(is, target.pos, target.dimension, mce.getDescriptor()));
                    }
                }
                done.add(target);
                continue;
            }
            for (ItemStack is : new SlotIterable(mte.getInventory())) {
                if (is.func_190926_b()) continue;
                List<ItemEntry> entries = ManifestUtils.getEntryList((Int2ObjectOpenHashMap<List<ItemEntry>>)preManifest, RecipeItemHelper.func_194113_b((ItemStack)is));
                entries.add(new ItemEntry(is, ite.func_174877_v(), ite.dimension, mte.getDescriptor()));
            }
            done.add(new BlockPosDimension(ite.func_174877_v(), ite.dimension));
        }
        return preManifest;
    }

    public static List<ItemEntry> getEntryList(Int2ObjectOpenHashMap<List<ItemEntry>> map, int packed) {
        ArrayList list = (ArrayList)map.get(packed);
        if (list == null) {
            list = new ArrayList();
            map.put(packed, list);
        }
        return list;
    }

    public static class EntryDescriptor
    implements ISerializeByteBuf<EntryDescriptor> {
        public int count;
        public String string;
        public BlockPos pos;
        public int dimension;

        public EntryDescriptor() {
        }

        public EntryDescriptor(int count, String string, BlockPos pos, int dimension) {
            this.count = count;
            this.string = string;
            this.pos = pos;
            this.dimension = dimension;
        }

        public static EntryDescriptor deserialize(ByteBuf buf) {
            EntryDescriptor entry = new EntryDescriptor();
            return entry.fromBytes(buf);
        }

        @Override
        public EntryDescriptor fromBytes(ByteBuf buf) {
            this.count = buf.readInt();
            this.string = ByteUtils.readOptionalUTF8(buf);
            this.pos = BlockPos.func_177969_a((long)buf.readLong());
            this.dimension = buf.readInt();
            return this;
        }

        @Override
        public void toBytes(ByteBuf buf) {
            buf.writeInt(this.count);
            ByteUtils.writeOptionalUTF8(buf, this.string);
            buf.writeLong(this.pos.func_177986_g());
            buf.writeInt(this.dimension);
        }

        public Vec3d vec3d() {
            return new Vec3d((double)this.pos.func_177958_n(), (double)this.pos.func_177956_o(), (double)this.pos.func_177952_p());
        }

        public int getItemCount() {
            return this.count;
        }
    }

    public static class CollatedEntry
    implements ISerializeByteBuf<CollatedEntry> {
        public ItemStack finalStack;
        public List<EntryDescriptor> descriptions = new ArrayList<EntryDescriptor>();
        public boolean outOfRange = false;
        public boolean outOfDimension = false;
        public boolean inRange = false;

        public CollatedEntry() {
        }

        public CollatedEntry(ItemStack finalStack) {
            this.finalStack = finalStack.func_77946_l();
            this.finalStack.func_190920_e(0);
        }

        public void consume(ItemStack stack) {
            this.finalStack.func_190920_e(this.finalStack.func_190916_E() + stack.func_190916_E());
        }

        public ItemStack getStack() {
            return this.finalStack;
        }

        public static CollatedEntry deserialize(ByteBuf buf) {
            CollatedEntry entry = new CollatedEntry();
            return entry.fromBytes(buf);
        }

        @Override
        public CollatedEntry fromBytes(ByteBuf buf) {
            this.finalStack = ByteBufUtils.readItemStack((ByteBuf)buf);
            this.finalStack.func_190920_e(buf.readInt());
            this.outOfDimension = buf.readBoolean();
            this.outOfRange = buf.readBoolean();
            this.inRange = buf.readBoolean();
            this.descriptions = new ArrayList<EntryDescriptor>();
            int entries = buf.readInt();
            for (int i = 0; i < entries; ++i) {
                this.descriptions.add(EntryDescriptor.deserialize(buf));
            }
            return this;
        }

        @Override
        public void toBytes(ByteBuf buf) {
            ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.finalStack);
            buf.writeInt(this.finalStack.func_190916_E());
            buf.writeBoolean(this.outOfDimension);
            buf.writeBoolean(this.outOfRange);
            buf.writeBoolean(this.inRange);
            buf.writeInt(this.descriptions.size());
            for (EntryDescriptor entry : this.descriptions) {
                entry.toBytes(buf);
            }
        }

        public List<Vec3d> getVecPositions() {
            return this.descriptions.stream().map(EntryDescriptor::vec3d).collect(Collectors.toList());
        }

        public int getDimension() {
            return this.descriptions.isEmpty() ? 0 : this.descriptions.get((int)0).dimension;
        }
    }

    public static class ItemEntry {
        public ItemStack stack;
        public BlockPos pos;
        public int dimension;
        public String description;

        public ItemEntry(ItemStack stack, BlockPos pos, int dimension, String description) {
            this.stack = stack;
            this.pos = pos;
            this.dimension = dimension;
            this.description = description;
        }

        public ItemEntry copy(ItemStack stack) {
            return new ItemEntry(stack, this.pos, this.dimension, this.description);
        }
    }
}

