/*
 * Decompiled with CFR 0.152.
 */
package com.aranaira.arcanearchives.util;

import com.aranaira.arcanearchives.util.ItemUtils;
import com.aranaira.arcanearchives.util.ManifestUtils;
import com.aranaira.arcanearchives.util.MathUtils;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;

@Mod.EventBusSubscriber(modid="arcanearchives")
public class ManifestTrackingUtils {
    private static Int2ObjectOpenHashMap<Set<Vec3d>> positionsByDimension = new Int2ObjectOpenHashMap();
    private static Int2ObjectOpenHashMap<Long2ObjectOpenHashMap<List<ItemStack>>> reference = new Int2ObjectOpenHashMap();
    private static Set<ItemStack> allTracked = new HashSet<ItemStack>();

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        ManifestTrackingUtils.clear();
    }

    public static void clear() {
        reference.clear();
        allTracked = null;
        positionsByDimension = null;
    }

    public static void add(ManifestUtils.CollatedEntry entry) {
        for (ManifestUtils.EntryDescriptor innerEntry : entry.descriptions) {
            ManifestTrackingUtils.add(entry.getStack(), innerEntry.dimension, innerEntry.pos);
        }
    }

    public static void remove(ManifestUtils.CollatedEntry entry) {
        for (ManifestUtils.EntryDescriptor innerEntry : entry.descriptions) {
            ManifestTrackingUtils.remove(entry.getStack(), innerEntry.dimension, innerEntry.pos);
        }
    }

    public static void add(ItemStack stack, int dimension, BlockPos pos) {
        ArrayList<ItemStack> dim = (ArrayList<ItemStack>)ManifestTrackingUtils.getDimension(dimension).getOrDefault((Object)pos.func_177986_g(), null);
        if (dim == null) {
            dim = new ArrayList<ItemStack>();
            ManifestTrackingUtils.getDimension(dimension).put(pos.func_177986_g(), dim);
        }
        dim.add(stack);
        allTracked = null;
        positionsByDimension = null;
    }

    public static void remove(ItemStack stack, int dimension, BlockPos pos) {
        List dim = (List)ManifestTrackingUtils.getDimension(dimension).getOrDefault((Object)pos.func_177986_g(), null);
        if (dim != null) {
            dim.removeIf(t -> ItemUtils.areStacksEqualIgnoreSize(t, stack));
        }
        allTracked = null;
        positionsByDimension = null;
    }

    private static Long2ObjectOpenHashMap<List<ItemStack>> getDimension(int dimension) {
        return (Long2ObjectOpenHashMap)reference.computeIfAbsent((Object)dimension, k -> new Long2ObjectOpenHashMap());
    }

    private static Set<Vec3d> getDimensionPositions(int dimension) {
        if (positionsByDimension == null) {
            positionsByDimension = new Int2ObjectOpenHashMap();
            for (Int2ObjectMap.Entry entry : reference.int2ObjectEntrySet()) {
                Set positions = ((Long2ObjectOpenHashMap)entry.getValue()).entrySet().stream().filter(t -> !((List)t.getValue()).isEmpty()).map(b -> MathUtils.vec3dFromLong((Long)b.getKey())).collect(Collectors.toSet());
                positionsByDimension.put(entry.getIntKey(), positions);
            }
        }
        return (Set)positionsByDimension.computeIfAbsent((Object)dimension, k -> new HashSet());
    }

    public static void remove(int dimension, BlockPos pos) {
        ManifestTrackingUtils.remove(dimension, pos.func_177986_g());
    }

    public static void remove(int dimension, long pos) {
        Long2ObjectOpenHashMap<List<ItemStack>> dim = ManifestTrackingUtils.getDimension(dimension);
        if (dim.containsKey(pos)) {
            dim.remove(pos);
        }
    }

    @Nullable
    public static List<ItemStack> get(int dimension, BlockPos pos) {
        return (List)ManifestTrackingUtils.getDimension(dimension).getOrDefault((Object)pos.func_177986_g(), null);
    }

    public static Set<ItemStack> getAllTracked() {
        if (allTracked == null) {
            allTracked = new HashSet<ItemStack>();
            IntIterator intIterator = reference.keySet().iterator();
            while (intIterator.hasNext()) {
                int dimension = (Integer)intIterator.next();
                Long2ObjectOpenHashMap<List<ItemStack>> dimensionEntry = ManifestTrackingUtils.getDimension(dimension);
                dimensionEntry.values().forEach(allTracked::addAll);
            }
        }
        return allTracked;
    }

    public static boolean matches(ItemStack stack) {
        return ManifestTrackingUtils.matches(stack, ManifestTrackingUtils.getAllTracked());
    }

    public static boolean matches(ItemStack stack, Collection<ItemStack> ingredients) {
        if (ingredients.isEmpty()) {
            return false;
        }
        if (stack.func_190926_b()) {
            return false;
        }
        for (ItemStack otherStack : ingredients) {
            if (!ItemUtils.areStacksEqualIgnoreSize(stack, otherStack)) continue;
            return true;
        }
        return false;
    }

    public static Set<Vec3d> getPositions(int dimension) {
        return ManifestTrackingUtils.getDimensionPositions(dimension);
    }
}

