/*
 * Decompiled with CFR 0.152.
 */
package com.aranaira.arcanearchives.util;

import com.aranaira.arcanearchives.ArcaneArchives;
import com.aranaira.arcanearchives.data.HiveNetwork;
import com.aranaira.arcanearchives.data.ServerNetwork;
import com.aranaira.arcanearchives.tileentities.BrazierTileEntity;
import com.aranaira.arcanearchives.tileentities.ImmanenceTileEntity;
import com.aranaira.arcanearchives.tileentities.interfaces.IBrazierRouting;
import com.aranaira.arcanearchives.types.IteRef;
import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.stream.Collectors;
import net.minecraft.client.util.RecipeItemHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;

public class InventoryRoutingUtils {
    public static int calculateWeight(IBrazierRouting inventory, ItemStack stack) {
        int slotCount;
        Int2IntOpenHashMap packedMap = inventory.getOrCalculateReference();
        IBrazierRouting.BrazierRoutingType type = inventory.getRoutingType();
        int packed = RecipeItemHelper.func_194113_b((ItemStack)stack);
        int total = packedMap.get(packed);
        int troveScore = inventory.troveScore(stack);
        if (troveScore != -1) {
            return troveScore;
        }
        if (type == IBrazierRouting.BrazierRoutingType.NO_NEW_STACKS || type == IBrazierRouting.BrazierRoutingType.GCT) {
            if (total == 0) {
                return -1;
            }
            if (type == IBrazierRouting.BrazierRoutingType.NO_NEW_STACKS) {
                return 4999;
            }
            return 5000;
        }
        int empty = inventory.countEmptySlots();
        if (empty == (slotCount = inventory.totalSlots())) {
            return 0;
        }
        if (total == 0) {
            return slotCount - empty;
        }
        int stackSize = stack.func_77976_d() == 1 ? 1 : stack.func_77976_d() * inventory.slotMultiplier();
        double potentialSlots = stackSize * slotCount;
        double result = Math.ceil((double)total / potentialSlots * 1000.0 + 500.0);
        return (int)result;
    }

    public static List<WeightedEntry<IBrazierRouting>> buildNetworkWeights(BrazierTileEntity brazier, ItemStack stack, boolean simulate) {
        Iterable<IteRef> tiles;
        ArrayList<WeightedEntry<IBrazierRouting>> workspace = new ArrayList<WeightedEntry<IBrazierRouting>>();
        int radius = brazier.getRadius() * brazier.getRadius();
        BlockPos bPos = brazier.func_174877_v();
        ServerNetwork network = brazier.getServerNetwork();
        if (network == null) {
            ArcaneArchives.logger.error("Brazier with tile id " + brazier.getUuid().toString() + " has an invalid server network; cannot build network weights.");
            return workspace;
        }
        if (!network.isHiveMember() || brazier.getNetworkMode()) {
            tiles = network.getValidTiles();
        } else {
            HiveNetwork hive = network.getHiveNetwork();
            if (hive == null) {
                ArcaneArchives.logger.error("Server Network with id " + network.getUuid().toString() + " is part of a hive but no hive network is available; cannot build network weights.");
                return workspace;
            }
            tiles = hive.getValidTiles();
        }
        if (tiles == null) {
            return workspace;
        }
        for (IteRef ite : tiles) {
            ImmanenceTileEntity tile;
            if (ite == null || !IBrazierRouting.class.isAssignableFrom(ite.clazz) || network.distanceSqNoVertical(bPos, ite.pos) > radius || ite.dimension != brazier.dimension || (tile = ite.getTile()) == null) continue;
            int weight = InventoryRoutingUtils.calculateWeight((IBrazierRouting)((Object)tile), stack);
            workspace.add(new WeightedEntry<IBrazierRouting>((IBrazierRouting)((Object)tile), weight));
        }
        workspace.sort((o1, o2) -> Integer.compare(o2.weight, o1.weight));
        return workspace;
    }

    public static List<IBrazierRouting> buildNetwork(BrazierTileEntity brazier, ItemStack stack, boolean simulate) {
        return InventoryRoutingUtils.buildNetworkWeights(brazier, stack, simulate).stream().filter(r -> r.weight >= 0).map(r -> (IBrazierRouting)r.entry).collect(Collectors.toList());
    }

    public static List<ItemStack> tryInsertItems(BrazierTileEntity brazier, ItemStack reference, List<ItemStack> inputs, boolean simulate) {
        BrazierTileEntity.ItemCache cached = brazier.getCachedEntry(reference);
        if (cached != null && cached.valid()) {
            ArrayList<IBrazierRouting> cacheList = new ArrayList<IBrazierRouting>();
            IBrazierRouting routing = cached.getRoute();
            if (routing == null) {
                ImmanenceTileEntity ite;
                ServerNetwork network = brazier.getServerNetwork();
                if (network != null && (ite = network.getImmanenceTile(cached.getTileId())) instanceof IBrazierRouting) {
                    cacheList.add((IBrazierRouting)((Object)ite));
                }
            } else {
                cacheList.add(routing);
            }
            if (!cacheList.isEmpty() && (inputs = InventoryRoutingUtils.tryInsertItems(cacheList, brazier, reference, inputs, simulate)).isEmpty()) {
                return inputs;
            }
        }
        List<IBrazierRouting> routing = InventoryRoutingUtils.buildNetwork(brazier, reference, simulate);
        return InventoryRoutingUtils.tryInsertItems(routing, brazier, reference, inputs, simulate);
    }

    public static List<ItemStack> tryInsertItems(List<IBrazierRouting> routing, BrazierTileEntity brazier, ItemStack reference, List<ItemStack> inputs, boolean simulate) {
        block0: for (IBrazierRouting route : routing) {
            ListIterator<ItemStack> iterator = inputs.listIterator();
            while (iterator.hasNext()) {
                ItemStack potential = iterator.next();
                iterator.remove();
                ItemStack result = route.acceptStack(potential, simulate);
                if (!result.func_190926_b()) {
                    iterator.add(result);
                    continue block0;
                }
                brazier.cacheInsertion(reference, route, route.getUuid());
            }
        }
        return inputs;
    }

    public static List<ItemStack> tryInsertItems(BrazierTileEntity brazier, ItemStack reference, boolean simulate) {
        return InventoryRoutingUtils.tryInsertItems(brazier, reference, Lists.newArrayList((Object[])new ItemStack[]{reference}), simulate);
    }

    public static class WeightedEntry<T> {
        public T entry;
        public int weight;

        public WeightedEntry(T entry, int weight) {
            this.entry = entry;
            this.weight = weight;
        }
    }
}

