/*
 * Decompiled with CFR 0.152.
 */
package com.aranaira.arcanearchives.types.lists;

import com.aranaira.arcanearchives.inventory.ContainerManifest;
import com.aranaira.arcanearchives.types.ISerializeByteBuf;
import com.aranaira.arcanearchives.types.lists.ReferenceList;
import com.aranaira.arcanearchives.util.ItemUtils;
import com.aranaira.arcanearchives.util.ManifestUtils;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;

public class ManifestList
extends ReferenceList<ManifestUtils.CollatedEntry>
implements ISerializeByteBuf<ManifestList> {
    private static Map<String, ModContainer> modList = null;
    private ContainerManifest listener = null;
    private String filterText;
    private ItemStack searchItem;
    private SortingDirection sortingDirection = null;
    private SortingType sortingType = null;

    public ManifestList(List<ManifestUtils.CollatedEntry> reference) {
        super(reference);
        this.filterText = null;
    }

    public ManifestList(List<ManifestUtils.CollatedEntry> reference, String filterText) {
        super(reference);
        this.filterText = filterText;
    }

    public static ManifestList deserialize(ByteBuf buf) {
        ManifestList list = new ManifestList();
        return list.fromBytes(buf);
    }

    public static Map<String, ModContainer> getModList() {
        if (modList == null) {
            modList = Loader.instance().getIndexedModList();
        }
        return modList;
    }

    public static String getModName(ItemStack stack) {
        if (stack.func_190926_b()) {
            return "";
        }
        String modId = stack.func_77973_b().getCreatorModId(stack);
        if (modId == null) {
            return "";
        }
        ModContainer mod = ManifestList.getModList().get(modId);
        if (mod == null) {
            return "";
        }
        return mod.getName();
    }

    public static String getAdustedModName(ItemStack stack) {
        String name = ManifestList.getModName(stack);
        if (name.isEmpty()) {
            return "";
        }
        return name.replace(" ", "").toLowerCase();
    }

    public ManifestList filtered() {
        if (this.filterText == null && this.searchItem == null) {
            return this;
        }
        String filter = "";
        if (this.filterText != null) {
            filter = this.filterText.toLowerCase();
        }
        boolean mod = false;
        if (filter.startsWith("@")) {
            mod = true;
            filter = filter.replaceFirst("@", "");
        }
        boolean modFilter = mod;
        String finalFilter = filter;
        ManifestList filtered = this.stream().filter(entry -> {
            if (entry == null) {
                return false;
            }
            ItemStack stack = entry.getStack();
            if (this.searchItem != null) {
                return ItemUtils.areStacksEqualIgnoreSize(this.searchItem, stack);
            }
            if (!modFilter) {
                String display = stack.func_82833_r().toLowerCase();
                if (display.contains(finalFilter)) {
                    return true;
                }
                String registry = stack.func_77973_b().getRegistryName().func_110623_a().toLowerCase();
                if (registry.contains(finalFilter)) {
                    return true;
                }
            } else if (modFilter) {
                String modName = ManifestList.getAdustedModName(stack);
                if (modName.contains(finalFilter)) {
                    return true;
                }
                String resource = stack.func_77973_b().getRegistryName().func_110624_b().toLowerCase();
                if (resource.contains(finalFilter)) {
                    return true;
                }
            }
            if (!modFilter && stack.func_77973_b() == Items.field_151134_bR) {
                Map map = EnchantmentHelper.func_82781_a((ItemStack)stack);
                for (Map.Entry ench : map.entrySet()) {
                    String enchName;
                    if (ench.getKey() == null || !(enchName = ((Enchantment)ench.getKey()).func_77316_c(((Integer)ench.getValue()).intValue())).toLowerCase().contains(finalFilter)) continue;
                    return true;
                }
            }
            return false;
        }).collect(Collectors.toCollection(ManifestList::new));
        filtered.sortingDirection = this.sortingDirection;
        filtered.sortingType = this.sortingType;
        filtered.searchItem = this.searchItem;
        filtered.filterText = this.filterText;
        return filtered;
    }

    public ManifestList() {
        super(new ArrayList());
    }

    public void setListener(ContainerManifest containerManifest) {
        this.listener = containerManifest;
    }

    public void deserializationFinished() {
        if (this.listener != null) {
            this.listener.ensureCapacity(this.size());
        }
    }

    @Nullable
    public ManifestUtils.CollatedEntry getEntryForSlot(int slot) {
        if (slot < this.size() && slot >= 0) {
            return (ManifestUtils.CollatedEntry)this.get(slot);
        }
        return null;
    }

    public ItemStack getItemStackForSlot(int slot) {
        if (slot < this.size() && slot >= 0) {
            return ((ManifestUtils.CollatedEntry)this.get(slot)).getStack();
        }
        return ItemStack.field_190927_a;
    }

    public String getSearchText() {
        return this.filterText;
    }

    public ItemStack getSearchItem() {
        return this.searchItem;
    }

    public void setSearchText(String searchTerm) {
        this.filterText = searchTerm;
    }

    public void setSearchItem(ItemStack stack) {
        this.searchItem = stack;
    }

    public SortingDirection getSortingDirection() {
        return this.sortingDirection;
    }

    public void setSortingDirection(SortingDirection sortingDirection) {
        this.sortingDirection = sortingDirection;
    }

    public SortingType getSortingType() {
        return this.sortingType;
    }

    public void setSortingType(SortingType sortingType) {
        this.sortingType = sortingType;
    }

    public ManifestListIterable iterable() {
        return new ManifestListIterable(new ManifestIterator(this.iterator()));
    }

    public ManifestList sorted() {
        ManifestList copy = new ManifestList(new ArrayList<ManifestUtils.CollatedEntry>(), null);
        copy.filterText = this.filterText;
        copy.searchItem = this.searchItem;
        copy.sortingDirection = this.sortingDirection;
        copy.sortingType = this.sortingType;
        copy.addAll((Collection)((Object)this));
        copy.sort((o1, o2) -> {
            if (copy.sortingType == SortingType.NAME) {
                if (copy.sortingDirection == SortingDirection.ASCENDING) {
                    return o1.finalStack.func_82833_r().compareTo(o2.finalStack.func_82833_r());
                }
                return o2.finalStack.func_82833_r().compareTo(o1.finalStack.func_82833_r());
            }
            if (copy.sortingDirection == SortingDirection.ASCENDING) {
                return Integer.compare(o1.finalStack.func_190916_E(), o2.finalStack.func_190916_E());
            }
            return Integer.compare(o2.finalStack.func_190916_E(), o1.finalStack.func_190916_E());
        });
        return copy;
    }

    public void clear() {
        super.clear();
    }

    @Override
    public ManifestList fromBytes(ByteBuf buf) {
        this.clear();
        int entries = buf.readInt();
        for (int i = 0; i < entries; ++i) {
            this.add(ManifestUtils.CollatedEntry.deserialize(buf));
        }
        return this;
    }

    @Override
    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.size());
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            ManifestUtils.CollatedEntry entry = (ManifestUtils.CollatedEntry)iterator.next();
            entry.toBytes(buf);
        }
    }

    public static enum SortingType {
        NAME,
        QUANTITY;

    }

    public static enum SortingDirection {
        ASCENDING,
        DESCENDING;

    }

    public class ManifestIterator
    implements Iterator<ManifestUtils.CollatedEntry> {
        private int slot = 0;
        private Iterator<ManifestUtils.CollatedEntry> iter;

        public ManifestIterator(Iterator<ManifestUtils.CollatedEntry> iter) {
            this.iter = iter;
        }

        public int getSlot() {
            return this.slot;
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public ManifestUtils.CollatedEntry next() {
            ++this.slot;
            return this.iter.next();
        }
    }

    public class ManifestListIterable
    extends ReferenceList.ReferenceListIterable<ManifestUtils.CollatedEntry> {
        public ManifestListIterable(ManifestIterator iter) {
            super(iter);
        }

        public int getSlot() {
            return ((ManifestIterator)this.iter).getSlot();
        }
    }
}

