/*
 * Decompiled with CFR 0.152.
 */
package com.aranaira.arcanearchives.types.lists;

import com.aranaira.arcanearchives.tileentities.ImmanenceTileEntity;
import com.aranaira.arcanearchives.types.IteRef;
import com.aranaira.arcanearchives.types.iterators.TileListIterable;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.util.math.BlockPos;

public interface ITileList
extends Iterable<IteRef> {
    default public boolean containsUUID(UUID uuid) {
        for (IteRef ref : this) {
            if (!ref.uuid.equals(uuid)) continue;
            return true;
        }
        return false;
    }

    default public void updateReference(ImmanenceTileEntity tile) {
        IteRef ref = this.getReference(tile.getUuid());
        if (ref != null) {
            ref.pos = tile.func_174877_v();
            ref.dimension = tile.dimension;
        }
    }

    @Nullable
    default public IteRef getReference(UUID uuid) {
        for (IteRef ref : this) {
            if (!ref.uuid.equals(uuid)) continue;
            return ref;
        }
        return null;
    }

    @Nullable
    default public IteRef getReference(BlockPos pos, int dimension) {
        for (IteRef ref : this) {
            if (!ref.pos.equals((Object)pos) || ref.dimension != dimension) continue;
            return ref;
        }
        return null;
    }

    @Nullable
    default public ImmanenceTileEntity getByUUID(UUID uuid) {
        for (IteRef ref : this) {
            if (!ref.uuid.equals(uuid)) continue;
            return ref.getTile();
        }
        return null;
    }

    default public void updateUUID(UUID oldId, UUID newId) {
        for (IteRef ref : this) {
            if (!ref.uuid.equals(oldId)) continue;
            ref.uuid = newId;
            break;
        }
    }

    default public void removeByUUID(UUID uuid) {
        IteRef toRemove = null;
        for (IteRef ref : this) {
            if (!ref.uuid.equals(uuid)) continue;
            toRemove = ref;
            break;
        }
        if (toRemove != null) {
            this.removeRef(toRemove);
        }
    }

    public boolean isEmpty();

    public void removeRef(IteRef var1);

    default public TileListIterable iterable() {
        return new TileListIterable(this.iterator());
    }

    public int getSize();
}

