/*
 * Decompiled with CFR 0.152.
 */
package com.aranaira.arcanearchives.types.lists;

import com.aranaira.arcanearchives.types.IteRef;
import com.aranaira.arcanearchives.types.iterators.TileListIterable;
import com.aranaira.arcanearchives.types.lists.ITileList;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.stream.Collectors;

public class CombinedTileList
implements ITileList {
    private final List<ITileList> tileLists;

    public CombinedTileList(List<ITileList> references) {
        this.tileLists = references;
        this.tileLists.removeIf(ITileList::isEmpty);
    }

    @Override
    public boolean isEmpty() {
        for (ITileList list : this.tileLists) {
            if (list.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void removeRef(IteRef ref) {
        this.tileLists.forEach(r -> r.removeRef(ref));
    }

    @Override
    public TileListIterable iterable() {
        return new TileListIterable(this.iterator());
    }

    @Override
    public int getSize() {
        int size = 0;
        for (ITileList t : this.tileLists) {
            size += t.getSize();
        }
        return size;
    }

    @Override
    public Iterator<IteRef> iterator() {
        return new CombinedTileListIterator(this.tileLists.stream().map(Iterable::iterator).collect(Collectors.toList()));
    }

    public static class CombinedTileListIterator
    implements Iterator<IteRef> {
        private final Queue<Iterator<IteRef>> queue;
        private Iterator<IteRef> currentIterator;

        public CombinedTileListIterator(List<Iterator<IteRef>> iterators) {
            this.queue = new ArrayDeque<Iterator<IteRef>>(iterators);
            this.currentIterator = this.queue.remove();
        }

        @Override
        public boolean hasNext() {
            if (this.currentIterator.hasNext()) {
                return true;
            }
            if (!this.queue.isEmpty()) {
                this.currentIterator = this.queue.remove();
                return this.currentIterator.hasNext();
            }
            return false;
        }

        @Override
        public IteRef next() {
            return this.currentIterator.next();
        }
    }
}

