/*
 * Decompiled with CFR 0.152.
 */
package com.aranaira.arcanearchives.tileentities;

import com.aranaira.arcanearchives.ArcaneArchives;
import com.aranaira.arcanearchives.inventory.handlers.OptionalUpgradesHandler;
import com.aranaira.arcanearchives.inventory.handlers.SizeUpgradeItemHandler;
import com.aranaira.arcanearchives.inventory.handlers.TankUpgradeItemHandler;
import com.aranaira.arcanearchives.tileentities.ImmanenceTileEntity;
import com.aranaira.arcanearchives.tileentities.interfaces.IUpgradeableStorage;
import com.aranaira.arcanearchives.types.enums.UpgradeType;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;

public class RadiantTankTileEntity
extends ImmanenceTileEntity
implements IUpgradeableStorage {
    public static final int BASE_CAPACITY = 16000;
    private final VoidingFluidTank inventory = new VoidingFluidTank(16000);
    private TankUpgradeItemHandler sizeUpgrades = new TankUpgradeItemHandler(){

        @Override
        public void onContentsChanged() {
            if (!((RadiantTankTileEntity)RadiantTankTileEntity.this).field_145850_b.field_72995_K) {
                RadiantTankTileEntity.this.func_70296_d();
                RadiantTankTileEntity.this.defaultServerSideUpdate();
            }
            RadiantTankTileEntity.this.inventory.setCapacity(RadiantTankTileEntity.this.getCapacity());
        }

        @Override
        public boolean canReduceMultiplierTo(int size) {
            RadiantTankTileEntity te = RadiantTankTileEntity.this;
            return te.inventory.getFluidAmount() <= te.getCapacity(size);
        }
    };
    private OptionalUpgradesHandler optionalUpgrades = new OptionalUpgradesHandler();
    public boolean wasCreativeDrop = false;

    public RadiantTankTileEntity() {
        super("radianttank");
        this.inventory.setOptions(this.optionalUpgrades);
    }

    public int getCapacity(int capacity) {
        return 16000 * (capacity + 1);
    }

    public int getCapacity() {
        return this.getCapacity(this.getModifiedCapacity());
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        this.serializeStack(compound);
        return compound;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.deserializeStack(compound);
    }

    private void validateCapacity() {
        if (this.inventory.getCapacity() != this.getCapacity()) {
            this.inventory.setCapacity(this.getCapacity());
        }
    }

    public NBTTagCompound serializeStack(NBTTagCompound tag) {
        if (this.inventory.getFluid() != null) {
            tag.func_74782_a("Fluid", (NBTBase)this.inventory.writeToNBT(new NBTTagCompound()));
        }
        tag.func_74768_a("upgrade_count", this.sizeUpgrades.getUpgradesCount());
        tag.func_74768_a("maximum_capacity", this.getCapacity());
        tag.func_74782_a("size_upgrades", (NBTBase)this.sizeUpgrades.serializeNBT());
        tag.func_74782_a("optional_upgrades", (NBTBase)this.optionalUpgrades.serializeNBT());
        return tag;
    }

    public VoidingFluidTank getInventory() {
        return this.inventory;
    }

    @Override
    @Nonnull
    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound compound = this.func_189515_b(new NBTTagCompound());
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, compound);
    }

    public void deserializeStack(NBTTagCompound tag) {
        this.sizeUpgrades.deserializeNBT(tag.func_74775_l("size_upgrades"));
        this.optionalUpgrades.deserializeNBT(tag.func_74775_l("optional_upgrades"));
        this.validateCapacity();
        this.inventory.readFromNBT(tag.func_74775_l("Fluid"));
        this.validateCapacity();
    }

    @Override
    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Override
    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
        super.onDataPacket(net, pkt);
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this.inventory);
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public SizeUpgradeItemHandler getSizeUpgradesHandler() {
        return this.sizeUpgrades;
    }

    @Override
    public OptionalUpgradesHandler getOptionalUpgradesHandler() {
        return this.optionalUpgrades;
    }

    @Override
    public boolean handleManipulationInterface(EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (player.field_70170_p.field_72995_K) {
            return true;
        }
        player.openGui((Object)ArcaneArchives.instance, 10, this.field_145850_b, this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p());
        return true;
    }

    @Override
    public int getModifiedCapacity() {
        return this.sizeUpgrades.getUpgradesCount();
    }

    public class VoidingFluidTank
    extends FluidTank {
        private OptionalUpgradesHandler optionals;

        public VoidingFluidTank(int capacity) {
            super(capacity);
            this.optionals = null;
        }

        public void setOptions(OptionalUpgradesHandler optionals) {
            this.optionals = optionals;
        }

        public boolean isVoiding() {
            return this.optionals.hasUpgrade(UpgradeType.VOID) && this.getCapacity() == this.getFluidAmount();
        }

        public int fillInternal(FluidStack resource, boolean doFill) {
            if (this.isVoiding() && resource != null && this.fluid != null && this.fluid.isFluidEqual(resource)) {
                int result = resource.amount;
                super.fillInternal(resource, doFill);
                resource.amount = 0;
                RadiantTankTileEntity.this.func_70296_d();
                return result;
            }
            int result = super.fillInternal(resource, doFill);
            RadiantTankTileEntity.this.func_70296_d();
            RadiantTankTileEntity.this.defaultServerSideUpdate();
            return result;
        }

        public boolean canFill() {
            if (this.isVoiding()) {
                return true;
            }
            return super.canFill();
        }

        public FluidStack drain(FluidStack resource, boolean doDrain) {
            FluidStack result = super.drain(resource, doDrain);
            RadiantTankTileEntity.this.func_70296_d();
            RadiantTankTileEntity.this.defaultServerSideUpdate();
            return result;
        }

        public FluidStack drain(int maxDrain, boolean doDrain) {
            FluidStack result = super.drain(maxDrain, doDrain);
            RadiantTankTileEntity.this.func_70296_d();
            RadiantTankTileEntity.this.defaultServerSideUpdate();
            return result;
        }
    }

    public static class Tags {
        public static final String HANDLER_ITEM = "handler_item";
        public static final String SIZE_UPGRADES = "size_upgrades";
        public static final String OPTIONAL_UPGRADES = "optional_upgrades";
        public static final String UPGRADE_COUNT = "upgrade_count";
        public static final String MAXIMUM_CAPACITY = "maximum_capacity";

        private Tags() {
        }
    }
}

