/*
 * Decompiled with CFR 0.152.
 */
package com.aranaira.arcanearchives.tileentities;

import com.aranaira.arcanearchives.blocks.RawQuartzCluster;
import com.aranaira.arcanearchives.config.ConfigHandler;
import com.aranaira.arcanearchives.data.DataHelper;
import com.aranaira.arcanearchives.data.ServerNetwork;
import com.aranaira.arcanearchives.init.BlockRegistry;
import com.aranaira.arcanearchives.init.SoundRegistry;
import com.aranaira.arcanearchives.tileentities.ImmanenceTileEntity;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class RadiantResonatorTileEntity
extends ImmanenceTileEntity {
    public static Random rand = new Random();
    private int growth = 0;
    private int ticks = 0;
    private boolean canTick = false;
    private boolean breaking = false;

    public RadiantResonatorTileEntity() {
        super("radiant_resonator_tile_entity");
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        ++this.ticks;
        if (this.field_145850_b.field_72995_K || this.networkId == null || this.networkId.equals(DataHelper.INVALID)) {
            return;
        }
        ServerNetwork network = this.getServerNetwork();
        if (network == null) {
            return;
        }
        EntityPlayer player = network.getPlayer();
        if (player == null) {
            this.canTick = false;
            return;
        }
        this.canTick = true;
        int ticksRequired = ConfigHandler.serverSideConfig.ResonatorTickTime;
        this.func_70296_d();
        if (this.field_145850_b.func_175623_d(this.field_174879_c.func_177984_a())) {
            if (this.growth < ticksRequired) {
                ++this.growth;
            } else {
                this.growth = 0;
                this.field_145850_b.func_175656_a(this.field_174879_c.func_177984_a(), BlockRegistry.RAW_QUARTZ.func_176223_P());
                BlockPos up = this.field_174879_c.func_177984_a();
                List entities = this.field_145850_b.func_72872_a(EntityOcelot.class, new AxisAlignedBB((double)up.func_177958_n() - 0.9, (double)up.func_177956_o() - 0.9, (double)up.func_177952_p() - 0.9, (double)up.func_177958_n() + 0.9, (double)up.func_177956_o() + 0.9, (double)up.func_177952_p() + 0.9));
                for (EntityOcelot ocelot : entities) {
                    ocelot.field_70181_x += (double)(rand.nextFloat() * 5.0f);
                    ocelot.field_70159_w += (double)((rand.nextFloat() - 0.5f) * 3.0f);
                    ocelot.field_70179_y += (double)((rand.nextFloat() - 0.5f) * 3.0f);
                }
                if (ConfigHandler.soundConfig.resonatorComplete && ConfigHandler.soundConfig.useSounds) {
                    this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundRegistry.RESONATOR_COMPLETE, SoundCategory.BLOCKS, 1.0f, 1.0f);
                }
            }
        }
        if (this.ticks % 50 == 0) {
            this.defaultServerSideUpdate();
        }
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("current_tick", this.growth);
        compound.func_74757_a("can_tick", this.canTick);
        return compound;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (compound.func_74764_b("current_tick")) {
            this.growth = compound.func_74762_e("current_tick");
        }
        if (compound.func_74764_b("can_tick")) {
            this.canTick = compound.func_74767_n("can_tick");
        }
    }

    public int getPercentageComplete() {
        return (int)Math.floor((double)this.growth / (double)ConfigHandler.serverSideConfig.ResonatorTickTime * 100.0);
    }

    @Override
    @Nonnull
    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound compound = this.func_189515_b(new NBTTagCompound());
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, compound);
    }

    @Override
    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Override
    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
        super.onDataPacket(net, pkt);
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    @Override
    public void breakBlock(@Nullable IBlockState state, boolean harvest) {
        ServerNetwork network;
        super.breakBlock(state, harvest);
        this.breaking = true;
        if (this.field_145850_b.field_72995_K) {
            this.updateSound();
        }
        if ((network = DataHelper.getServerNetwork(this.networkId)) != null) {
            network.removeTile(this);
        }
    }

    public TickResult canTick() {
        if (this.field_145850_b.func_175623_d(this.field_174879_c.func_177984_a())) {
            if (!this.canTick) {
                return TickResult.OFFLINE;
            }
            return TickResult.TICKING;
        }
        IBlockState up = this.field_145850_b.func_180495_p(this.field_174879_c.func_177984_a());
        if (up.func_177230_c() instanceof RawQuartzCluster) {
            return TickResult.HARVEST_WAITING;
        }
        return TickResult.OBSTRUCTION;
    }

    @Override
    protected boolean shouldPlaySound() {
        return ConfigHandler.soundConfig.resonatorTicking && super.shouldPlaySound() && !this.breaking && this.canTick() == TickResult.TICKING && this.field_145850_b.func_175623_d(this.field_174879_c.func_177984_a());
    }

    @Override
    protected float getVolume() {
        return ConfigHandler.soundConfig.resonatorVolume;
    }

    @Override
    protected boolean hasSound() {
        return true;
    }

    @Override
    protected ResourceLocation getSound() {
        return new ResourceLocation("arcanearchives", "resonator.loop");
    }

    public static class Tags {
        public static final String CURRENT_TICK = "current_tick";
        public static final String CAN_TICK = "can_tick";
    }

    public static enum TickResult {
        OBSTRUCTION("obstruction", TextFormatting.RED),
        HARVEST_WAITING("harvestable", TextFormatting.GOLD),
        OFFLINE("offline", TextFormatting.DARK_RED),
        TICKING("resonating", TextFormatting.GREEN);

        private String key;
        private TextFormatting format;

        private TickResult(String key, TextFormatting format) {
            this.key = key;
            this.format = format;
        }

        public String getKey() {
            return "arcanearchives.data.tooltip.resonator_status." + this.key;
        }

        public TextFormatting getFormat() {
            return this.format;
        }
    }
}

