/*
 * Decompiled with CFR 0.152.
 */
package com.aranaira.arcanearchives.tileentities;

import com.aranaira.arcanearchives.inventory.ContainerRadiantCraftingTable;
import com.aranaira.arcanearchives.recipe.fastcrafting.FastCraftingRecipe;
import com.aranaira.arcanearchives.tileentities.ImmanenceTileEntity;
import com.aranaira.arcanearchives.tileentities.interfaces.IManifestTileEntity;
import com.aranaira.arcanearchives.util.NBTUtils;
import com.aranaira.arcanearchives.util.WorldUtil;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import net.minecraftforge.items.wrapper.InvWrapper;

public class RadiantCraftingTableTileEntity
extends ImmanenceTileEntity
implements IManifestTileEntity {
    private ItemStackHandler persistentMatrix = new ItemStackHandler(9);
    private RecipeList recipeList = new RecipeList();

    public RadiantCraftingTableTileEntity() {
        super("radiantcraftingtable");
    }

    @Override
    public String getDescriptor() {
        return "Radiant Crafting Table";
    }

    @Override
    public String getChestName() {
        return "";
    }

    public ItemStackHandler getInventory() {
        return this.persistentMatrix;
    }

    public IRecipe getRecipe(int index) {
        return this.recipeList.get(index);
    }

    public void setRecipe(int index, IRecipe recipe) {
        this.recipeList.set(index, recipe);
        this.func_70296_d();
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (compound.func_74764_b("inventory")) {
            this.persistentMatrix.deserializeNBT(compound.func_74775_l("inventory"));
        }
        for (int i = 0; i < 3; ++i) {
            this.recipeList.set(i, null);
        }
        this.recipeList.set(0, NBTUtils.getRecipe(compound, "recipe1"));
        this.recipeList.set(1, NBTUtils.getRecipe(compound, "recipe2"));
        this.recipeList.set(2, NBTUtils.getRecipe(compound, "recipe3"));
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound = super.func_189515_b(compound);
        compound.func_74782_a("inventory", (NBTBase)this.persistentMatrix.serializeNBT());
        NBTUtils.setRecipe(compound, "recipe1", this.recipeList.get(0));
        NBTUtils.setRecipe(compound, "recipe2", this.recipeList.get(1));
        NBTUtils.setRecipe(compound, "recipe3", this.recipeList.get(2));
        return compound;
    }

    @Override
    @Nonnull
    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound compound = this.func_189515_b(new NBTTagCompound());
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, compound);
    }

    @Override
    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Override
    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
        super.onDataPacket(net, pkt);
    }

    public void blockBroken() {
        if (!this.field_145850_b.field_72995_K) {
            WorldUtil.spawnInventoryInWorld(this.field_145850_b, this.func_174877_v(), (IItemHandler)this.persistentMatrix);
        }
    }

    public boolean canCraftRecipe(EntityPlayer player, int index) {
        IRecipe recipe = this.recipeList.get(index);
        if (recipe == null) {
            return false;
        }
        if (!(player.field_71070_bA instanceof ContainerRadiantCraftingTable)) {
            return false;
        }
        FastCraftingRecipe fast = new FastCraftingRecipe(recipe, this.field_145850_b);
        IItemHandler playerInventory = (IItemHandler)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.UP);
        CombinedInvWrapper inv = new CombinedInvWrapper(new IItemHandlerModifiable[]{(IItemHandlerModifiable)playerInventory, new InvWrapper((IInventory)((ContainerRadiantCraftingTable)player.field_71070_bA).getCraftMatrix())});
        return fast.matches((IItemHandler)inv);
    }

    public void tryCraftingRecipe(EntityPlayer player, int index) {
        IRecipe recipe = this.recipeList.get(index);
        if (recipe == null) {
            return;
        }
        if (player.field_71070_bA instanceof ContainerRadiantCraftingTable) {
            InventoryCrafting matrix = ((ContainerRadiantCraftingTable)player.field_71070_bA).getCraftMatrix();
            FastCraftingRecipe fast = new FastCraftingRecipe(recipe, this.field_145850_b);
            IItemHandler playerInventory = (IItemHandler)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.UP);
            CombinedInvWrapper inv = new CombinedInvWrapper(new IItemHandlerModifiable[]{new InvWrapper((IInventory)matrix), (IItemHandlerModifiable)playerInventory});
            if (fast.matches((IItemHandler)inv)) {
                fast.consumeAndHandleInventory(fast, (IItemHandler)inv, player, null, null, null, null);
                List<ItemStack> returned = fast.getReturned();
                for (ItemStack result : returned) {
                    if ((result = ItemHandlerHelper.insertItemStacked((IItemHandler)playerInventory, (ItemStack)result, (boolean)false)).func_190926_b()) continue;
                    Block.func_180635_a((World)this.field_145850_b, (BlockPos)this.func_174877_v(), (ItemStack)result);
                }
            }
        }
    }

    private static class RecipeList {
        private IRecipe recipe1;
        private IRecipe recipe2;
        private IRecipe recipe3;

        private RecipeList() {
        }

        public IRecipe get(int index) {
            switch (index) {
                case 0: {
                    return this.recipe1;
                }
                case 1: {
                    return this.recipe2;
                }
                case 2: {
                    return this.recipe3;
                }
            }
            return null;
        }

        public void set(int index, IRecipe recipe) {
            switch (index) {
                case 0: {
                    this.recipe1 = recipe;
                    break;
                }
                case 1: {
                    this.recipe2 = recipe;
                    break;
                }
                case 2: {
                    this.recipe3 = recipe;
                }
            }
        }
    }

    public static class Tags {
        public static final String RECIPE1 = "recipe1";
        public static final String RECIPE2 = "recipe2";
        public static final String RECIPE3 = "recipe3";
    }
}

