/*
 * Decompiled with CFR 0.152.
 */
package com.aranaira.arcanearchives.tileentities;

import com.aranaira.arcanearchives.ArcaneArchives;
import com.aranaira.arcanearchives.config.ConfigHandler;
import com.aranaira.arcanearchives.data.ServerNetwork;
import com.aranaira.arcanearchives.init.BlockRegistry;
import com.aranaira.arcanearchives.inventory.handlers.ExtendedItemStackHandler;
import com.aranaira.arcanearchives.inventory.handlers.ITrackingHandler;
import com.aranaira.arcanearchives.tileentities.ImmanenceTileEntity;
import com.aranaira.arcanearchives.tileentities.interfaces.IBrazierRouting;
import com.aranaira.arcanearchives.tileentities.interfaces.IManifestTileEntity;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class RadiantChestTileEntity
extends ImmanenceTileEntity
implements IManifestTileEntity,
IBrazierRouting {
    private final TrackingExtendedItemStackHandler inventory = new TrackingExtendedItemStackHandler(54);
    private ItemStack displayStack = ItemStack.field_190927_a;
    private EnumFacing displayFacing = EnumFacing.NORTH;
    private IBrazierRouting.BrazierRoutingType routingType = IBrazierRouting.BrazierRoutingType.ANY;
    public String chestName = "";

    public RadiantChestTileEntity() {
        super("radiantchest");
    }

    private String describe() {
        return this.field_174879_c.toString() + " in " + this.dimension;
    }

    public ItemStack getDisplayStack() {
        return this.displayStack;
    }

    public void unsetDisplayStack() {
        ArcaneArchives.logger.debug("Unset displayStack on " + this.describe());
        this.displayStack = ItemStack.field_190927_a;
        this.func_70296_d();
    }

    public void setDisplayStack(ItemStack newStack) {
        if (newStack.func_190926_b()) {
            ArcaneArchives.logger.debug("Called setDisplayStack with an empty stack!", (Throwable)new IllegalArgumentException(this.describe()));
        } else {
            ArcaneArchives.logger.debug("Set displayStack to " + newStack.toString() + " on " + this.describe());
        }
        this.displayStack = newStack;
        this.func_70296_d();
    }

    @Override
    public String getChestName() {
        return this.chestName;
    }

    public void unsetChestName() {
        this.chestName = "";
        this.func_70296_d();
    }

    public void setChestName(String newName) {
        if (newName.isEmpty()) {
            ArcaneArchives.logger.debug("Called setChestName with an empty string!", (Throwable)new IllegalArgumentException(this.describe()));
        }
        this.chestName = newName;
        this.func_70296_d();
    }

    @Override
    public void firstJoinedNetwork(ServerNetwork network) {
        super.firstJoinedNetwork(network);
        if (network.getNoNewDefault()) {
            this.routingType = IBrazierRouting.BrazierRoutingType.NO_NEW_STACKS;
            this.func_70296_d();
            this.defaultServerSideUpdate();
        }
    }

    public Int2IntOpenHashMap getOrCalculateReference(boolean force) {
        if (force) {
            this.inventory.manualRecount();
        }
        return this.inventory.getItemReference();
    }

    @Override
    public Int2IntOpenHashMap getOrCalculateReference() {
        return this.getOrCalculateReference(false);
    }

    @Override
    public IBrazierRouting.BrazierRoutingType getRoutingType() {
        return this.routingType;
    }

    @Override
    public boolean isTileInvalid() {
        return this.func_145837_r();
    }

    @Override
    public int totalEmptySlots() {
        return this.inventory.getEmptyCount();
    }

    @Override
    public int totalSlots() {
        return this.inventory.getSlots();
    }

    @Override
    public int slotMultiplier() {
        return ConfigHandler.serverSideConfig.RadiantMultiplier;
    }

    @Override
    public ItemStack acceptStack(ItemStack stack, boolean simulate) {
        ItemStack result = ItemHandlerHelper.insertItemStacked((IItemHandler)this.inventory, (ItemStack)stack, (boolean)simulate);
        this.func_70296_d();
        return result;
    }

    public void toggleRoutingType() {
        this.routingType = this.routingType == IBrazierRouting.BrazierRoutingType.ANY ? IBrazierRouting.BrazierRoutingType.NO_NEW_STACKS : IBrazierRouting.BrazierRoutingType.ANY;
        this.func_70296_d();
    }

    public void setDisplay(ItemStack displayStack, EnumFacing facing) {
        this.setDisplayStack(displayStack);
        this.displayFacing = facing;
    }

    public EnumFacing getDisplayFacing() {
        return this.displayFacing;
    }

    @Override
    public String getDescriptor() {
        if (this.getChestName().isEmpty()) {
            return "Chest";
        }
        return "Chest: " + this.getChestName();
    }

    public TrackingExtendedItemStackHandler getInventory() {
        return this.inventory;
    }

    @Override
    @Nonnull
    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound compound = this.func_189515_b(new NBTTagCompound());
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, compound);
    }

    @Override
    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74782_a("inventory", (NBTBase)this.inventory.serializeNBT());
        if (this.chestName != null && !this.chestName.isEmpty()) {
            compound.func_74778_a("chestName", this.chestName);
        }
        compound.func_74768_a("displayFacing", this.displayFacing.func_176745_a());
        if (!this.displayStack.func_190926_b()) {
            compound.func_74782_a("displayStack", (NBTBase)this.displayStack.serializeNBT());
        }
        compound.func_74768_a("routingType", this.routingType.ordinal());
        return compound;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (!compound.func_74764_b("inventory")) {
            ArcaneArchives.logger.info(String.format("Radiant Chest tile entity at %d/%d/%d is missing its inventory.", this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p()));
        }
        this.inventory.deserializeNBT(compound.func_74775_l("inventory"));
        if (compound.func_74764_b("chestName")) {
            this.setChestName(compound.func_74779_i("chestName"));
        }
        this.displayFacing = EnumFacing.func_82600_a((int)compound.func_74762_e("displayFacing"));
        if (compound.func_74764_b("displayStack")) {
            this.setDisplayStack(new ItemStack(compound.func_74775_l("displayStack")));
        }
        this.routingType = IBrazierRouting.BrazierRoutingType.fromInt(compound.func_74762_e("routingType"));
    }

    @Override
    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
        super.onDataPacket(net, pkt);
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.inventory);
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public int countEmptySlots() {
        int empty = 0;
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            if (!this.inventory.getStackInSlot(i).func_190926_b()) continue;
            ++empty;
        }
        return empty;
    }

    public class TrackingExtendedItemStackHandler
    extends ExtendedItemStackHandler
    implements ITrackingHandler {
        private Int2IntOpenHashMap itemReference;
        private boolean invalid;
        private int emptySlots;

        public TrackingExtendedItemStackHandler(int size) {
            super(size);
            this.itemReference = new Int2IntOpenHashMap();
            this.invalid = false;
            this.emptySlots = 0;
            this.itemReference.defaultReturnValue(0);
        }

        @Override
        public void deserializeNBT(NBTTagCompound nbt) {
            super.deserializeNBT(nbt);
            if (RadiantChestTileEntity.this.field_145850_b == null || !((RadiantChestTileEntity)RadiantChestTileEntity.this).field_145850_b.field_72995_K) {
                this.manualRecount();
            }
        }

        @Override
        public Int2IntOpenHashMap getItemReference() {
            if (this.invalid) {
                this.invalid = false;
                this.manualRecount();
            }
            return this.itemReference;
        }

        @Override
        public int totalSlots() {
            return this.getSlots();
        }

        @Override
        public int getEmptyCount() {
            return this.emptySlots;
        }

        @Override
        public void setEmptyCount(int amount) {
            this.emptySlots = amount;
        }

        @Override
        public void incrementEmptyCount() {
            ++this.emptySlots;
        }

        @Override
        public void decrementEmptyCount() {
            --this.emptySlots;
        }

        @Override
        public void invalidate() {
            this.invalid = true;
        }

        public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
            this.invalidate();
            super.setStackInSlot(slot, stack);
            RadiantChestTileEntity.this.field_145850_b.func_175666_e(RadiantChestTileEntity.this.field_174879_c, (Block)BlockRegistry.RADIANT_CHEST);
            RadiantChestTileEntity.this.func_70296_d();
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (!simulate) {
                this.invalidate();
            }
            ItemStack result = super.insertItem(slot, stack, simulate);
            if (!simulate && (result.func_190926_b() || result.func_190916_E() != stack.func_190916_E())) {
                RadiantChestTileEntity.this.field_145850_b.func_175666_e(RadiantChestTileEntity.this.field_174879_c, (Block)BlockRegistry.RADIANT_CHEST);
                RadiantChestTileEntity.this.func_70296_d();
            }
            return result;
        }

        @Override
        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (!simulate) {
                this.invalidate();
            }
            ItemStack result = super.extractItem(slot, amount, simulate);
            if (!simulate && !result.func_190926_b()) {
                RadiantChestTileEntity.this.field_145850_b.func_175666_e(RadiantChestTileEntity.this.field_174879_c, (Block)BlockRegistry.RADIANT_CHEST);
                RadiantChestTileEntity.this.func_70296_d();
            }
            return result;
        }
    }

    public static class Tags {
        public static final String CHEST_NAME = "chestName";
        public static final String DISPLAY_STACK = "displayStack";
        public static final String DISPLAY_FACING = "displayFacing";
        public static final String ROUTING_TYPE = "routingType";

        private Tags() {
        }
    }
}

