/*
 * Decompiled with CFR 0.152.
 */
package com.aranaira.arcanearchives.tileentities;

import com.aranaira.arcanearchives.ArcaneArchives;
import com.aranaira.arcanearchives.blocks.MultiblockSize;
import com.aranaira.arcanearchives.config.ConfigHandler;
import com.aranaira.arcanearchives.data.DataHelper;
import com.aranaira.arcanearchives.data.ServerNetwork;
import com.aranaira.arcanearchives.events.ServerTickHandler;
import com.aranaira.arcanearchives.tileentities.AATileEntity;
import com.aranaira.arcanearchives.types.MachineSound;
import com.aranaira.arcanearchives.util.ManifestTrackingUtils;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.audio.ISound;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ImmanenceTileEntity
extends AATileEntity
implements ITickable {
    public UUID uuid = null;
    public UUID networkId = null;
    public boolean hasBeenAddedToNetwork = false;
    public int dimension;
    public MultiblockSize size;
    private BlockPos lastPosition;
    private ServerNetwork network;
    private int ticks = 0;
    private boolean fake = false;
    @SideOnly(value=Side.CLIENT)
    protected MachineSound sound;

    public ImmanenceTileEntity(String name) {
        this.setName(name);
    }

    public ImmanenceTileEntity(String name, boolean fake) {
        this(name);
        this.fake = fake;
    }

    public void tick() {
        ++this.ticks;
    }

    public int ticks() {
        return this.ticks;
    }

    @Override
    public boolean isActive() {
        return true;
    }

    public UUID getNetworkId() {
        return this.networkId;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public void setNetworkId(UUID newId) {
        this.networkId = newId;
    }

    public void onLoad() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K && !this.fake) {
            ServerTickHandler.incomingITE(this);
            ArcaneArchives.logger.debug(String.format("Loaded a tile entity with the class %s into the queue.", ((Object)((Object)this)).getClass().getName()));
        } else if (this.field_145850_b == null) {
            ArcaneArchives.logger.debug("TileEntity loaded in with a null world. WTF?");
        }
        super.onLoad();
    }

    public void joinedNetwork(ServerNetwork network) {
    }

    public void firstJoinedNetwork(ServerNetwork network) {
    }

    @Nullable
    public ServerNetwork getServerNetwork() {
        if (this.network == null && this.networkId != null) {
            this.network = DataHelper.getServerNetwork(this.networkId);
        }
        return this.network;
    }

    public void tryGenerateUUID() {
        ServerNetwork network;
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K && this.networkId != null && this.uuid == null && !this.fake && (network = this.getServerNetwork()) != null) {
            this.uuid = network.generateTileUuid();
            this.firstJoinedNetwork(this.getServerNetwork());
            this.func_70296_d();
            this.defaultServerSideUpdate();
        }
    }

    public boolean handleManipulationInterface(EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return false;
    }

    public void func_145839_a(NBTTagCompound compound) {
        if (compound.func_74764_b("playerId")) {
            this.networkId = UUID.fromString(compound.func_74779_i("playerId"));
        } else {
            ArcaneArchives.logger.debug(String.format("Tile entity of class %s didn't have a network ID", ((Object)((Object)this)).getClass().getName()));
        }
        if (compound.func_74764_b("tileId")) {
            ServerNetwork network;
            UUID newId = UUID.fromString(compound.func_74779_i("tileId"));
            if (this.uuid != null && !this.uuid.equals(newId) && !this.field_145850_b.field_72995_K && (network = this.getServerNetwork()) != null) {
                network.handleTileIdChange(this.uuid, newId);
            }
            this.uuid = newId;
        }
        if (this.uuid == null) {
            this.tryGenerateUUID();
        }
        this.dimension = compound.func_74762_e("dim");
        super.func_145839_a(compound);
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        if (this.networkId != null) {
            compound.func_74778_a("playerId", this.networkId.toString());
        }
        if (this.uuid != null) {
            compound.func_74778_a("tileId", this.uuid.toString());
        }
        compound.func_74768_a("dim", this.dimension);
        return super.func_189515_b(compound);
    }

    public void tileMoved(BlockPos oldPosition, BlockPos newPosition) {
        ServerNetwork network = this.getServerNetwork();
        network.tileEntityMoved(this.uuid, newPosition);
    }

    public void func_73660_a() {
        if (this.lastPosition == null) {
            this.lastPosition = this.func_174877_v();
        }
        if (!this.func_174877_v().equals((Object)this.lastPosition)) {
            this.tileMoved(this.func_174877_v(), this.lastPosition);
        }
        if (this.field_145850_b.field_72995_K) {
            this.updateSound();
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.field_145850_b.field_72995_K) {
            this.updateSound();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isBeingTracked() {
        return ManifestTrackingUtils.get(this.dimension, this.func_174877_v()) != null;
    }

    @Nonnull
    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound compound = this.func_189515_b(new NBTTagCompound());
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, compound);
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
        super.onDataPacket(net, pkt);
    }

    protected boolean shouldPlaySound() {
        return this.hasSound() && !this.func_145837_r();
    }

    protected boolean hasSound() {
        return false;
    }

    protected ResourceLocation getSound() {
        return null;
    }

    protected float getVolume() {
        return 1.0f;
    }

    protected float getPitch() {
        return 1.0f;
    }

    public int getNetworkPriority() {
        return -1;
    }

    @SideOnly(value=Side.CLIENT)
    protected void updateSound() {
        if (ConfigHandler.soundConfig.useSounds) {
            ResourceLocation soundRL = this.getSound();
            if (this.shouldPlaySound() && soundRL != null) {
                if (this.sound == null) {
                    this.sound = new MachineSound(soundRL, (float)this.field_174879_c.func_177958_n() + 0.5f, (float)this.field_174879_c.func_177956_o() + 0.5f, (float)this.field_174879_c.func_177952_p() + 0.5f, this.getVolume(), this.getPitch());
                    FMLClientHandler.instance().getClient().func_147118_V().func_147682_a((ISound)this.sound);
                }
            } else if (this.sound != null) {
                this.sound.endPlaying();
                this.sound = null;
            }
        }
    }

    public static class Tags {
        public static final String PLAYER_ID = "playerId";
        public static final String DIM = "dim";
        public static final String TILE_ID = "tileId";
    }
}

